/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRecipe;
import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRegistry;
import WayofTime.alchemicalWizardry.client.nei.widgets.ReagentInfo;
import WayofTime.alchemicalWizardry.client.nei.widgets.RitualInfo;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class NEIBindingRitualHandler
extends TemplateRecipeHandler {
    private static final RitualInfo ritualInfo = new RitualInfo(1.0f, "AW006Binding");
    private static final ReagentInfo reagentInfo = new ReagentInfo(1.0f);

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.bindingritual") && ((Object)((Object)this)).getClass() == NEIBindingRitualHandler.class) {
            for (BindingRecipe recipe : BindingRegistry.bindingRecipes) {
                if (recipe == null || recipe.outputItem == null) continue;
                this.arecipes.add(new CachedBindingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (BindingRecipe recipe : BindingRegistry.bindingRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)recipe.outputItem, (ItemStack)result) || recipe.outputItem == null) continue;
            this.arecipes.add(new CachedBindingRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (BindingRecipe recipe : BindingRegistry.bindingRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)recipe.requiredItem, (ItemStack)ingredient) || recipe.outputItem == null) continue;
            this.arecipes.add(new CachedBindingRecipe(recipe));
        }
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        if (recipe == 0) {
            ritualInfo.onDraw(0, 0);
            reagentInfo.onDraw(150, 0);
        }
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipeIndex) {
        if (GuiContainerManager.shouldShowTooltip(gui) && currenttip.isEmpty()) {
            TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
            Point mousePos = GuiDraw.getMousePosition();
            if (recipeIndex == 0 && cRecipe instanceof CachedBindingRecipe) {
                if (ritualInfo.getRect(gui).contains(mousePos)) {
                    ritualInfo.onHover(currenttip);
                } else if (reagentInfo.getRect(gui).contains(mousePos)) {
                    currenttip.add(StatCollector.func_74838_a((String)"nei.recipe.reagent.none"));
                }
            }
        }
        return super.handleTooltip(gui, currenttip, recipeIndex);
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.bindingritual";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 20, 22, 16), "alchemicalwizardry.bindingritual", new Object[0]));
    }

    public String getRecipeName() {
        return "Binding Ritual";
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/bindingRitual.png").toString();
    }

    public class CachedBindingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack input;
        private final PositionedStack output;

        public CachedBindingRecipe(BindingRecipe recipe) {
            super((TemplateRecipeHandler)NEIBindingRitualHandler.this);
            this.input = new PositionedStack((Object)recipe.requiredItem, 37, 21, false);
            this.output = new PositionedStack((Object)recipe.outputItem, 110, 21, false);
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

