/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.commands.sub;

import WayofTime.alchemicalWizardry.api.command.SubCommandBase;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class SubCommandOrb
extends SubCommandBase {
    public SubCommandOrb(ICommand parent) {
        super(parent, "orb");
    }

    @Override
    public String getArgUsage(ICommandSender commandSender) {
        return StatCollector.func_74838_a((String)"commands.orb.usage");
    }

    @Override
    public String getHelpText() {
        return StatCollector.func_74838_a((String)"commands.orb.help");
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void processSubCommand(ICommandSender commandSender, String[] args) {
        super.processSubCommand(commandSender, args);
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                return;
            }
            String givenName = commandSender.func_70005_c_();
            if (args.length > 1) {
                givenName = args[1];
            }
            boolean displayHelp = this.isBounded(0, 2, args.length);
            try {
                switch (ValidCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH))) {
                    case SET: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.SET.help, new Object[0]);
                            break;
                        }
                        if (args.length == 3) {
                            if (SubCommandOrb.isInteger(args[2])) {
                                int amount = Integer.parseInt(args[2]);
                                SoulNetworkHandler.setMaxOrbToMax(givenName, amount);
                                this.displaySuccessString(commandSender, "commands.success", new Object[0]);
                                break;
                            }
                            this.displayErrorString(commandSender, "commands.error.arg.invalid", new Object[0]);
                            break;
                        }
                        this.displayErrorString(commandSender, "commands.error.arg.missing", new Object[0]);
                        break;
                    }
                    case GET: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.GET.help, new Object[0]);
                            break;
                        }
                        if (args.length <= 1) break;
                        commandSender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"message.orb.currenttier", (Object[])new Object[]{SoulNetworkHandler.getCurrentMaxOrb(givenName)})));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.displayErrorString(commandSender, "commands.error.404", new Object[0]);
            }
        }
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    private static enum ValidCommands {
        SET("commands.orb.set.help"),
        GET("commands.orb.get.help");

        public String help;

        private ValidCommands(String help) {
            this.help = help;
        }
    }
}

