/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IAlchemyGoggles;
import WayofTime.alchemicalWizardry.api.items.interfaces.ILPGauge;
import WayofTime.alchemicalWizardry.api.items.interfaces.IReagentManipulator;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.items.sigil.SigilDivination;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S06PacketUpdateHealth;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class SpellHelper {
    public static Random rand = new Random();
    public static final double root2 = Math.sqrt(2.0);
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    public static double protCoeff = 0.875;
    public static double scalCoeff = 0.8;

    public static boolean canEntityBeSeen(Entity entity, Entity entity2) {
        return entity.field_70170_p.func_72901_a(SpellHelper.createVec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), SpellHelper.createVec3(entity2.field_70165_t, entity2.field_70163_u, entity2.field_70161_v), false) == null;
    }

    public static Vec3 createVec3(double x, double y, double z) {
        return APISpellHelper.createVec3(x, y, z);
    }

    public static void smeltBlockInWorld(World world, int posX, int posY, int posZ) {
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == null) {
            return;
        }
        int meta = world.func_72805_g(posX, posY, posZ);
        ItemStack smeltedStack = recipes.func_151395_a(new ItemStack(block, 1, meta));
        if (smeltedStack != null && smeltedStack.func_77973_b() instanceof ItemBlock) {
            world.func_147465_d(posX, posY, posZ, ((ItemBlock)smeltedStack.func_77973_b()).field_150939_a, smeltedStack.func_77960_j(), 3);
        }
    }

    public static boolean canPlayerSeeAlchemy(EntityPlayer player) {
        if (player != null) {
            Item item;
            ItemStack stack = player.func_82169_q(3);
            if (stack != null && (item = stack.func_77973_b()) instanceof IAlchemyGoggles && ((IAlchemyGoggles)item).showIngameHUD(player.field_70170_p, stack, player)) {
                return true;
            }
            ItemStack heldStack = player.func_70694_bm();
            if (heldStack != null && heldStack.func_77973_b() instanceof IReagentManipulator) {
                return true;
            }
        }
        return false;
    }

    public static boolean canPlayerSeeLPBar(EntityPlayer player) {
        if (player != null) {
            for (int i = 0; i < 4; ++i) {
                Item item;
                ItemStack stack = player.func_82169_q(i);
                if (stack == null || !((item = stack.func_77973_b()) instanceof ILPGauge) || !((ILPGauge)item).canSeeLPBar(stack)) continue;
                return true;
            }
            ItemStack heldStack = player.func_70694_bm();
            if (heldStack != null && heldStack.func_77973_b() instanceof SigilDivination) {
                return true;
            }
        }
        return false;
    }

    public static List<Entity> getEntitiesInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static List<EntityLivingBase> getLivingEntitiesInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static List<EntityItem> getItemsInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static List<EntityPlayer> getPlayersInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static double gaussian(double d) {
        return d * ((double)rand.nextFloat() - 0.5);
    }

    public static Vec3 getEntityBlockVector(Entity entity) {
        int posX = (int)Math.round(entity.field_70165_t - 0.5);
        int posY = (int)entity.field_70163_u;
        int posZ = (int)Math.round(entity.field_70161_v - 0.5);
        entity.func_70040_Z();
        return Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
    }

    public static ForgeDirection getDirectionForLookVector(Vec3 lookVec) {
        double distance = lookVec.func_72433_c();
        if (lookVec.field_72448_b > distance * 0.9) {
            return ForgeDirection.UP;
        }
        if (lookVec.field_72448_b < distance * -0.9) {
            return ForgeDirection.DOWN;
        }
        return SpellHelper.getCompassDirectionForLookVector(lookVec);
    }

    public static ForgeDirection getCompassDirectionForLookVector(Vec3 lookVec) {
        double radius = Math.sqrt(Math.pow(lookVec.field_72450_a, 2.0) + Math.pow(lookVec.field_72449_c, 2.0));
        if (lookVec.field_72449_c > radius * 1.0 / root2) {
            return ForgeDirection.SOUTH;
        }
        if (lookVec.field_72449_c < -radius * 1.0 / root2) {
            return ForgeDirection.NORTH;
        }
        if (lookVec.field_72450_a > radius * 1.0 / root2) {
            return ForgeDirection.EAST;
        }
        if (lookVec.field_72450_a < -radius * 1.0 / root2) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.EAST;
    }

    public static boolean freezeWaterBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150432_aD);
            return true;
        }
        return false;
    }

    public static String getUsername(EntityPlayer player) {
        return SoulNetworkHandler.getUsername(player);
    }

    public static EntityPlayer getPlayerForUsername(String str) {
        return SoulNetworkHandler.getPlayerForUsername(str);
    }

    public static void sendParticleToPlayer(EntityPlayer player, String str, double xCoord, double yCoord, double zCoord, double xVel, double yVel, double zVel) {
        if (player instanceof EntityPlayerMP) {
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getParticlePacket(str, xCoord, yCoord, zCoord, xVel, yVel, zVel), (EntityPlayerMP)player);
        }
    }

    public static void sendIndexedParticleToPlayer(EntityPlayer player, int index, double xCoord, double yCoord, double zCoord) {
        switch (index) {
            case 1: {
                SpellHelper.sendParticleToPlayer(player, "mobSpell", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 0.5117, 0.0117, 0.0117);
                break;
            }
            case 2: {
                SpellHelper.sendParticleToPlayer(player, "reddust", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 0.82, 0.941, 0.91);
                break;
            }
            case 3: {
                SpellHelper.sendParticleToPlayer(player, "mobSpell", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 1.0, 0.371, 0.371);
                break;
            }
            case 4: {
                float f = 1.0f;
                float f1 = f * 0.6f + 0.4f;
                float f2 = f * f * 0.7f - 0.5f;
                float f3 = f * f * 0.6f - 0.7f;
                for (int l = 0; l < 8; ++l) {
                    SpellHelper.sendParticleToPlayer(player, "reddust", xCoord + Math.random() - Math.random(), yCoord + Math.random() - Math.random(), zCoord + Math.random() - Math.random(), f1, f2, f3);
                }
                break;
            }
        }
    }

    public static void sendParticleToAllAround(World world, double xPos, double yPos, double zPos, int radius, int dimension, String str, double xCoord, double yCoord, double zCoord, double xVel, double yVel, double zVel) {
        List<EntityPlayer> entities = SpellHelper.getPlayersInRange(world, xPos, yPos, zPos, radius, radius);
        if (entities == null) {
            return;
        }
        for (EntityPlayer player : entities) {
            SpellHelper.sendParticleToPlayer(player, str, xCoord, yCoord, zCoord, xVel, yVel, zVel);
        }
    }

    public static void sendIndexedParticleToAllAround(World world, double xPos, double yPos, double zPos, int radius, int dimension, int index, double xCoord, double yCoord, double zCoord) {
        List<EntityPlayer> entities = SpellHelper.getPlayersInRange(world, xPos, yPos, zPos, radius, radius);
        if (entities == null) {
            return;
        }
        for (EntityPlayer player : entities) {
            SpellHelper.sendIndexedParticleToPlayer(player, index, xCoord, yCoord, zCoord);
        }
    }

    public static void setPlayerSpeedFromServer(EntityPlayer player, double motionX, double motionY, double motionZ) {
        if (player instanceof EntityPlayerMP) {
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getVelSettingPacket(motionX, motionY, motionZ), (EntityPlayerMP)player);
        }
    }

    public static boolean isFakePlayer(World world, EntityPlayer player) {
        return !world.field_72995_K && SpellHelper.isFakePlayer(player);
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer || FAKE_PLAYER_PATTERN.matcher(SpellHelper.getUsername(player)).matches();
    }

    public static void smashBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150348_b) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150347_e);
        } else if (block == Blocks.field_150347_e) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150351_n);
        } else if (block == Blocks.field_150351_n) {
            world.func_147449_b(posX, posY, posZ, (Block)Blocks.field_150354_m);
        }
    }

    public static boolean isBlockFluid(Block block) {
        return block instanceof IFluidBlock || block instanceof BlockLiquid;
    }

    public static void evaporateWaterBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147468_f(posX, posY, posZ);
        }
    }

    public static ItemStack getDustForOre(ItemStack item) {
        String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item));
        if (oreName.contains("ore")) {
            String lowercaseOre = oreName.toLowerCase();
            boolean isAllowed = false;
            for (String str : AlchemicalWizardry.allowedCrushedOresArray) {
                String testStr = str.toLowerCase();
                if (!lowercaseOre.contains(testStr)) continue;
                isAllowed = true;
                break;
            }
            if (!isAllowed) {
                return null;
            }
            String dustName = oreName.replace("ore", "dust");
            ArrayList items = OreDictionary.getOres((String)dustName);
            if (items != null && items.size() >= 1) {
                return ((ItemStack)items.get(0)).func_77946_l();
            }
        }
        return null;
    }

    public static List<ItemStack> getItemsFromBlock(World world, Block block, int x, int y, int z, int meta, boolean silkTouch, int fortune) {
        return APISpellHelper.getItemsFromBlock(world, block, x, y, z, meta, silkTouch, fortune);
    }

    public static void spawnItemListInWorld(List<ItemStack> items, World world, float x, float y, float z) {
        APISpellHelper.spawnItemListInWorld(items, world, x, y, z);
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        return APISpellHelper.raytraceFromEntity(world, player, par3, range);
    }

    public static String getNumeralForInt(int num) {
        switch (num) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return "";
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return false;
        }
        if (stack2 == null) {
            return true;
        }
        if (stack1.func_77984_f() ^ stack2.func_77984_f()) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2, int transferMax) {
        int transferedAmount;
        ItemStack[] returned = new ItemStack[2];
        if (SpellHelper.canCombine(stack1, stack2) && (transferedAmount = Math.min(transferMax, stack2 == null ? stack1.field_77994_a : Math.min(stack2.func_77976_d() - stack2.field_77994_a, stack1.field_77994_a))) > 0) {
            ItemStack copyStack = stack1.func_77979_a(transferedAmount);
            if (stack2 == null) {
                stack2 = copyStack;
            } else {
                stack2.field_77994_a += transferedAmount;
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2) {
        ItemStack[] returned = new ItemStack[2];
        if (SpellHelper.canCombine(stack1, stack2)) {
            int transferedAmount;
            int n = transferedAmount = stack2 == null ? stack1.field_77994_a : Math.min(stack2.func_77976_d() - stack2.field_77994_a, stack1.field_77994_a);
            if (transferedAmount > 0) {
                ItemStack copyStack = stack1.func_77979_a(transferedAmount);
                if (stack2 == null) {
                    stack2 = copyStack;
                } else {
                    stack2.field_77994_a += transferedAmount;
                }
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, ForgeDirection dir) {
        if (stack == null) {
            return null;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_94128_d(dir.ordinal())) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_102007_a(in, stack, dir.ordinal());
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack[] combinedStacks = SpellHelper.combineStacks(stack, inventory.func_70301_a(i));
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if (stack.field_77994_a > 0) continue;
            return stack;
        }
        return stack;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, ForgeDirection dir) {
        return SpellHelper.canInsertStackFullyIntoInventory(stack, inventory, dir, false, 0);
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, ForgeDirection dir, boolean fillToLimit, int limit) {
        if (stack == null) {
            return true;
        }
        int itemsLeft = stack.field_77994_a;
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_94128_d(dir.ordinal())) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_102007_a(in, stack, dir.ordinal());
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack invStack;
                if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)) == null || !SpellHelper.canCombine(stack, invStack)) continue;
                numberMatching += invStack.field_77994_a;
            }
        }
        if (fillToLimit && limit < stack.field_77994_a + numberMatching) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack invStack = inventory.func_70301_a(i);
            boolean canCombine = SpellHelper.canCombine(stack, invStack);
            if (canCombine) {
                itemsLeft = invStack == null ? 0 : (itemsLeft -= invStack.func_77976_d() - invStack.field_77994_a);
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, ForgeDirection dir, int limit) {
        if (stack == null) {
            return null;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_94128_d(dir.ordinal())) {
                canBeInserted[in] = ((ISidedInventory)inventory).func_102007_a(in, stack, dir.ordinal());
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = true;
            }
        }
        int numberMatching = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack;
            if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)) == null || !SpellHelper.canCombine(stack, invStack)) continue;
            numberMatching += invStack.field_77994_a;
        }
        if (numberMatching >= limit) {
            return stack;
        }
        int newLimit = limit - numberMatching;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            int prevStackSize = stack.field_77994_a;
            ItemStack[] combinedStacks = SpellHelper.combineStacks(stack, inventory.func_70301_a(i), newLimit);
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if ((newLimit -= prevStackSize - stack.field_77994_a) > 0 && stack.field_77994_a > 0) continue;
            return stack;
        }
        return stack;
    }

    public static int getNumberOfItemsInInventory(IInventory inventory, ForgeDirection dir) {
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_94128_d(dir.ordinal())) {
                canBeInserted[in] = true;
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = true;
            }
        }
        int amountOfItems = 0;
        for (int i = 0; i < canBeInserted.length; ++i) {
            ItemStack stack;
            if (!canBeInserted[i] || (stack = inventory.func_70301_a(i)) == null) continue;
            amountOfItems += stack.field_77994_a;
        }
        return amountOfItems;
    }

    public static boolean hydrateSoil(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak && world.func_72805_g(x, y, z) == 0) {
            world.func_147465_d(x, y, z, Blocks.field_150458_ak, 15, 2);
            return true;
        }
        return false;
    }

    public static Entity teleportEntitySameDim(double x, double y, double z, Entity entity) {
        if (entity != null && entity.field_71088_bW <= 0) {
            if (entity instanceof EntityPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_70634_a(x, y, z);
                player.field_70170_p.func_72866_a((Entity)player, false);
                player.field_71135_a.func_147359_a((Packet)new S06PacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                player.field_71088_bW = 150;
                player.field_70170_p.func_72908_a(x, y, z, "mob.endermen.portal", 1.0f, 1.0f);
                return player;
            }
            WorldServer world = (WorldServer)entity.field_70170_p;
            if (entity != null) {
                entity.func_70107_b(x, y, z);
                entity.field_71088_bW = 150;
            }
            world.func_82742_i();
            entity.field_70170_p.func_72908_a(x, y, z, "mob.endermen.portal", 1.0f, 1.0f);
            return entity;
        }
        return null;
    }

    public static Entity teleportEntityToDim(World oldWorld, int newWorldID, double d, double e, double f, Entity entity) {
        if (entity != null && entity.field_71088_bW <= 0) {
            WorldServer oldWorldServer = MinecraftServer.func_71276_C().func_71218_a(entity.field_71093_bK);
            WorldServer newWorldServer = MinecraftServer.func_71276_C().func_71218_a(newWorldID);
            if (entity instanceof EntityPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.field_72984_F.func_76320_a("portal");
                    player.field_70170_p.field_72984_F.func_76320_a("changeDimension");
                    ServerConfigurationManager config = player.field_71133_b.func_71203_ab();
                    oldWorld.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
                    player.func_71053_j();
                    player.field_71093_bK = newWorldServer.field_73011_w.field_76574_g;
                    player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, newWorldServer.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                    oldWorldServer.func_72900_e((Entity)player);
                    player.field_70128_L = false;
                    player.func_70012_b(d, e, f, player.field_70177_z, player.field_70125_A);
                    newWorldServer.func_72838_d((Entity)player);
                    player.func_70029_a((World)newWorldServer);
                    config.func_72375_a(player, oldWorldServer);
                    player.field_71135_a.func_147364_a(d, e, f, entity.field_70177_z, entity.field_70125_A);
                    player.field_71134_c.func_73080_a(newWorldServer);
                    config.func_72354_b(player, newWorldServer);
                    config.func_72385_f(player);
                    player.field_70170_p.field_72984_F.func_76319_b();
                    oldWorldServer.func_82742_i();
                    newWorldServer.func_82742_i();
                    player.field_70170_p.field_72984_F.func_76319_b();
                    Iterator potion = player.func_70651_bq().iterator();
                    while (potion.hasNext()) {
                        player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), (PotionEffect)potion.next()));
                    }
                    player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
                    FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldWorldServer.field_73011_w.field_76574_g, player.field_71093_bK);
                    player.field_71088_bW = 150;
                }
                player.field_70170_p.field_72984_F.func_76319_b();
                newWorldServer.func_72908_a(d, e, f, "mob.endermen.portal", 1.0f, 1.0f);
                return player;
            }
            NBTTagCompound tag = new NBTTagCompound();
            entity.func_70039_c(tag);
            entity.func_70106_y();
            oldWorld.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.endermen.portal", 1.0f, 1.0f);
            Entity teleportedEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)newWorldServer);
            if (teleportedEntity != null) {
                teleportedEntity.func_70012_b(d, e, f, entity.field_70177_z, entity.field_70125_A);
                teleportedEntity.field_98038_p = true;
                newWorldServer.func_72838_d(teleportedEntity);
                teleportedEntity.func_70029_a((World)newWorldServer);
                teleportedEntity.field_71088_bW = 150;
            }
            oldWorldServer.func_82742_i();
            newWorldServer.func_82742_i();
            newWorldServer.func_72908_a(d, e, f, "mob.endermen.portal", 1.0f, 1.0f);
            return teleportedEntity;
        }
        return null;
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack compressedStack) {
        return stack.func_77969_a(compressedStack) && (stack.func_77978_p() == null ? compressedStack.func_77978_p() == null : stack.func_77978_p().equals((Object)compressedStack.func_77978_p()));
    }

    public static float applyPotionDamageCalculations(EntityLivingBase entity, DamageSource p_70672_1_, float p_70672_2_) {
        if (entity.func_70644_a(Potion.field_76429_m) && p_70672_1_ != DamageSource.field_76380_i) {
            int i = (entity.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f1 = p_70672_2_ * (float)j;
            p_70672_2_ = f1 / 25.0f;
        }
        if (p_70672_2_ <= 0.0f) {
            return 0.0f;
        }
        return SpellHelper.applySpecialProtection(entity, p_70672_1_, p_70672_2_);
    }

    public static float applySpecialProtection(EntityLivingBase entity, DamageSource source, float damage) {
        ItemStack[] armour = entity.func_70035_c();
        if (armour == null) {
            return damage;
        }
        int total = 0;
        for (int i = 0; i < armour.length; ++i) {
            NBTTagList nbttaglist;
            ItemStack stack = armour[i];
            if (stack == null || (nbttaglist = stack.func_77986_q()) == null) continue;
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                Enchantment ench;
                short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                if (Enchantment.field_77331_b[short1] == null || !((ench = Enchantment.field_77331_b[short1]) instanceof EnchantmentProtection)) continue;
                total += ench.func_77318_a((int)short2, source);
            }
        }
        if (total > 0) {
            if ((total = (total + 1 >> 1) + rand.nextInt(total + 1 >> 1)) <= 20) {
                return damage * (float)(25 - total) / 25.0f;
            }
            float factor = (float)(0.8 + 0.2 * (1.0 - Math.pow(protCoeff, Math.pow(total - 20, scalCoeff))));
            return damage * (1.0f - factor);
        }
        return damage;
    }
}

