/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.client.nei.TooltipStack;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigm;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigmComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEIMeteorRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier()) && ((Object)((Object)this)).getClass() == NEIMeteorRecipeHandler.class) {
            for (MeteorParadigm meteor : this.getSortedMeteors()) {
                this.arecipes.add(new CachedMeteorRecipe(meteor));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MeteorParadigm meteor : this.getSortedMeteors()) {
            if (!meteor.componentList.stream().anyMatch(m -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)m.getValidBlockParadigm()))) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MeteorParadigm meteor : this.getSortedMeteors()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)meteor.focusStack)) continue;
            this.arecipes.add(new CachedMeteorRecipe(meteor));
        }
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/meteor.png").toString();
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.meteor";
    }

    public void drawExtras(int recipe) {
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        int cost = meteorRecipe.getCost();
        int radius = meteorRecipe.getRadius();
        Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nei.recipe.meteor.cost", (Object[])new Object[]{String.format("%,d", cost)}), 2, 96, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(I18n.func_135052_a((String)"nei.recipe.meteor.radius", (Object[])new Object[]{radius}), 2, 107, 0);
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)172, (int)130);
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedMeteorRecipe meteorRecipe = (CachedMeteorRecipe)((Object)this.arecipes.get(recipe));
        for (PositionedStack pStack : meteorRecipe.outputs) {
            if (!gui.isMouseOver(pStack, recipe)) continue;
            if (!(pStack instanceof TooltipStack)) break;
            TooltipStack tStack = (TooltipStack)pStack;
            if (!Arrays.stream(tStack.items).anyMatch(s -> NEIServerUtils.areStacksSameTypeCrafting((ItemStack)s, (ItemStack)stack))) continue;
            currenttip.addAll(tStack.getTooltips());
            break;
        }
        return currenttip;
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"nei.recipe.meteor.category", (Object[])new Object[0]);
    }

    private List<MeteorParadigm> getSortedMeteors() {
        return MeteorRegistry.paradigmList.stream().sorted(Comparator.comparing(m -> m.cost)).collect(Collectors.toList());
    }

    private String getFormattedChance(int chance) {
        boolean isInteger;
        float percentage = (float)chance / 10.0f;
        boolean bl = isInteger = Float.compare(percentage, chance / 10) == 0;
        if (isInteger) {
            return String.format("%,d", (int)percentage);
        }
        return String.format("%,.1f", Float.valueOf(percentage));
    }

    public class CachedMeteorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<MeteorParadigmComponent> components;
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private final int cost;
        private final int radius;

        public CachedMeteorRecipe(MeteorParadigm meteor) {
            super((TemplateRecipeHandler)NEIMeteorRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.components = meteor.componentList;
            this.input.add(new PositionedStack((Object)meteor.focusStack, 74, 4));
            int row = 0;
            int col = 0;
            for (MeteorParadigmComponent component : meteor.componentList) {
                ItemStack stack = component.getValidBlockParadigm();
                ArrayList<String> tooltips = new ArrayList<String>();
                if (stack == null) {
                    stack = new ItemStack((Block)Blocks.field_150480_ab);
                    tooltips.add(String.format("no entries found for oredict \"%s\"", component.getOreDictName()));
                }
                tooltips.add(I18n.func_135052_a((String)"nei.recipe.meteor.chance", (Object[])new Object[]{NEIMeteorRecipeHandler.this.getFormattedChance(component.getChance())}));
                this.outputs.add(new TooltipStack(stack, 3 + 18 * col, 37 + 18 * row, tooltips));
                if (++col <= 8) continue;
                col = 0;
                ++row;
            }
            this.radius = meteor.radius;
            this.cost = meteor.cost;
        }

        public List<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public List<MeteorParadigmComponent> getComponents() {
            return this.components;
        }

        public int getCost() {
            return this.cost;
        }

        public int getRadius() {
            return this.radius;
        }
    }
}

