/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.items.armor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import com.arc.bloodarsenal.common.BloodArsenal;
import com.arc.bloodarsenal.common.items.ModItems;
import com.arc.bloodarsenal.common.items.armor.LifeImbuedArmor;
import com.arc.bloodarsenal.common.items.tool.IFillable;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ElementalLifeImbuedArmor
extends ItemArmor
implements ISpecialArmor,
IFillable {
    private final int maxLP = 100000;
    private String LP_STORED = "LPStored";

    public ElementalLifeImbuedArmor(int armorType) {
        super(BloodArsenal.elementalLifeImbuedArmor, 0, armorType);
    }

    @Override
    public int getMaxLP() {
        return 100000;
    }

    @Override
    public void incrementLPStored(ItemStack itemStack, int incrementAmount) {
        this.setCurrentLPStored(itemStack, this.getLPStored(itemStack) + incrementAmount);
    }

    @Override
    public int getLPStored(ItemStack container) {
        if (container.field_77990_d == null) {
            this.setCurrentLPStored(container, 0);
        }
        return container.field_77990_d.func_74762_e(this.LP_STORED);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.armor.elementalLifeImbuedArmor"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.fillable.currentAmount") + " " + EnumChatFormatting.RED + par1ItemStack.func_77978_p().func_74762_e(this.LP_STORED));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this != ModItems.life_imbued_leggings) {
            return "BloodArsenal:models/armor/life_imbued_layer_1.png";
        }
        return "BloodArsenal:models/armor/life_imbued_layer_2.png";
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public int getMaxDamage(ItemStack stack) {
        return 100000;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            this.setCurrentLPStored(stack, 0);
        }
        return 100000 - stack.field_77990_d.func_74762_e(this.LP_STORED);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.field_77990_d == null || !stack.field_77990_d.func_74767_n("CreativeTab");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(this.setCurrentLPStored(new ItemStack(item, 1, 0), 0));
        list.add(this.setCurrentLPStored(new ItemStack(item, 1, 0), 100000));
    }

    private ItemStack setCurrentLPStored(ItemStack itemStack, int amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a(this.LP_STORED, amount);
        return itemStack;
    }

    protected int getBaseAbsorption() {
        return 18;
    }

    protected int getAbsorptionRatio() {
        switch (this.field_77881_a) {
            case 0: {
                return 15;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 15;
            }
        }
        return 0;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (this.getLPStored(armor) >= this.getLPPerDamage(armor)) {
            return Math.min(this.getBaseAbsorption(), 20) * this.getAbsorptionRatio() / 100;
        }
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorbRatio = 0.5;
        if (source.func_76363_c()) {
            int absorbMax = this.getLPPerDamage(armor) > 0 ? 25 * this.getLPStored(armor) / this.getLPPerDamage(armor) : 0;
            return new ISpecialArmor.ArmorProperties(0, 0.5 * (double)this.func_82812_d().func_78044_b(this.field_77881_a) * 0.025, absorbMax);
        }
        int absorbMax = this.getLPPerDamage(armor) > 0 ? 25 * this.getLPStored(armor) / this.getLPPerDamage(armor) : 0;
        return new ISpecialArmor.ArmorProperties(0, 0.5 * (double)this.func_82812_d().func_78044_b(this.field_77881_a) * 0.05, absorbMax);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        this.subtractLP(armor, damage * this.getLPPerDamage(armor), false);
    }

    protected int getLPPerDamage(ItemStack stack) {
        int unbreakingLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return 100 * (5 - unbreakingLevel) / 5;
    }

    public int subtractLP(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            this.setCurrentLPStored(container, 0);
        }
        int stored = container.field_77990_d.func_74762_e(this.LP_STORED);
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a(this.LP_STORED, stored -= extract);
        }
        return extract;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        LifeImbuedArmor thisArmor;
        Random random;
        if (this.hasArmorSetItem(player, 0) && this.hasArmorSetItem(player, 1) && this.hasArmorSetItem(player, 2) && this.hasArmorSetItem(player, 3) && player.func_110143_aJ() < player.func_110138_aP() && !player.func_70644_a(AlchemicalWizardry.customPotionInhibit) && world.func_72820_D() % 50L == 0L && (random = new Random()).nextInt(9) > 7 && (thisArmor = (LifeImbuedArmor)armor.func_77973_b()).getLPStored(armor) >= 2000) {
            float healHealth = player.func_110138_aP() - player.func_110143_aJ();
            player.func_70691_i(healHealth);
            thisArmor.subtractLP(armor, (int)healHealth * 500, false);
        }
    }

    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        ItemStack stack = player.field_71071_by.field_70460_b[3 - i];
        if (stack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.life_imbued_helmet_water;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.life_imbued_chestplate_fire;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.life_imbued_leggings_earth;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.life_imbued_boots_air;
            }
        }
        return false;
    }
}

