/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.auxiliary;

import com.github.namikon.blocklimiter.BlockLimiter;
import eu.usrv.yamcore.auxiliary.IntHelper;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.enums.ItemEqualsCompareMethodEnum;
import java.util.ArrayList;
import java.util.List;

public class ItemInfo {
    private ItemDescriptor _mItemDescriptor;
    private List<Integer> _mBannedDimensions = new ArrayList<Integer>();
    private boolean _mGlobalDenied = false;

    public ItemInfo(String pItemConfig) {
        this.InitBlockInfoInstance(pItemConfig);
    }

    public boolean isDenied(ItemDescriptor pID, int pDimensionID) {
        boolean tResult = false;
        BlockLimiter.Logger.debug((Object)String.format("Checking against item %s", this._mItemDescriptor.toString()));
        if (this._mItemDescriptor.isEqualTo(pID, ItemEqualsCompareMethodEnum.Exact)) {
            BlockLimiter.Logger.debug((Object)"Target Item found");
            if (this._mBannedDimensions.contains(pDimensionID) || this._mGlobalDenied) {
                tResult = true;
            }
        }
        BlockLimiter.Logger.debug((Object)("Result is " + tResult));
        return tResult;
    }

    public String getInfoString() {
        String tInfo = String.format("Item %s ", this._mItemDescriptor.toString());
        if (this._mGlobalDenied) {
            tInfo = tInfo + "[ALL]";
        } else {
            tInfo = tInfo + "[In DIM: ";
            boolean tFirst = true;
            for (Integer i : this._mBannedDimensions) {
                if (tFirst) {
                    tFirst = false;
                } else {
                    tInfo = tInfo + ", ";
                }
                tInfo = tInfo + String.format("%d", i);
            }
            tInfo = tInfo + "]";
        }
        return tInfo;
    }

    private void InitBlockInfoInstance(String pItemConfig) {
        BlockLimiter.Logger.debug((Object)("pItemConfig: " + pItemConfig));
        String[] tBlockInfoArray1 = pItemConfig.split(";");
        this._mItemDescriptor = ItemDescriptor.fromString((String)tBlockInfoArray1[0], (boolean)true);
        if (this._mItemDescriptor == null) {
            BlockLimiter.Logger.warn((Object)("ItemDefinition " + pItemConfig + " is invalid and will be ignored"));
            throw new IllegalArgumentException(pItemConfig);
        }
        if (tBlockInfoArray1.length == 1) {
            BlockLimiter.Logger.info((Object)("New restrictive Item added: " + this._mItemDescriptor.toString() + " Item is denied in ALL dimensions"));
            this._mGlobalDenied = true;
        } else {
            for (int i = 1; i < tBlockInfoArray1.length; ++i) {
                if (!IntHelper.tryParse((String)tBlockInfoArray1[i])) continue;
                this.AddBlacklistedDim(Integer.parseInt(tBlockInfoArray1[i]));
            }
            BlockLimiter.Logger.info((Object)("New restrictive Item added: " + this._mItemDescriptor.toString() + " Item is denied in " + this._mBannedDimensions.size() + " dimension(s)"));
        }
    }

    private void AddBlacklistedDim(int pDimID) {
        for (Integer i : this._mBannedDimensions) {
            if (i != pDimID) continue;
            return;
        }
        this._mBannedDimensions.add(pDimID);
    }
}

