/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.utils.PerlinNoise;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderBOPEnd
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private PerlinNoise perlin;
    private BiomeGenBase[] biomesForGeneration;

    public ChunkProviderBOPEnd(World world, long l) {
        this.worldObj = world;
        this.rand = new Random(l);
        this.perlin = new PerlinNoise(l);
    }

    public Chunk func_73154_d(int cx, int cy) {
        BiomeGenBase biome = BiomeGenBase.field_76779_k;
        this.rand.setSeed((long)cx * 341873128712L + (long)cy * 132897987541L);
        Block[] blocks = new Block[65536];
        byte[] metadata = new byte[65536];
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cy * 16, 16, 16);
        this.generateTerrain(cx, cy, blocks, metadata, this.biomesForGeneration);
        this.replaceBlocksForBiome(cx, cy, blocks, metadata, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.worldObj, blocks, metadata, cx, cy);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int cx, int cy, Block[] blocks, byte[] metadata, BiomeGenBase[] biome) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                float spawnDis = (float)(20000 - ((cx * 16 + j) * (cx * 16 + j) + (cy * 16 + i) * (cy * 16 + i))) / 13000.0f;
                float noiseC = this.perlin.noise2((float)(cx * 16 + j) / 80.0f, (float)(cy * 16 + i) / 80.0f) * 6.0f - 1.2f;
                noiseC = spawnDis > noiseC ? spawnDis : noiseC;
                float noiseA = 64.0f + this.perlin.noise2((float)(cx * 16 + j) / 40.0f, (float)(cy * 16 + i) / 40.0f) * 6.0f + this.perlin.noise2((float)(cx * 16 + j) / 12.0f, (float)(cy * 16 + i) / 12.0f) * 3.0f + noiseC * 3.0f;
                float noiseB = 12.0f + this.perlin.noise2((1000.0f + (float)(cx * 16) + (float)j) / 40.0f, (float)(cy * 16 + i) / 40.0f) * 6.0f + this.perlin.noise2((float)(cx * 16 + j) / 12.0f, (float)(cy * 16 + i) / 12.0f) * 3.0f - noiseC * 3.0f;
                for (int k = 0; k < 256; ++k) {
                    int p = (j * 16 + i) * 256 + k;
                    if (k > 72) {
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    if ((float)k < noiseA && (float)k > noiseB) {
                        float noise3 = this.perlin.noise3((float)(cx * 16 + j) / 30.0f, (float)(cy * 16 + i) / 30.0f, (float)k / 20.0f) + noiseC;
                        if (noise3 > 0.2f) {
                            blocks[p] = Blocks.field_150377_bs;
                            continue;
                        }
                        blocks[p] = Blocks.field_150350_a;
                        continue;
                    }
                    blocks[p] = Blocks.field_150350_a;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int cx, int cy, Block[] blocks, byte[] metadata, BiomeGenBase[] biomes) {
        int depth = -1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BiomeGenBase biome = biomes[i * 16 + j];
                for (int k = 255; k > -1; --k) {
                    Block b = blocks[(j * 16 + i) * 256 + k];
                    if (b == Blocks.field_150350_a) {
                        depth = -1;
                        continue;
                    }
                    if (b != Blocks.field_150377_bs) continue;
                    if (++depth == 0) {
                        blocks[(j * 16 + i) * 256 + k] = biome.field_76752_A;
                        continue;
                    }
                    if (depth >= 4) continue;
                    blocks[(j * 16 + i) * 256 + k] = biome.field_76753_B;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return null;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int i, int j) {
        BlockFalling.field_149832_M = true;
        int x = i * 16;
        int y = j * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(x + 16, y + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * i1 + (long)j * j1 ^ this.worldObj.func_72905_C());
        biomegenbase.func_76728_a(this.worldObj, this.rand, x, y);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(x + 8), (int)(y + 8), (int)16, (int)16, (Random)this.rand);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : var5.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }

    public void func_82695_e(int par1, int par2) {
    }
}

