/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.blocks.ContainerFancyWorkbench;
import jds.bibliocraft.items.ItemLoader;
import jds.bibliocraft.items.ItemRecipeBook;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class TileEntityFancyWorkbench
extends TileEntity
implements IInventory {
    private ItemStack[] inventory;
    private ItemStack[] playerGrid;
    private ItemStack[] bookGrid;
    private ContainerFancyWorkbench[] container = new ContainerFancyWorkbench[8];
    private int[] playerIDs = new int[8];
    public int[] bookCheck = new int[8];
    public int angle;
    public int showText = -1;
    public boolean islocked = false;
    public String lockee = "";
    public String customTex = "none";
    public ResourceLocation customTexture = null;

    public TileEntityFancyWorkbench() {
        this.inventory = new ItemStack[9];
        this.playerGrid = new ItemStack[9];
        this.bookGrid = new ItemStack[9];
    }

    public void setCustomTex(String tex) {
        this.customTex = tex;
        this.customTexture = tex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ResourceLocation getCustomTex() {
        if (this.customTexture != null) {
            return this.customTexture;
        }
        return CommonProxy.PLANKSOAK;
    }

    public String getCustomTexString() {
        return this.customTex;
    }

    public void setShowText(int textnum) {
        this.showText = textnum;
    }

    public int getShowText() {
        return this.showText;
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int ang) {
        this.angle = ang;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int[] getBookArray() {
        return this.bookCheck;
    }

    public void setPlayerGrid(ItemStack[] grid) {
        this.playerGrid = grid;
    }

    public boolean isTooManyPlayers() {
        return this.playerIDs[7] != 0 & this.container[7] != null;
    }

    public boolean isLocked() {
        return this.islocked;
    }

    public void setLocked(boolean locked) {
        this.islocked = locked;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String getLockee() {
        return this.lockee;
    }

    public void setLockee(String lockeeperson) {
        this.lockee = lockeeperson;
    }

    public void setBookGrid(int id) {
        int arrayid = -1;
        for (int n = 0; n < 8; ++n) {
            if (this.playerIDs[n] != id) continue;
            arrayid = n;
            break;
        }
        if (arrayid == -1 || this.container[arrayid] == null) {
            return;
        }
        if (this.func_70301_a(0) != null && (this.func_70301_a(0).func_77973_b() == Items.field_151122_aG || this.func_70301_a(0).func_77973_b() instanceof ItemRecipeBook)) {
            this.func_70299_a(0, null);
            ItemStack recipeBook = new ItemStack(ItemLoader.bookRecipe, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.playerGrid[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("grid", (NBTBase)itemList);
            ItemStack result = this.container[arrayid].craftResult.func_70301_a(0);
            if (result != null) {
                NBTTagCompound display = new NBTTagCompound();
                display.func_74778_a("Name", EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"book.setrecipename") + " " + result.func_82833_r());
                nbt.func_74782_a("display", (NBTBase)display);
                NBTTagCompound resultTag = new NBTTagCompound();
                result.func_77955_b(resultTag);
                nbt.func_74782_a("result", (NBTBase)resultTag);
            }
            recipeBook.func_77982_d(nbt);
            this.func_70299_a(0, recipeBook);
            this.bookGrid = (ItemStack[])this.playerGrid.clone();
        }
    }

    public ItemStack[] getPlayerGrid() {
        return this.playerGrid;
    }

    public ItemStack[] getBookGrid() {
        return this.bookGrid;
    }

    public void setContainer(ContainerFancyWorkbench bench, int id) {
        for (int n = 0; n < 8; ++n) {
            if (this.container[n] != null) continue;
            this.container[n] = bench;
            this.playerIDs[n] = id;
            break;
        }
    }

    public void clearContainer(int id) {
        for (int n = 0; n < 8; ++n) {
            if (this.playerIDs[n] != id) continue;
            this.playerIDs[n] = 0;
            this.container[n] = null;
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public void loadInvToGridForRecipe(int playerid) {
        if (this.container != null && this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemRecipeBook) {
            for (int n = 0; n < 8; ++n) {
                if (this.playerIDs[n] != playerid || this.container[n] == null) continue;
                this.readBookMatrix(this.func_70301_a(0));
                this.container[n].loadPlayerInventorytoRecipeBookGrid(this.bookGrid, playerid);
            }
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (slot > 0 && slot < 10) {
            this.bookCheck[slot - 1] = this.inventory[slot] != null ? 1 : 0;
        }
        if (this.container != null && slot == 0) {
            if (stack != null && stack.func_77973_b() instanceof ItemRecipeBook) {
                this.readBookMatrix(stack);
            } else {
                for (int n = 0; n < 9; ++n) {
                    this.bookGrid[n] = null;
                }
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void readBookMatrix(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77973_b() instanceof ItemRecipeBook && (nbt = stack.func_77978_p()) != null) {
            NBTTagList tagList = nbt.func_150295_c("grid", 10);
            this.bookGrid = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack nbtStack;
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || (nbtStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                this.bookGrid[slot] = nbtStack;
            }
        }
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        Item stackSizeTest = stack.func_77973_b();
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tagList = nbt.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.angle = nbt.func_74762_e("angle");
        this.bookCheck = nbt.func_74759_k("books");
        this.islocked = nbt.func_74767_n("locked");
        this.lockee = nbt.func_74779_i("lockee");
        this.customTex = nbt.func_74779_i("customTexture");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)itemList);
        nbt.func_74768_a("angle", this.angle);
        nbt.func_74783_a("books", this.bookCheck);
        nbt.func_74757_a("locked", this.islocked);
        nbt.func_74778_a("lockee", this.lockee);
        nbt.func_74778_a("customTexture", this.customTex);
    }

    public Packet func_145844_m() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74768_a("angle", this.angle);
        dataTag.func_74783_a("books", this.bookCheck);
        dataTag.func_74757_a("locked", this.islocked);
        dataTag.func_74778_a("lockee", this.lockee);
        dataTag.func_74778_a("customTexture", this.customTex);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        dataTag.func_74782_a("BookcaseInv", (NBTBase)itemList);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, dataTag);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.angle = nbtData.func_74762_e("angle");
        this.bookCheck = nbtData.func_74759_k("books");
        this.islocked = nbtData.func_74767_n("locked");
        this.lockee = nbtData.func_74779_i("lockee");
        this.customTex = nbtData.func_74779_i("customTexture");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        NBTTagList tagList = nbtData.func_150295_c("BookcaseInv", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public String func_145825_b() {
        return "jds.tileentityfancyworkbench";
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        return bb;
    }
}

