/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client;

import betterquesting.core.BetterQuesting;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class BookmarkHandler {
    private static final List<String> BOOKMARKS = new ArrayList<String>();
    private static final String BOOKMARK_DIR = "betterquesting/bookmarks/";
    private static File bookmarkFile;
    private static boolean hasChanged;

    public static boolean bookmarkQuest(UUID questId) {
        String uuid = questId.toString();
        boolean added = false;
        if (BOOKMARKS.contains(uuid)) {
            BOOKMARKS.remove(uuid);
        } else {
            BOOKMARKS.add(uuid);
            added = true;
        }
        hasChanged = true;
        BookmarkHandler.saveBookmarks();
        return added;
    }

    public static int getIndexOf(UUID questId) {
        return BOOKMARKS.indexOf(questId.toString());
    }

    public static boolean isBookmarked(UUID questId) {
        return BOOKMARKS.contains(questId.toString());
    }

    public static boolean hasChanged() {
        if (hasChanged) {
            hasChanged = false;
            return true;
        }
        return false;
    }

    private static void saveBookmarks() {
        try {
            FileUtils.writeLines((File)bookmarkFile, BOOKMARKS);
        }
        catch (IOException ignored) {
            BetterQuesting.logger.warn("Failed to save bookmarks.");
        }
    }

    public static void loadBookmarks(String address) {
        String identifier = BookmarkHandler.getIdentifier(address);
        bookmarkFile = new File(BOOKMARK_DIR, String.format("%s.txt", identifier));
        BOOKMARKS.clear();
        hasChanged = true;
        if (!bookmarkFile.exists()) {
            return;
        }
        try {
            List bookmarks = FileUtils.readLines((File)bookmarkFile, (Charset)StandardCharsets.UTF_8);
            BOOKMARKS.addAll(bookmarks);
        }
        catch (IOException ignored) {
            BetterQuesting.logger.warn("Failed to load bookmarks for {}", new Object[]{identifier});
        }
    }

    private static String getIdentifier(String address) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
        }
        int index = address.indexOf("/") + 1;
        return address.substring(index).replace(":", ".");
    }

    static {
        hasChanged = true;
    }
}

