/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.storage.IUuidDatabase;
import betterquesting.api2.storage.UuidDatabase;
import betterquesting.api2.utils.QuestLineSorter;
import betterquesting.questing.QuestLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class QuestLineDatabase
extends UuidDatabase<IQuestLine>
implements IQuestLineDatabase {
    public static final QuestLineDatabase INSTANCE = new QuestLineDatabase();
    protected final List<UUID> lineOrder = new ArrayList<UUID>();
    protected final QuestLineSorter SORTER = new QuestLineSorter(this);

    @Override
    public synchronized int getOrderIndex(UUID lineID) {
        if (!this.containsKey(lineID)) {
            return -1;
        }
        int order = this.lineOrder.indexOf(lineID);
        if (order >= 0) {
            return order;
        }
        this.lineOrder.add(lineID);
        return this.lineOrder.size() - 1;
    }

    @Override
    public void setOrderIndex(UUID lineID, int index) {
        this.lineOrder.remove(lineID);
        this.lineOrder.add(MathHelper.func_76125_a((int)index, (int)0, (int)this.lineOrder.size()), lineID);
    }

    @Override
    public synchronized List<Map.Entry<UUID, IQuestLine>> getOrderedEntries() {
        return this.entrySet().stream().sorted(this.SORTER).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public IQuestLine createNew(UUID lineID) {
        QuestLine ql = new QuestLine();
        this.put(lineID, ql);
        return ql;
    }

    @Override
    public void removeQuest(UUID questID) {
        this.values().forEach(ql -> {
            IQuestLineEntry cfr_ignored_0 = (IQuestLineEntry)ql.remove(questID);
        });
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, @Nullable List<UUID> subset) {
        for (Map.Entry entry : this.entrySet()) {
            if (subset != null && !subset.contains(entry.getKey())) continue;
            NBTTagCompound jObj = (NBTTagCompound)((IQuestLine)entry.getValue()).writeToNBT((NBTBase)new NBTTagCompound(), null);
            NBTConverter.UuidValueType.QUEST_LINE.writeId(entry.getKey(), jObj);
            jObj.func_74768_a("order", this.getOrderIndex(entry.getKey()));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList json, boolean merge) {
        if (!merge) {
            this.clear();
        }
        ArrayList<IQuestLine> unassigned = new ArrayList<IQuestLine>();
        TreeMap<Integer, UUID> orderMap = new TreeMap<Integer, UUID>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jql = json.func_150305_b(i);
            Optional<UUID> lineIDOptional = NBTConverter.UuidValueType.QUEST_LINE.tryReadId(jql);
            UUID lineID = null;
            if (lineIDOptional.isPresent()) {
                lineID = lineIDOptional.get();
            } else if (jql.func_150297_b("lineID", 99)) {
                lineID = IUuidDatabase.convertLegacyId(jql.func_74762_e("lineID"));
            }
            int order = jql.func_150297_b("order", 99) ? jql.func_74762_e("order") : -1;
            IQuestLine line = (IQuestLine)this.getOrDefault(lineID, new QuestLine());
            line.readFromNBT((NBTBase)jql, merge);
            if (lineID != null) {
                this.put(lineID, line);
            } else {
                unassigned.add(line);
            }
            if (order < 0) continue;
            orderMap.put(order, lineID);
        }
        for (IQuestLine q : unassigned) {
            this.put(this.generateKey(), q);
        }
        this.lineOrder.clear();
        this.lineOrder.addAll(orderMap.values());
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.lineOrder.clear();
    }
}

