/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.Tuple2;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestDatabase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class NetStationEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:station_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetStationEdit::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupStation(int posX, int posY, int posZ, UUID questID, int taskID) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 1);
        NBTConverter.UuidValueType.QUEST.writeId(questID, payload);
        payload.func_74768_a("taskID", taskID);
        payload.func_74768_a("tilePosX", posX);
        payload.func_74768_a("tilePosY", posY);
        payload.func_74768_a("tilePosZ", posZ);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetStation(int posX, int posY, int posZ) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 0);
        payload.func_74768_a("tilePosX", posX);
        payload.func_74768_a("tilePosY", posY);
        payload.func_74768_a("tilePosZ", posZ);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        TileSubmitStation oss;
        int pz;
        int py;
        NBTTagCompound data = message.func_76341_a();
        int px = data.func_74762_e("tilePosX");
        TileEntity tile = message.func_76340_b().field_70170_p.func_147438_o(px, py = data.func_74762_e("tilePosY"), pz = data.func_74762_e("tilePosZ"));
        if (tile instanceof TileSubmitStation && (oss = (TileSubmitStation)tile).func_70300_a((EntityPlayer)message.func_76340_b())) {
            int action = data.func_74762_e("action");
            if (action == 0) {
                oss.reset();
            } else if (action == 1) {
                ITask task;
                UUID QID = QuestingAPI.getQuestingUUID((EntityPlayer)message.func_76340_b());
                IQuest quest = (IQuest)QuestDatabase.INSTANCE.get(NBTConverter.UuidValueType.QUEST.readId(data));
                ITask iTask = task = quest == null ? null : (ITask)quest.getTasks().getValue(data.func_74762_e("taskID"));
                if (quest != null && task != null) {
                    oss.setupTask(QID, quest, task);
                }
            }
        }
    }
}

