/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasHoverTray;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopChoice;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.api2.utils.Tuple2;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.GuiQuestSearch;
import betterquesting.client.gui2.editors.GuiQuestLinesEditor;
import betterquesting.client.gui2.editors.designer.GuiDesigner;
import betterquesting.handlers.ConfigHandler;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuestLines
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private ScrollPosition scrollPosition;
    private IQuestLine selectedLine = null;
    private static UUID selectedLineId = null;
    private final List<Tuple2<Map.Entry<UUID, IQuestLine>, Integer>> visChapters = new ArrayList<Tuple2<Map.Entry<UUID, IQuestLine>, Integer>>();
    private CanvasQuestLine cvQuest;
    private static CanvasHoverTray cvChapterTray;
    private static CanvasHoverTray cvDescTray;
    private static CanvasHoverTray cvFrame;
    private CanvasScrolling cvDesc;
    private PanelVScrollBar scDesc;
    private CanvasScrolling cvLines;
    private PanelVScrollBar scLines;
    private PanelGeneric icoChapter;
    private PanelTextBox txTitle;
    private PanelTextBox txDesc;
    private PanelTextBox completionText;
    private PanelButton claimAll;
    private static boolean trayLock;
    private static boolean viewMode;
    private int questsCompleted = 0;
    private int totalQuests = 0;
    private final List<PanelButtonStorage<Map.Entry<UUID, IQuestLine>>> btnListRef = new ArrayList<PanelButtonStorage<Map.Entry<UUID, IQuestLine>>>();

    public GuiQuestLines(GuiScreen parent) {
        super(parent);
        trayLock = BQ_Settings.lockTray;
        viewMode = BQ_Settings.viewMode;
        if (this.scrollPosition == null) {
            this.scrollPosition = new ScrollPosition(0);
        }
    }

    @Override
    public void refreshGui() {
        this.refreshChapterVisibility();
        this.refreshContent();
    }

    @Override
    public void initPanel() {
        PanelButton btnViewMode;
        boolean descTrayOpened;
        super.initPanel();
        GuiHome.bookmark = this;
        if (!BQ_Settings.skipHome) {
            ConfigHandler.config.get("general", "Skip home", false).set(true);
            ConfigHandler.config.save();
            BQ_Settings.skipHome = true;
        }
        if (selectedLineId != null) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.get(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = null;
            }
        } else {
            this.selectedLine = null;
        }
        boolean canEdit = QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        boolean preOpen = false;
        if (trayLock && cvChapterTray == null && cvDescTray == null) {
            preOpen = true;
        }
        if (trayLock && cvChapterTray != null && cvChapterTray.isTrayOpen()) {
            preOpen = true;
        }
        if (trayLock && cvDescTray != null && cvDescTray.isTrayOpen()) {
            preOpen = true;
        }
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelButton btnExit = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -24, 32, 16, 0), -1, "").setIcon(PresetIcon.ICON_PG_PREV.getTexture());
        btnExit.setClickAction(b -> this.field_146297_k.func_147108_a(this.parent));
        btnExit.setTooltip(Collections.singletonList(QuestTranslation.translate("gui.back", new Object[0])));
        cvBackground.addPanel(btnExit);
        PanelButton btnSearch = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -40, 32, 16, 0), -1, "").setIcon(PresetIcon.ICON_ZOOM.getTexture());
        btnSearch.setClickAction(this::openSearch);
        btnSearch.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.gui.search", new Object[0])));
        cvBackground.addPanel(btnSearch);
        if (canEdit) {
            PanelButton btnEdit = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -56, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_GEAR.getTexture());
            btnEdit.setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLinesEditor(this)));
            btnEdit.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.edit", new Object[0])));
            cvBackground.addPanel(btnEdit);
            PanelButton btnDesign = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, 24, -56, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_SORT.getTexture());
            btnDesign.setClickAction(b -> {
                if (this.selectedLine != null) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiDesigner(this, this.selectedLine));
                }
            });
            btnDesign.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.designer", new Object[0])));
            cvBackground.addPanel(btnDesign);
        }
        this.txTitle = new PanelTextBox(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.0f), new GuiPadding(60, 12, 0, -24), 0), "");
        this.txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(this.txTitle);
        this.completionText = new PanelTextBox(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.0f), new GuiPadding(214, 12, -154, -24), 0), "");
        this.completionText.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(this.completionText);
        this.icoChapter = new PanelGeneric(new GuiTransform(GuiAlign.TOP_LEFT, 40, 8, 16, 16, 0), null);
        cvBackground.addPanel(this.icoChapter);
        cvFrame = new CanvasHoverTray((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(214, 24, 8, 8), 0), new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(40, 24, 8, 8), 0), PresetTexture.AUX_FRAME_0.getTexture());
        cvFrame.setManualOpen(true);
        cvBackground.addPanel(cvFrame);
        cvFrame.setTrayState(!preOpen, 1L);
        boolean chapterTrayOpened = trayLock && cvChapterTray != null && cvChapterTray.isTrayOpen();
        boolean bl = descTrayOpened = trayLock && cvDescTray != null && cvDescTray.isTrayOpen();
        if (preOpen && !chapterTrayOpened && !descTrayOpened) {
            chapterTrayOpened = true;
        }
        cvChapterTray = new CanvasHoverTray((IGuiRect)new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(40, 24, -24, 8), -1), new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(40, 24, -214, 8), -1), PresetTexture.PANEL_INNER.getTexture());
        cvChapterTray.setManualOpen(true);
        cvChapterTray.setOpenAction(() -> {
            cvDescTray.setTrayState(false, 200L);
            cvFrame.setTrayState(false, 200L);
            this.buildChapterList();
        });
        cvBackground.addPanel(cvChapterTray);
        this.cvLines = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 16, 8), 0));
        cvChapterTray.getCanvasOpen().addPanel(this.cvLines);
        this.scLines = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-16, 8, 8, 8), 0));
        this.cvLines.setScrollDriverY(this.scLines);
        cvChapterTray.getCanvasOpen().addPanel(this.scLines);
        cvDescTray = new CanvasHoverTray((IGuiRect)new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(40, 24, -24, 8), -1), new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(40, 24, -214, 8), -1), PresetTexture.PANEL_INNER.getTexture());
        cvDescTray.setManualOpen(true);
        cvDescTray.setOpenAction(() -> {
            cvChapterTray.setTrayState(false, 200L);
            cvFrame.setTrayState(false, 200L);
            this.cvDesc.resetCanvas();
            if (this.selectedLine != null) {
                this.txDesc = new PanelTextBox(new GuiRectangle(0, 0, this.cvDesc.getTransform().getWidth(), 0, 0), QuestTranslation.translateQuestLineDescription(selectedLineId, this.selectedLine), true);
                this.txDesc.setColor(PresetColor.TEXT_AUX_0.getColor());
                this.cvDesc.addCulledPanel(this.txDesc, false);
                this.cvDesc.refreshScrollBounds();
                this.scDesc.setEnabled(this.cvDesc.getScrollBounds().getHeight() > 0);
            } else {
                this.scDesc.setEnabled(false);
            }
        });
        cvBackground.addPanel(cvDescTray);
        this.cvDesc = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 20, 8), 0));
        cvDescTray.getCanvasOpen().addPanel(this.cvDesc);
        this.scDesc = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-16, 8, 8, 8), 0));
        this.cvDesc.setScrollDriverY(this.scDesc);
        cvDescTray.getCanvasOpen().addPanel(this.scDesc);
        int yOff = 24;
        PanelButton btnTrayToggle = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff, 32, 16, 0), -1, "");
        btnTrayToggle.setIcon(PresetIcon.ICON_BOOKMARK.getTexture(), selectedLineId == null && !chapterTrayOpened ? new GuiColorPulse(-1, -12303292, 2.0, 0.0f) : new GuiColorStatic(-1), 0);
        btnTrayToggle.setClickAction(b -> {
            cvFrame.setTrayState(cvChapterTray.isTrayOpen(), 200L);
            cvChapterTray.setTrayState(!cvChapterTray.isTrayOpen(), 200L);
            btnTrayToggle.setIcon(PresetIcon.ICON_BOOKMARK.getTexture());
        });
        btnTrayToggle.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.title.quest_lines", new Object[0])));
        cvBackground.addPanel(btnTrayToggle);
        PanelButton btnDescToggle = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff += 16, 32, 16, 0), -1, "").setIcon(PresetIcon.ICON_DESC.getTexture());
        btnDescToggle.setClickAction(b -> {
            cvFrame.setTrayState(cvDescTray.isTrayOpen(), 200L);
            cvDescTray.setTrayState(!cvDescTray.isTrayOpen(), 200L);
        });
        btnDescToggle.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.gui.description", new Object[0])));
        cvBackground.addPanel(btnDescToggle);
        this.claimAll = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff += 16, 32, 16, -2), -1, "");
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture());
        this.claimAll.setClickAction(b -> {
            if (BQ_Settings.claimAllConfirmation) {
                this.openPopup(new PopChoice(QuestTranslation.translate("betterquesting.gui.claim_all_warning", new Object[0]) + "\n\n" + QuestTranslation.translate("betterquesting.gui.claim_all_confirm", new Object[0]), PresetIcon.ICON_CHEST_ALL.getTexture(), integer -> {
                    if (integer == 1) {
                        ConfigHandler.config.get("general", "Claim all requires confirmation", true).set(false);
                        ConfigHandler.config.save();
                        ConfigHandler.initConfigs();
                    }
                    if (integer <= 1) {
                        this.claimAll();
                    }
                }, QuestTranslation.translate("gui.yes", new Object[0]), QuestTranslation.translate("betterquesting.gui.yes_always", new Object[0]), QuestTranslation.translate("gui.no", new Object[0])));
            } else {
                this.claimAll();
            }
        });
        this.claimAll.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.claim_all", new Object[0])));
        cvBackground.addPanel(this.claimAll);
        PanelButton fitView = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff += 16, 32, 16, -2), 5, "");
        fitView.setIcon(PresetIcon.ICON_BOX_FIT.getTexture());
        fitView.setClickAction(b -> {
            if (this.cvQuest.getQuestLine() != null) {
                this.cvQuest.fitToWindow();
            }
        });
        fitView.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.zoom_fit", new Object[0])));
        cvBackground.addPanel(fitView);
        PanelButton btnTrayLock = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff += 16, 32, 16, -2), -1, "").setIcon(trayLock ? PresetIcon.ICON_LOCKED.getTexture() : PresetIcon.ICON_UNLOCKED.getTexture());
        btnTrayLock.setClickAction(b -> {
            trayLock = !trayLock;
            b.setIcon(trayLock ? PresetIcon.ICON_LOCKED.getTexture() : PresetIcon.ICON_UNLOCKED.getTexture());
            ConfigHandler.config.get("general", "Lock tray", false).set(trayLock);
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        });
        btnTrayLock.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.lock_tray", new Object[0])));
        cvBackground.addPanel(btnTrayLock);
        yOff += 16;
        if (BQ_Settings.viewModeBtn) {
            btnViewMode = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff, 32, 16, -2), -1, "").setIcon(viewMode ? PresetIcon.ICON_VIEW_MODE_ON.getTexture() : PresetIcon.ICON_VIEW_MODE_OFF.getTexture());
            btnViewMode.setClickAction(b -> {
                viewMode = !viewMode;
                b.setIcon(viewMode ? PresetIcon.ICON_VIEW_MODE_ON.getTexture() : PresetIcon.ICON_VIEW_MODE_OFF.getTexture());
                ConfigHandler.config.get("general", "View mode", false).set(viewMode);
                ConfigHandler.config.save();
                ConfigHandler.initConfigs();
                this.refreshGui();
            });
            btnViewMode.setTooltip(Collections.singletonList(QuestTranslation.translate("betterquesting.btn.view_mode", new Object[0])));
            cvBackground.addPanel(btnViewMode);
            yOff += 16;
        }
        btnViewMode = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, 8, yOff, 32, 16, -2), -1, "").setIcon(BQ_Settings.alwaysDrawImplicit ? PresetIcon.ICON_VISIBILITY_IMPLICIT.getTexture() : PresetIcon.ICON_VISIBILITY_NORMAL.getTexture());
        btnViewMode.setClickAction(b -> {
            BQ_Settings.alwaysDrawImplicit = !BQ_Settings.alwaysDrawImplicit;
            b.setIcon(BQ_Settings.alwaysDrawImplicit ? PresetIcon.ICON_VISIBILITY_IMPLICIT.getTexture() : PresetIcon.ICON_VISIBILITY_NORMAL.getTexture());
            ConfigHandler.config.get("general", "Always draw implicit dependency", false, "If true, always draw implicit dependency. This property can be changed by the GUI").set(BQ_Settings.alwaysDrawImplicit);
            ConfigHandler.config.save();
            btnViewMode.setTooltip(Arrays.asList(QuestTranslation.translate("betterquesting.btn.always_draw_implicit", new Object[0]), QuestTranslation.translate("betterquesting.tooltip.cycle." + BQ_Settings.alwaysDrawImplicit, new Object[0])));
            ConfigHandler.initConfigs();
            this.refreshGui();
        });
        btnViewMode.setTooltip(Arrays.asList(QuestTranslation.translate("betterquesting.btn.always_draw_implicit", new Object[0]), QuestTranslation.translate("betterquesting.tooltip.cycle." + BQ_Settings.alwaysDrawImplicit, new Object[0])));
        cvBackground.addPanel(btnViewMode);
        CanvasQuestLine oldCvQuest = this.cvQuest;
        this.cvQuest = new CanvasQuestLine(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), 2);
        CanvasEmpty cvQuestPopup = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0)){

            @Override
            public boolean onMouseClick(int mx, int my, int click) {
                if (GuiQuestLines.this.cvQuest.getQuestLine() == null || !this.getTransform().contains(mx, my)) {
                    return false;
                }
                if (click == 1) {
                    boolean questExistsUnderMouse;
                    FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                    boolean bl = questExistsUnderMouse = GuiQuestLines.this.cvQuest.getButtonAt(mx, my) != null;
                    if (questExistsUnderMouse) {
                        UUID questId = (UUID)((Map.Entry)GuiQuestLines.this.cvQuest.getButtonAt(mx, my).getStoredValue()).getKey();
                        int maxWidth = questExistsUnderMouse ? RenderUtils.getStringWidth(QuestTranslation.translate("betterquesting.btn.share_quest", new Object[0]), fr) : 0;
                        PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, maxWidth + 12, questExistsUnderMouse ? 48 : 16), true);
                        Runnable questSharer = () -> {
                            GuiQuestLines.this.field_146297_k.field_71439_g.func_71165_d("betterquesting.msg.sharequest:" + questId);
                            GuiQuestLines.this.field_146297_k.func_147108_a(null);
                        };
                        popup.addButton(QuestTranslation.translate("betterquesting.btn.share_quest", new Object[0]), null, questSharer);
                        Runnable copyQuestId = () -> {
                            StringSelection stringToCopy = new StringSelection(questId.toString());
                            try {
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringToCopy, null);
                                GuiQuestLines.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(QuestTranslation.translate("betterquesting.msg.copy_quest_copied", new Object[0])));
                                GuiQuestLines.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("  " + EnumChatFormatting.AQUA + questId));
                            }
                            catch (IllegalStateException e) {
                                GuiQuestLines.this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(QuestTranslation.translate("betterquesting.msg.copy_quest_failed", new Object[0])));
                            }
                            GuiQuestLines.this.closePopup();
                        };
                        popup.addButton(QuestTranslation.translate("betterquesting.btn.copy_quest", new Object[0]), null, copyQuestId);
                        GuiQuestLines.this.openPopup(popup);
                        return true;
                    }
                }
                return false;
            }
        };
        cvFrame.addPanel(this.cvQuest);
        cvFrame.addPanel(cvQuestPopup);
        if (this.selectedLine != null) {
            this.cvQuest.setQuestLine(this.selectedLine);
            if (oldCvQuest != null) {
                this.cvQuest.setZoom(oldCvQuest.getZoom());
                this.cvQuest.setScrollX(oldCvQuest.getScrollX());
                this.cvQuest.setScrollY(oldCvQuest.getScrollY());
                this.cvQuest.refreshScrollBounds();
                this.cvQuest.updatePanelScroll();
            }
            this.refreshQuestCompletion();
            this.txTitle.setText(QuestTranslation.translateQuestLineName(selectedLineId, this.selectedLine));
            this.icoChapter.setTexture(new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        }
        cvChapterTray.setTrayState(chapterTrayOpened, 1L);
        cvDescTray.setTrayState(descTrayOpened, 1L);
        this.refreshChapterVisibility();
        this.refreshClaimAll();
        this.cvLines.setScrollY(this.scrollPosition.getChapterScrollY());
        this.cvLines.updatePanelScroll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        try {
            boolean bl = super.onMouseRelease(mx, my, click);
            return bl;
        }
        finally {
            if (this.cvLines != null) {
                this.scrollPosition.setChapterScrollY(this.cvLines.getScrollY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        try {
            boolean bl = super.onMouseScroll(mx, my, scroll);
            return bl;
        }
        finally {
            if (this.cvLines != null) {
                this.scrollPosition.setChapterScrollY(this.cvLines.getScrollY());
            }
        }
    }

    private void claimAll() {
        if (this.cvQuest.getQuestButtons().isEmpty()) {
            return;
        }
        ArrayList<UUID> claimIdList = new ArrayList<UUID>();
        for (PanelButtonQuest pbQuest : this.cvQuest.getQuestButtons()) {
            IQuest q = (IQuest)((Map.Entry)pbQuest.getStoredValue()).getValue();
            if (q.getRewards().size() <= 0 || !q.canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            claimIdList.add((UUID)((Map.Entry)pbQuest.getStoredValue()).getKey());
        }
        NetQuestAction.requestClaim(claimIdList);
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), new GuiColorStatic(-12303292), 0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            Map.Entry quest = (Map.Entry)((PanelButtonStorage)btn).getStoredValue();
            GuiHome.bookmark = new GuiQuest(this, (UUID)quest.getKey());
            mc.func_147108_a(GuiHome.bookmark);
        }
    }

    private void refreshChapterVisibility() {
        boolean canEdit = QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        List<Map.Entry<UUID, IQuestLine>> lineList = QuestLineDatabase.INSTANCE.getOrderedEntries();
        this.visChapters.clear();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        for (Map.Entry<UUID, IQuestLine> entry : lineList) {
            int val;
            IQuestLine ql = entry.getValue();
            EnumQuestVisibility vis = (EnumQuestVisibility)((Object)ql.getProperty(NativeProps.VISIBILITY));
            if (!canEdit && vis == EnumQuestVisibility.HIDDEN) continue;
            boolean show = false;
            boolean unlocked = false;
            boolean complete = false;
            boolean allComplete = true;
            boolean pendingClaim = false;
            if (canEdit) {
                show = true;
                unlocked = true;
                complete = true;
            }
            if (BQ_Settings.viewMode) {
                show = true;
            }
            if (BQ_Settings.viewModeAllQuestLine) {
                unlocked = true;
            }
            for (Map.Entry qID : ql.entrySet()) {
                IQuest q = (IQuest)QuestDatabase.INSTANCE.get(qID.getKey());
                if (q == null) continue;
                if (allComplete && !this.isQuestCompletedForQuestline(playerID, q)) {
                    allComplete = false;
                }
                if (!pendingClaim && q.canClaimBasically((EntityPlayer)this.field_146297_k.field_71439_g)) {
                    pendingClaim = true;
                }
                if (!unlocked && q.isUnlocked(playerID)) {
                    unlocked = true;
                }
                if (!complete && q.isComplete(playerID)) {
                    complete = true;
                }
                if (!show && QuestCache.isQuestShown(q, playerID, (EntityPlayer)this.field_146297_k.field_71439_g)) {
                    show = true;
                }
                if (!unlocked || !complete || !show || !pendingClaim || allComplete) continue;
                break;
            }
            if (vis == EnumQuestVisibility.COMPLETED && !complete || vis == EnumQuestVisibility.UNLOCKED && !unlocked) continue;
            int n = val = pendingClaim ? 1 : 0;
            if (allComplete) {
                val |= 2;
            }
            if (!show) {
                val |= 4;
            }
            this.visChapters.add(new Tuple2<Map.Entry<UUID, IQuestLine>, Integer>(entry, val));
        }
        if (cvChapterTray.isTrayOpen()) {
            this.buildChapterList();
        }
    }

    private boolean isQuestCompletedForQuestline(UUID playerID, IQuest q) {
        if (q.isComplete(playerID)) {
            return true;
        }
        if (q.getProperty(NativeProps.VISIBILITY) == EnumQuestVisibility.HIDDEN) {
            return true;
        }
        if (q.getProperty(NativeProps.LOGIC_QUEST) == EnumLogic.XOR) {
            int reqCount = 0;
            for (UUID qRequirementId : q.getRequirements()) {
                IQuest quest = (IQuest)QuestDatabase.INSTANCE.get(qRequirementId);
                if (quest.isComplete(playerID)) {
                    ++reqCount;
                }
                if (reqCount != 2) continue;
                return true;
            }
        }
        return false;
    }

    private void buildChapterList() {
        this.cvLines.resetCanvas();
        this.btnListRef.clear();
        int listW = this.cvLines.getTransform().getWidth();
        for (int n = 0; n < this.visChapters.size(); ++n) {
            Map.Entry<UUID, IQuestLine> entry = this.visChapters.get(n).func_76341_a();
            int vis = this.visChapters.get(n).func_76340_b();
            this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(0, n * 16, 16, 16, 0), new OreDictTexture(1.0f, (BigItemStack)entry.getValue().getProperty(NativeProps.ICON), false, true)));
            if ((vis & 1) > 0) {
                this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(8, n * 16 + 8, 8, 8, -1), new GuiTextureColored(PresetIcon.ICON_NOTICE.getTexture(), new GuiColorStatic(-256))));
            } else if ((vis & 2) > 0) {
                this.cvLines.addPanel(new PanelGeneric(new GuiRectangle(8, n * 16 + 8, 8, 8, -1), new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936))));
            }
            PanelButtonStorage<Map.Entry<UUID, IQuestLine>> btnLine = new PanelButtonStorage<Map.Entry<UUID, IQuestLine>>(new GuiRectangle(16, n * 16, listW - 16, 16, 0), 1, QuestTranslation.translateQuestLineName(entry), entry);
            btnLine.setTextAlignment(0);
            btnLine.setActive((vis & 4) == 0 && !entry.getKey().equals(selectedLineId));
            btnLine.setCallback(this::openQuestLine);
            this.cvLines.addPanel(btnLine);
            this.btnListRef.add(btnLine);
        }
        this.cvLines.refreshScrollBounds();
        this.scLines.setEnabled(this.cvLines.getScrollBounds().getHeight() > 0);
    }

    private void refreshQuestCompletion() {
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        UUID playerUUId = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.selectedLine == null) {
            return;
        }
        this.questsCompleted = 0;
        this.totalQuests = 0;
        for (Map.Entry entry : this.selectedLine.entrySet()) {
            IQuest quest = (IQuest)QuestingAPI.getAPI(ApiReference.QUEST_DB).get(entry.getKey());
            ++this.totalQuests;
            if (!quest.isComplete(playerUUId) && quest.isUnlockable(playerUUId)) continue;
            ++this.questsCompleted;
        }
        this.completionText.setText(QuestTranslation.translate("betterquesting.title.completion", this.questsCompleted, this.totalQuests));
    }

    private void openQuestLine(Map.Entry<UUID, IQuestLine> q) {
        this.selectedLine = q.getValue();
        selectedLineId = q.getKey();
        for (int i = 0; i < this.btnListRef.size(); ++i) {
            this.btnListRef.get(i).setActive((this.visChapters.get(i).func_76340_b() & 4) == 0 && !this.btnListRef.get(i).getStoredValue().getKey().equals(selectedLineId));
        }
        this.cvQuest.setQuestLine(q.getValue());
        this.icoChapter.setTexture(new OreDictTexture(1.0f, (BigItemStack)q.getValue().getProperty(NativeProps.ICON), false, true), null);
        this.txTitle.setText(QuestTranslation.translateQuestLineName(q));
        this.refreshQuestCompletion();
        if (!trayLock) {
            cvFrame.setTrayState(true, 200L);
            cvChapterTray.setTrayState(false, 200L);
            this.cvQuest.fitToWindow();
        }
        this.refreshClaimAll();
    }

    private void refreshContent() {
        if (selectedLineId != null) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.get(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = null;
            }
        } else {
            this.selectedLine = null;
        }
        float zoom = this.cvQuest.getZoom();
        int sx = this.cvQuest.getScrollX();
        int sy = this.cvQuest.getScrollY();
        this.cvQuest.setQuestLine(this.selectedLine);
        this.cvQuest.setZoom(zoom);
        this.cvQuest.setScrollX(sx);
        this.cvQuest.setScrollY(sy);
        this.cvQuest.refreshScrollBounds();
        this.cvQuest.updatePanelScroll();
        if (this.selectedLine != null) {
            this.refreshQuestCompletion();
            this.txTitle.setText(QuestTranslation.translateQuestLineName(selectedLineId, this.selectedLine));
            this.icoChapter.setTexture(new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        } else {
            this.txTitle.setText("");
            this.icoChapter.setTexture(null, null);
        }
        this.refreshClaimAll();
    }

    private void refreshClaimAll() {
        if (this.cvQuest.getQuestLine() == null || this.cvQuest.getQuestButtons().size() <= 0) {
            this.claimAll.setActive(false);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), new GuiColorStatic(-12303292), 0);
            return;
        }
        for (PanelButtonQuest btn : this.cvQuest.getQuestButtons()) {
            if (!((IQuest)((Map.Entry)btn.getStoredValue()).getValue()).canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            this.claimAll.setActive(true);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), new GuiColorPulse(-1, -12303292, 2.0, 0.0f), 0);
            return;
        }
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), new GuiColorStatic(-12303292), 0);
        this.claimAll.setActive(false);
    }

    private void openSearch(PanelButton panelButton) {
        GuiQuestSearch guiQuestSearch = new GuiQuestSearch(this);
        guiQuestSearch.setCallback(entry -> {
            this.openQuestLine(entry.getQuestLineEntry());
            UUID selectedQuestId = entry.getQuest().getKey();
            Optional<PanelButtonQuest> targetQuestButton = this.cvQuest.getQuestButtons().stream().filter(panelButtonQuest -> ((UUID)((Map.Entry)panelButtonQuest.getStoredValue()).getKey()).equals(selectedQuestId)).findFirst();
            targetQuestButton.ifPresent(panelButtonQuest -> {
                GuiTextureColored newTexture = new GuiTextureColored(panelButtonQuest.txFrame, new GuiColorPulse(new GuiColorStatic(255, 220, 115, 255), new GuiColorStatic(255, 191, 0, 255), 1.0, 0.0f));
                panelButtonQuest.setTextures(newTexture, newTexture, newTexture);
            });
        });
        this.field_146297_k.func_147108_a((GuiScreen)guiQuestSearch);
    }

    public static class ScrollPosition {
        private int chapterScrollY;

        public ScrollPosition(int chapterScrollY) {
            this.chapterScrollY = chapterScrollY;
        }

        public int getChapterScrollY() {
            return this.chapterScrollY;
        }

        public void setChapterScrollY(int chapterScrollY) {
            this.chapterScrollY = chapterScrollY;
        }
    }
}

