/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.QuestSettings;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;

public class PanelButtonQuest
extends PanelButtonStorage<Map.Entry<UUID, IQuest>> {
    public final GuiRectangle rect;
    public final EntityPlayer player;
    public final IGuiTexture txFrame;

    public PanelButtonQuest(GuiRectangle rect, int id, String txt, Map.Entry<UUID, IQuest> value) {
        super(rect, id, txt, value);
        this.rect = rect;
        this.player = Minecraft.func_71410_x().field_71439_g;
        EnumQuestState qState = value == null ? EnumQuestState.LOCKED : value.getValue().getState(this.player);
        IGuiColor txIconCol = null;
        boolean main = value == null ? false : value.getValue().getProperty(NativeProps.MAIN);
        boolean lock = false;
        switch (qState) {
            case LOCKED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_0.getTexture() : PresetTexture.QUEST_NORM_0.getTexture();
                txIconCol = PresetColor.QUEST_ICON_LOCKED.getColor();
                lock = true;
                break;
            }
            case UNLOCKED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_1.getTexture() : PresetTexture.QUEST_NORM_1.getTexture();
                txIconCol = PresetColor.QUEST_ICON_UNLOCKED.getColor();
                break;
            }
            case UNCLAIMED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_2.getTexture() : PresetTexture.QUEST_NORM_2.getTexture();
                txIconCol = PresetColor.QUEST_ICON_PENDING.getColor();
                break;
            }
            case COMPLETED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_3.getTexture() : PresetTexture.QUEST_NORM_3.getTexture();
                txIconCol = PresetColor.QUEST_ICON_COMPLETE.getColor();
                break;
            }
            case REPEATABLE: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_4.getTexture() : PresetTexture.QUEST_NORM_4.getTexture();
                txIconCol = PresetColor.QUEST_ICON_REPEATABLE.getColor();
                break;
            }
            default: {
                this.txFrame = null;
            }
        }
        GuiTextureColored btnTx = new GuiTextureColored(this.txFrame, txIconCol);
        this.setTextures(btnTx, btnTx, btnTx);
        this.setIcon(new OreDictTexture(1.0f, value == null ? new BigItemStack(Items.field_151156_bN) : value.getValue().getProperty(NativeProps.ICON), false, true), 4);
        this.setActive(QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit(this.player) || !lock || BQ_Settings.viewMode);
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (!this.getTransform().contains(mx, my)) {
            return null;
        }
        Map.Entry value = (Map.Entry)this.getStoredValue();
        return value == null ? Collections.emptyList() : this.getQuestTooltip((IQuest)value.getValue(), this.player, (UUID)value.getKey());
    }

    private List<String> getQuestTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        List<String> tooltip = this.getStandardTooltip(quest, player, qID);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            tooltip.add("");
            tooltip.addAll(this.getAdvancedTooltip(quest, player, qID));
        }
        return tooltip;
    }

    private List<String> getStandardTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(QuestTranslation.translateQuestName(qID, quest) + (!Minecraft.func_71410_x().field_71474_y.field_82882_x ? "" : " #" + qID));
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (quest.isComplete(playerID)) {
            list.add(ChatFormatting.GREEN + QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            if (quest.canClaimBasically(player)) {
                list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.rewards_pending", new Object[0]));
            } else if (!quest.hasClaimed(playerID)) {
                list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeatable", new Object[0]));
            } else if (quest.getProperty(NativeProps.REPEAT_TIME) > 0) {
                long time = this.getRepeatSeconds(quest, player);
                DecimalFormat df = new DecimalFormat("00");
                String timeTxt = "";
                if (time < 0L) {
                    timeTxt = timeTxt + "-";
                    time *= -1L;
                }
                if (time >= 3600L) {
                    timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
                } else if (time >= 60L) {
                    timeTxt = timeTxt + time / 60L + "m ";
                }
                timeTxt = timeTxt + df.format(time % 60L) + "s";
                list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
                if (QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
                    list.add(ChatFormatting.RED + QuestTranslation.translate("betterquesting.tooltip.repeat_with_edit_mode", new Object[0]));
                }
            }
        } else if (!quest.isUnlocked(playerID)) {
            list.add(ChatFormatting.RED + "" + ChatFormatting.UNDERLINE + QuestTranslation.translate("betterquesting.tooltip.requires", new Object[0]) + " (" + quest.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase() + ")");
            QuestDatabase.INSTANCE.filterKeys(quest.getRequirements()).entrySet().stream().filter(entry -> !((IQuest)entry.getValue()).isComplete(playerID)).forEach(entry -> list.add(ChatFormatting.RED + "- " + QuestTranslation.translateQuestName(entry)));
        } else {
            int n = 0;
            for (DBEntry task : quest.getTasks().getEntries()) {
                if (!((ITask)task.getValue()).isComplete(playerID)) continue;
                ++n;
            }
            list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.tasks_complete", n, quest.getTasks().size()));
        }
        return list;
    }

    private List<String> getAdvancedTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_quest", quest.getProperty(NativeProps.GLOBAL)));
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_share", quest.getProperty(NativeProps.GLOBAL_SHARE)));
        }
        list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.quest_logic", quest.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase()));
        list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.simultaneous", quest.getProperty(NativeProps.SIMULTANEOUS)));
        list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.auto_claim", quest.getProperty(NativeProps.AUTO_CLAIM)));
        if (quest.getProperty(NativeProps.REPEAT_TIME) >= 0) {
            long time = quest.getProperty(NativeProps.REPEAT_TIME) / 20;
            DecimalFormat df = new DecimalFormat("00");
            String timeTxt = "";
            if (time >= 3600L) {
                timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
            } else if (time >= 60L) {
                timeTxt = timeTxt + time / 60L + "m ";
            }
            timeTxt = timeTxt + df.format(time % 60L) + "s";
            list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
        } else {
            list.add(ChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", false));
        }
        return list;
    }

    private long getRepeatSeconds(IQuest quest, EntityPlayer player) {
        if (quest.getProperty(NativeProps.REPEAT_TIME) < 0) {
            return -1L;
        }
        NBTTagCompound ue = quest.getCompletionInfo(QuestingAPI.getQuestingUUID(player));
        if (ue == null) {
            return 0L;
        }
        return ((long)quest.getProperty(NativeProps.REPEAT_TIME).intValue() * 50L - (System.currentTimeMillis() - ue.func_74763_f("timestamp"))) / 1000L;
    }
}

