/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api2.utils.OreIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;

public class BigItemStack {
    private static final OreIngredient NO_ORE = new OreIngredient("");
    public int stackSize;
    private String oreDict = "";
    private OreIngredient oreIng = NO_ORE;
    @Nonnull
    private ItemStack baseStack;

    public BigItemStack(ItemStack stack) {
        this.baseStack = stack.func_77946_l();
        this.stackSize = this.baseStack.field_77994_a;
        this.baseStack.field_77994_a = 1;
    }

    public BigItemStack(@Nonnull Block block) {
        this(block, 1, 0);
    }

    public BigItemStack(@Nonnull Block block, int amount) {
        this(block, amount, 0);
    }

    public BigItemStack(@Nonnull Block block, int amount, int damage) {
        this.baseStack = new ItemStack(block, 1, damage);
        this.stackSize = amount;
    }

    public BigItemStack(@Nonnull Item item) {
        this(item, 1, 0);
    }

    public BigItemStack(@Nonnull Item item, int amount) {
        this(item, amount, 0);
    }

    public BigItemStack(@Nonnull Item item, int amount, int damage) {
        this.baseStack = new ItemStack(item, 1, damage);
        this.stackSize = amount;
    }

    @Nonnull
    public ItemStack getBaseStack() {
        return this.baseStack;
    }

    public boolean hasOreDict() {
        return !StringUtils.func_151246_b((String)this.oreDict) && this.oreIng.getMatchingStacks().length > 0;
    }

    @Nonnull
    public String getOreDict() {
        return this.oreDict;
    }

    @Nonnull
    public OreIngredient getOreIngredient() {
        return this.oreIng;
    }

    public BigItemStack setOreDict(@Nonnull String ore) {
        this.oreDict = ore;
        this.oreIng = ore.length() <= 0 ? NO_ORE : new OreIngredient(ore);
        return this;
    }

    public NBTTagCompound GetTagCompound() {
        return this.baseStack.func_77978_p();
    }

    public void SetTagCompound(NBTTagCompound tags) {
        this.baseStack.func_77982_d(tags);
    }

    public boolean HasTagCompound() {
        return this.baseStack.func_77942_o();
    }

    public List<ItemStack> getCombinedStacks() {
        int size;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int tmp1 = Math.max(1, this.stackSize); tmp1 > 0; tmp1 -= size) {
            size = Math.min(tmp1, this.baseStack.func_77976_d());
            ItemStack stack = this.baseStack.func_77946_l();
            stack.field_77994_a = size;
            list.add(stack);
        }
        return list;
    }

    public BigItemStack copy() {
        BigItemStack stack = new BigItemStack(this.baseStack.func_77946_l());
        stack.stackSize = this.stackSize;
        stack.oreDict = this.oreDict;
        return stack;
    }

    public boolean equals(Object stack) {
        if (stack == this.baseStack) {
            return true;
        }
        if (stack instanceof ItemStack) {
            return this.baseStack.func_77969_a((ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.baseStack, (ItemStack)((ItemStack)stack));
        }
        return super.equals(stack);
    }

    @Nullable
    public static BigItemStack loadItemStackFromNBT(@Nonnull NBTTagCompound nbt) {
        ItemStack miniStack;
        NBTTagCompound itemNBT = nbt;
        if (!nbt.func_150297_b("id", 99)) {
            itemNBT = (NBTTagCompound)nbt.func_74737_b();
            String idName = nbt.func_74779_i("id");
            Item item = (Item)Item.field_150901_e.func_82594_a(idName);
            if (item == null) {
                try {
                    item = Item.func_150899_d((int)Short.parseShort(idName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (item == null) {
                return null;
            }
            itemNBT.func_74768_a("id", Item.field_150901_e.func_148757_b((Object)item));
        }
        if ((miniStack = ItemStack.func_77949_a((NBTTagCompound)itemNBT)) == null || miniStack.func_77973_b() == null) {
            return null;
        }
        BigItemStack bigStack = new BigItemStack(miniStack);
        bigStack.stackSize = nbt.func_74762_e("Count");
        bigStack.setOreDict(nbt.func_74779_i("OreDict"));
        if (nbt.func_74765_d("Damage") < 0) {
            bigStack.baseStack.func_77964_b(Short.MAX_VALUE);
        }
        return bigStack;
    }

    @Deprecated
    public void readFromNBT(NBTTagCompound tags) {
        BigItemStack stack = BigItemStack.loadItemStackFromNBT(tags);
        if (stack == null) {
            return;
        }
        this.baseStack = stack.baseStack;
        this.oreDict = stack.oreDict;
        this.stackSize = stack.stackSize;
        this.oreIng = stack.oreIng;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.baseStack.func_77955_b(nbt);
        String iRes = Item.field_150901_e.func_148750_c((Object)this.baseStack.func_77973_b());
        nbt.func_74778_a("id", iRes == null ? "minecraft:air" : iRes);
        nbt.func_74768_a("Count", this.stackSize);
        nbt.func_74778_a("OreDict", this.getOreDict());
        return nbt;
    }
}

