/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.ScoreboardBQ;
import bq_standard.client.gui.editors.tasks.GuiEditTaskScoreboard;
import bq_standard.client.gui.tasks.PanelTaskScoreboard;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.base.TaskBase;
import bq_standard.tasks.factory.FactoryTaskScoreboard;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.ScoreDummyCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskScoreboard
extends TaskBase
implements ITaskTickable {
    public String scoreName = "Score";
    public String scoreDisp = "Score";
    public String type = "dummy";
    public int target = 1;
    public float conversion = 1.0f;
    public String suffix = "";
    public ScoreOperation operation = ScoreOperation.MORE_OR_EQUAL;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.scoreName = nbt.func_74779_i("scoreName");
        this.scoreName = this.scoreName.replaceAll(" ", "_");
        this.scoreDisp = nbt.func_74779_i("scoreDisp");
        this.type = nbt.func_150297_b("type", 8) ? nbt.func_74779_i("type") : "dummy";
        this.target = nbt.func_74762_e("target");
        this.conversion = nbt.func_74760_g("unitConversion");
        this.suffix = nbt.func_74779_i("unitSuffix");
        try {
            this.operation = ScoreOperation.valueOf(nbt.func_150297_b("operation", 8) ? nbt.func_74779_i("operation") : "MORE_OR_EQUAL");
        }
        catch (Exception e) {
            this.operation = ScoreOperation.MORE_OR_EQUAL;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("scoreName", this.scoreName);
        nbt.func_74778_a("scoreDisp", this.scoreDisp);
        nbt.func_74778_a("type", this.type);
        nbt.func_74768_a("target", this.target);
        nbt.func_74776_a("unitConversion", this.conversion);
        nbt.func_74778_a("unitSuffix", this.suffix);
        nbt.func_74778_a("operation", this.operation.name());
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.scoreboard";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskScoreboard.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskScoreboard(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskScoreboard(parent, quest, this);
    }

    @Override
    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        Scoreboard board = pInfo.PLAYER.func_96123_co();
        ScoreObjective scoreObj = board.func_96518_b(this.scoreName);
        if (scoreObj == null) {
            try {
                IScoreObjectiveCriteria criteria = (IScoreObjectiveCriteria)IScoreObjectiveCriteria.field_96643_a.get(this.type);
                criteria = criteria != null ? criteria : new ScoreDummyCriteria(this.scoreName);
                scoreObj = board.func_96535_a(this.scoreName, criteria);
                scoreObj.func_96681_a(this.scoreDisp);
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to create score '" + this.scoreName + "' for task!", (Throwable)e);
                return;
            }
        }
        int points = board.func_96529_a(pInfo.PLAYER.func_70005_c_(), scoreObj).func_96652_c();
        ScoreboardBQ.INSTANCE.setScore(pInfo.UUID, this.scoreName, points);
        if (this.operation.checkValues(points, this.target)) {
            this.setComplete(pInfo.UUID);
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, @Nonnull DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 20 == 0) {
            this.detect(pInfo, quest);
        }
    }

    @Override
    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(this.scoreName);
        texts.add(this.scoreDisp);
        return texts;
    }

    public static enum ScoreOperation {
        EQUAL("="),
        LESS_THAN("<"),
        MORE_THAN(">"),
        LESS_OR_EQUAL("<="),
        MORE_OR_EQUAL(">="),
        NOT("=/=");

        private final String text;

        private ScoreOperation(String text) {
            this.text = text;
        }

        public String GetText() {
            return this.text;
        }

        public boolean checkValues(int n1, int n2) {
            switch (this) {
                case EQUAL: {
                    return n1 == n2;
                }
                case LESS_THAN: {
                    return n1 < n2;
                }
                case MORE_THAN: {
                    return n1 > n2;
                }
                case LESS_OR_EQUAL: {
                    return n1 <= n2;
                }
                case MORE_OR_EQUAL: {
                    return n1 >= n2;
                }
                case NOT: {
                    return n1 != n2;
                }
            }
            return false;
        }
    }
}

