/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class NetQuestEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:quest_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetQuestEdit::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetQuestEdit::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendEdit(NBTTagCompound payload) {
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        MinecraftServer server = sender.field_71133_b;
        if (server == null) {
            return;
        }
        boolean isOP = server.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit quests without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(ChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        NBTTagCompound tag = message.func_76341_a();
        UUID senderID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        switch (action) {
            case 0: {
                NetQuestEdit.editQuests(tag.func_150295_c("data", 10));
                break;
            }
            case 1: {
                NetQuestEdit.deleteQuests(tag.func_74759_k("questIDs"));
                break;
            }
            case 2: {
                NetQuestEdit.setQuestStates(tag.func_74759_k("questIDs"), tag.func_74767_n("state"), senderID);
                break;
            }
            case 3: {
                NetQuestEdit.createQuests(tag.func_150295_c("data", 10));
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid quest edit action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    public static void editQuests(NBTTagList data) {
        int[] ids = new int[data.func_74745_c()];
        for (int i = 0; i < data.func_74745_c(); ++i) {
            int questID;
            NBTTagCompound entry = data.func_150305_b(i);
            ids[i] = questID = entry.func_74762_e("questID");
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(questID);
            if (quest == null) continue;
            quest.readFromNBT(entry.func_74775_l("config"));
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.sendSync(null, ids, true, false);
    }

    public static void deleteQuests(int[] questIDs) {
        for (int id : questIDs) {
            QuestDatabase.INSTANCE.removeID(id);
            QuestLineDatabase.INSTANCE.removeQuest(id);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74783_a("questIDs", questIDs);
        payload.func_74768_a("action", 1);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    public static void setQuestStates(int[] questIDs, boolean state, UUID targetID) {
        List questList = QuestDatabase.INSTANCE.bulkLookup(questIDs);
        block0: for (DBEntry entry : questList) {
            if (!state) {
                ((IQuest)entry.getValue()).resetUser(targetID, true);
                continue;
            }
            if (((IQuest)entry.getValue()).isComplete(targetID)) {
                ((IQuest)entry.getValue()).setClaimed(targetID, 0L);
                continue;
            }
            ((IQuest)entry.getValue()).setComplete(targetID, 0L);
            int done = 0;
            if (((IQuest)entry.getValue()).getProperty(NativeProps.LOGIC_TASK).getResult(done, ((IQuest)entry.getValue()).getTasks().size())) continue;
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                ((ITask)task.getValue()).setComplete(targetID);
                if (!((IQuest)entry.getValue()).getProperty(NativeProps.LOGIC_TASK).getResult(++done, ((IQuest)entry.getValue()).getTasks().size())) continue;
                continue block0;
            }
        }
        SaveLoadHandler.INSTANCE.markDirty();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        EntityPlayerMP player = null;
        for (Object o : server.func_71203_ab().field_72404_b) {
            if (!((EntityPlayerMP)o).func_146103_bH().getId().equals(targetID)) continue;
            player = (EntityPlayerMP)o;
        }
        if (player == null) {
            return;
        }
        NetQuestSync.sendSync(player, questIDs, false, true);
    }

    public static void createQuests(NBTTagList data) {
        int[] ids = new int[data.func_74745_c()];
        for (int i = 0; i < data.func_74745_c(); ++i) {
            int questID;
            NBTTagCompound entry = data.func_150305_b(i);
            int n = questID = entry.func_150297_b("questID", 99) ? entry.func_74762_e("questID") : -1;
            if (questID < 0) {
                questID = QuestDatabase.INSTANCE.nextID();
            }
            ids[i] = questID;
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(questID);
            if (quest == null) {
                quest = QuestDatabase.INSTANCE.createNew(questID);
            }
            if (!entry.func_150297_b("config", 10)) continue;
            quest.readFromNBT(entry.func_74775_l("config"));
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.sendSync(null, ids, true, false);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        int action;
        int n = action = !message.func_150297_b("action", 99) ? -1 : message.func_74762_e("action");
        if (action == 1) {
            for (int id : message.func_74759_k("questIDs")) {
                QuestDatabase.INSTANCE.removeID(id);
                QuestLineDatabase.INSTANCE.removeQuest(id);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
        }
    }
}

