/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.party.PartyInstance;
import betterquesting.storage.QuestSettings;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyManager
extends SimpleDatabase<IParty>
implements IPartyDatabase {
    public static final PartyManager INSTANCE = new PartyManager();
    private final HashMap<UUID, Integer> partyCache = new HashMap();

    @Override
    public synchronized IParty createNew(int id) {
        PartyInstance party = new PartyInstance();
        if (id >= 0) {
            this.add(id, party);
        }
        return party;
    }

    @Override
    @Nullable
    public synchronized DBEntry<IParty> getParty(@Nonnull UUID uuid) {
        IParty cachedParty;
        if (!QuestSettings.INSTANCE.getProperty(NativeProps.PARTY_ENABLE).booleanValue()) {
            return null;
        }
        Integer cachedID = this.partyCache.get(uuid);
        IParty iParty = cachedParty = cachedID == null ? null : (IParty)this.getValue(cachedID);
        if (cachedID != null && cachedParty == null) {
            this.partyCache.remove(uuid);
        } else if (cachedParty != null) {
            EnumPartyStatus status = cachedParty.getStatus(uuid);
            if (status != null) {
                return new DBEntry<IParty>(cachedID, cachedParty);
            }
            this.partyCache.remove(uuid);
        }
        for (DBEntry<IParty> dBEntry : this.getEntries()) {
            EnumPartyStatus status = ((IParty)dBEntry.getValue()).getStatus(uuid);
            if (status == null) continue;
            this.partyCache.put(uuid, dBEntry.getID());
            return dBEntry;
        }
        return null;
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, @Nullable List<Integer> subset) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jp = ((IParty)entry.getValue()).writeToNBT(new NBTTagCompound());
            jp.func_74768_a("partyID", entry.getID());
            json.func_74742_a((NBTBase)jp);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, boolean merge) {
        if (!merge) {
            this.reset();
        }
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int partyID;
            NBTTagCompound jp = json.func_150305_b(i);
            int n = partyID = jp.func_150297_b("partyID", 99) ? jp.func_74762_e("partyID") : -1;
            if (partyID < 0) continue;
            PartyInstance party = new PartyInstance();
            party.readFromNBT(jp);
            if (party.getMembers().size() <= 0) continue;
            this.add(partyID, party);
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.partyCache.clear();
    }
}

