/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.QuestNotification;
import betterquesting.client.gui2.GuiHome;
import betterquesting.core.BetterQuesting;
import betterquesting.legacy.ILegacyLoader;
import betterquesting.legacy.LegacyLoaderRegistry;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class SaveLoadHandler {
    public static SaveLoadHandler INSTANCE = new SaveLoadHandler();
    private boolean hasUpdate = false;
    private boolean isDirty = false;

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public void resetUpdate() {
        this.hasUpdate = false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void loadDatabases(MinecraftServer server) {
        ILegacyLoader loader;
        File rootDir;
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.reset();
        QuestLineDatabase.INSTANCE.reset();
        LifeDatabase.INSTANCE.reset();
        NameCache.INSTANCE.reset();
        this.hasUpdate = false;
        if (BetterQuesting.proxy.isClient()) {
            GuiHome.bookmark = null;
            QuestNotification.resetNotices();
        }
        if (BetterQuesting.proxy.isClient()) {
            BQ_Settings.curWorldDir = server.func_71209_f("saves/" + server.func_71270_I() + "/betterquesting");
            rootDir = server.func_71209_f("saves/" + server.func_71270_I());
        } else {
            BQ_Settings.curWorldDir = server.func_71209_f(server.func_71270_I() + "/betterquesting");
            rootDir = server.func_71209_f(server.func_71270_I());
        }
        File fileDatabase = new File(BQ_Settings.curWorldDir, "QuestDatabase.json");
        File fileProgress = new File(BQ_Settings.curWorldDir, "QuestProgress.json");
        File fileParties = new File(BQ_Settings.curWorldDir, "QuestingParties.json");
        File fileLives = new File(BQ_Settings.curWorldDir, "LifeDatabase.json");
        File fileNames = new File(BQ_Settings.curWorldDir, "NameCache.json");
        if (new File(rootDir, "QuestDatabase.json").exists() && !fileDatabase.exists()) {
            File legFileDat = new File(rootDir, "QuestDatabase.json");
            File legFilePro = new File(rootDir, "QuestProgress.json");
            File legFilePar = new File(rootDir, "QuestingParties.json");
            File legFileLiv = new File(rootDir, "LifeDatabase.json");
            File legFileNam = new File(rootDir, "NameCache.json");
            JsonHelper.CopyPaste(legFileDat, fileDatabase);
            JsonHelper.CopyPaste(legFilePro, fileProgress);
            JsonHelper.CopyPaste(legFilePar, fileParties);
            JsonHelper.CopyPaste(legFileLiv, fileLives);
            JsonHelper.CopyPaste(legFileNam, fileNames);
            legFileDat.delete();
            legFilePro.delete();
            legFilePar.delete();
            legFileLiv.delete();
            legFileNam.delete();
        }
        boolean useDef = !fileDatabase.exists();
        int packVer = 0;
        String packName = "";
        if (useDef) {
            fileDatabase = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
            this.isDirty = true;
        } else {
            JsonObject defTmp = JsonHelper.ReadFromFile(new File(BQ_Settings.defaultDir, "DefaultQuests.json"));
            QuestSettings tmpSettings = new QuestSettings();
            tmpSettings.readFromNBT(NBTConverter.JSONtoNBT_Object(defTmp, new NBTTagCompound(), true).func_74775_l("questSettings"));
            packVer = tmpSettings.getProperty(NativeProps.PACK_VER);
            packName = tmpSettings.getProperty(NativeProps.PACK_NAME);
        }
        JsonObject j1 = JsonHelper.ReadFromFile(fileDatabase);
        NBTTagCompound nbt1 = NBTConverter.JSONtoNBT_Object(j1, new NBTTagCompound(), true);
        String fVer = nbt1.func_150297_b("format", 8) ? nbt1.func_74779_i("format") : "0.0.0";
        String bVer = nbt1.func_74779_i("build");
        String cVer = Loader.instance().activeModContainer().getVersion();
        if (!cVer.equalsIgnoreCase(bVer) && !useDef) {
            String fsVer = JsonHelper.makeFileNameSafe(bVer);
            if (fsVer.length() <= 0) {
                fsVer = "pre-251";
            }
            BetterQuesting.logger.warn("BetterQuesting has been updated to from \"" + fsVer + "\" to \"" + cVer + "\"! Creating back ups...");
            JsonHelper.CopyPaste(fileDatabase, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestDatabase_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(fileProgress, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestProgress_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(fileParties, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestingParties_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(fileNames, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "NameCache_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(fileLives, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "LifeDatabase_backup_" + fsVer + ".json"));
        }
        if ((loader = LegacyLoaderRegistry.getLoader(fVer)) == null) {
            QuestSettings.INSTANCE.readFromNBT(nbt1.func_74775_l("questSettings"));
            QuestDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questDatabase", 10), false);
            QuestLineDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questLines", 10), false);
        } else {
            loader.readFromJson((JsonElement)j1);
        }
        if (useDef) {
            QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        }
        this.hasUpdate = packName.equals(QuestSettings.INSTANCE.getProperty(NativeProps.PACK_NAME)) && packVer > QuestSettings.INSTANCE.getProperty(NativeProps.PACK_VER);
        JsonObject j2 = JsonHelper.ReadFromFile(fileProgress);
        if (loader == null) {
            NBTTagCompound nbt2 = NBTConverter.JSONtoNBT_Object(j2, new NBTTagCompound(), true);
            QuestDatabase.INSTANCE.readProgressFromNBT(nbt2.func_150295_c("questProgress", 10), false);
        } else {
            loader.readProgressFromJson((JsonElement)j2);
        }
        JsonObject j3 = JsonHelper.ReadFromFile(fileParties);
        NBTTagCompound nbt3 = NBTConverter.JSONtoNBT_Object(j3, new NBTTagCompound(), true);
        PartyManager.INSTANCE.readFromNBT(nbt3.func_150295_c("parties", 10), false);
        JsonObject j4 = JsonHelper.ReadFromFile(fileNames);
        NBTTagCompound nbt4 = NBTConverter.JSONtoNBT_Object(j4, new NBTTagCompound(), true);
        NameCache.INSTANCE.readFromNBT(nbt4.func_150295_c("nameCache", 10), false);
        JsonObject j5 = JsonHelper.ReadFromFile(fileLives);
        NBTTagCompound nbt5 = NBTConverter.JSONtoNBT_Object(j5, new NBTTagCompound(), true);
        LifeDatabase.INSTANCE.readFromNBT(nbt5.func_74775_l("lifeDatabase"), false);
        BetterQuesting.logger.info("Loaded " + QuestDatabase.INSTANCE.size() + " quests");
        BetterQuesting.logger.info("Loaded " + QuestLineDatabase.INSTANCE.size() + " quest lines");
        BetterQuesting.logger.info("Loaded " + PartyManager.INSTANCE.size() + " parties");
        BetterQuesting.logger.info("Loaded " + NameCache.INSTANCE.size() + " names");
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Load(DatabaseEvent.DBType.ALL));
    }

    public void saveDatabases() {
        if (!BQ_Settings.dirtyMode || this.isDirty || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            NBTTagCompound jsonCon = new NBTTagCompound();
            jsonCon.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
            jsonCon.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
            jsonCon.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
            jsonCon.func_74778_a("format", "2.0.0");
            jsonCon.func_74778_a("build", Loader.instance().activeModContainer().getVersion());
            JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestDatabase.json"), NBTConverter.NBTtoJSON_Compound(jsonCon, new JsonObject(), true));
        }
        NBTTagCompound jsonProg = new NBTTagCompound();
        jsonProg.func_74782_a("questProgress", (NBTBase)QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null));
        JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestProgress.json"), NBTConverter.NBTtoJSON_Compound(jsonProg, new JsonObject(), true));
        NBTTagCompound jsonP = new NBTTagCompound();
        jsonP.func_74782_a("parties", (NBTBase)PartyManager.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
        JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "QuestingParties.json"), NBTConverter.NBTtoJSON_Compound(jsonP, new JsonObject(), true));
        NBTTagCompound jsonN = new NBTTagCompound();
        jsonN.func_74782_a("nameCache", (NBTBase)NameCache.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "NameCache.json"), NBTConverter.NBTtoJSON_Compound(jsonN, new JsonObject(), true));
        NBTTagCompound jsonL = new NBTTagCompound();
        jsonL.func_74782_a("lifeDatabase", (NBTBase)LifeDatabase.INSTANCE.writeToNBT(new NBTTagCompound(), (List<UUID>)null));
        JsonHelper.WriteToFile(new File(BQ_Settings.curWorldDir, "LifeDatabase.json"), NBTConverter.NBTtoJSON_Compound(jsonL, new JsonObject(), true));
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Save(DatabaseEvent.DBType.ALL));
        this.isDirty = false;
    }

    public void unloadDatabases() {
        BQ_Settings.curWorldDir = null;
        this.hasUpdate = false;
        this.isDirty = false;
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.reset();
        QuestLineDatabase.INSTANCE.reset();
        LifeDatabase.INSTANCE.reset();
        NameCache.INSTANCE.reset();
        if (BetterQuesting.proxy.isClient()) {
            GuiHome.bookmark = null;
            QuestNotification.resetNotices();
        }
    }
}

