/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class SimpleDatabase<T>
implements IDatabase<T> {
    private final TreeMap<Integer, T> mapDB = new TreeMap();
    private final BitSet idMap = new BitSet();
    private List<DBEntry<T>> refCache = null;

    @Override
    public synchronized int nextID() {
        return this.idMap.nextClearBit(0);
    }

    @Override
    public synchronized DBEntry<T> add(int id, T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        if (this.mapDB.putIfAbsent(id, value) == null) {
            this.idMap.set(id);
            this.refCache = null;
            return new DBEntry<T>(id, value);
        }
        throw new IllegalArgumentException("ID or value is already contained within database");
    }

    @Override
    public synchronized boolean removeID(int key) {
        if (key < 0) {
            return false;
        }
        if (this.mapDB.remove(key) != null) {
            this.idMap.clear(key);
            this.refCache = null;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeValue(T value) {
        return value != null && this.removeID(this.getID(value));
    }

    @Override
    public synchronized int getID(T value) {
        if (value == null) {
            return -1;
        }
        for (DBEntry<T> entry : this.getEntries()) {
            if (entry.getValue() != value) continue;
            return entry.getID();
        }
        return -1;
    }

    @Override
    public synchronized T getValue(int id) {
        if (id < 0 || this.mapDB.size() <= 0) {
            return null;
        }
        return this.mapDB.get(id);
    }

    @Override
    public synchronized int size() {
        return this.mapDB.size();
    }

    @Override
    public synchronized void reset() {
        this.mapDB.clear();
        this.idMap.clear();
        this.refCache = Collections.emptyList();
    }

    @Override
    public synchronized List<DBEntry<T>> getEntries() {
        if (this.refCache == null) {
            ArrayList<DBEntry<T>> temp = new ArrayList<DBEntry<T>>();
            for (Map.Entry<Integer, T> entry : this.mapDB.entrySet()) {
                temp.add(new DBEntry<T>(entry.getKey(), entry.getValue()));
            }
            this.refCache = Collections.unmodifiableList(temp);
        }
        return this.refCache;
    }

    @Override
    public synchronized List<DBEntry<T>> bulkLookup(int ... keys) {
        if (keys.length <= 0) {
            return Collections.emptyList();
        }
        int[] sortedKeys = new int[keys.length];
        System.arraycopy(keys, 0, sortedKeys, 0, keys.length);
        Arrays.sort(sortedKeys);
        ArrayList<DBEntry<T>> subList = new ArrayList<DBEntry<T>>();
        int n = 0;
        for (DBEntry<T> entry : this.getEntries()) {
            while (n < sortedKeys.length && sortedKeys[n] < entry.getID()) {
                ++n;
            }
            if (n >= sortedKeys.length) break;
            if (sortedKeys[n] != entry.getID()) continue;
            subList.add(entry);
        }
        return subList;
    }
}

