/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.themes.presets;

import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.themes.IThemeRegistry;
import betterquesting.client.themes.ThemeRegistry;
import net.minecraft.util.ResourceLocation;

public enum PresetColor {
    TEXT_HEADER("text_header"),
    TEXT_MAIN("text_main"),
    TEXT_AUX_0("text_aux_0"),
    TEXT_AUX_1("text_aux_1"),
    TEXT_HIGHLIGHT("text_highlight"),
    TEXT_WATERMARK("text_watermark"),
    ITEM_HIGHLIGHT("item_highlight"),
    GUI_DIVIDER("gui_divider"),
    UPDATE_NOTICE("update_notice"),
    GRID_MAJOR("grid_major"),
    GRID_MINOR("grid_minor"),
    BTN_DISABLED("btn_disabled"),
    BTN_IDLE("btn_idle"),
    BTN_HOVER("btn_hover"),
    QUEST_LINE_LOCKED("quest_line_locked"),
    QUEST_LINE_UNLOCKED("quest_line_unlocked"),
    QUEST_LINE_PENDING("quest_line_pending"),
    QUEST_LINE_COMPLETE("quest_line_complete"),
    QUEST_ICON_LOCKED("quest_icon_locked"),
    QUEST_ICON_UNLOCKED("quest_icon_unlocked"),
    QUEST_ICON_PENDING("quest_icon_pending"),
    QUEST_ICON_COMPLETE("quest_icon_complete");

    private final ResourceLocation key;

    private PresetColor(String key) {
        this.key = new ResourceLocation("betterquesting", key);
    }

    public IGuiColor getColor() {
        return ThemeRegistry.INSTANCE.getColor(this.key);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public static void registerColors(IThemeRegistry reg) {
        reg.setDefaultColor(PresetColor.TEXT_HEADER.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.TEXT_MAIN.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.TEXT_AUX_0.key, new GuiColorStatic(255, 255, 255, 255));
        reg.setDefaultColor(PresetColor.TEXT_AUX_1.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.TEXT_HIGHLIGHT.key, new GuiColorStatic(0, 0, 255, 255));
        reg.setDefaultColor(PresetColor.TEXT_WATERMARK.key, new GuiColorStatic(128, 128, 128, 255));
        reg.setDefaultColor(PresetColor.ITEM_HIGHLIGHT.key, new GuiColorStatic(255, 255, 255, 128));
        reg.setDefaultColor(PresetColor.GUI_DIVIDER.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.UPDATE_NOTICE.key, new GuiColorPulse(PresetColor.quickMix(255, 255, 0, 255), PresetColor.quickMix(128, 128, 0, 255), 1.0, 0.0f));
        reg.setDefaultColor(PresetColor.GRID_MAJOR.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.GRID_MINOR.key, new GuiColorStatic(0, 0, 0, 255));
        reg.setDefaultColor(PresetColor.BTN_DISABLED.key, new GuiColorStatic(128, 128, 128, 255));
        reg.setDefaultColor(PresetColor.BTN_IDLE.key, new GuiColorStatic(255, 255, 255, 255));
        reg.setDefaultColor(PresetColor.BTN_HOVER.key, new GuiColorStatic(0xFFFFA0));
        reg.setDefaultColor(PresetColor.QUEST_LINE_LOCKED.key, new GuiColorStatic(192, 0, 0, 255));
        reg.setDefaultColor(PresetColor.QUEST_LINE_UNLOCKED.key, new GuiColorPulse(PresetColor.quickMix(255, 255, 0, 255), PresetColor.quickMix(128, 128, 0, 255), 1.0, 0.0f));
        reg.setDefaultColor(PresetColor.QUEST_LINE_PENDING.key, new GuiColorStatic(0, 255, 0, 255));
        reg.setDefaultColor(PresetColor.QUEST_LINE_COMPLETE.key, new GuiColorStatic(0, 255, 0, 255));
        reg.setDefaultColor(PresetColor.QUEST_ICON_LOCKED.key, new GuiColorStatic(128, 128, 128, 255));
        reg.setDefaultColor(PresetColor.QUEST_ICON_UNLOCKED.key, new GuiColorPulse(PresetColor.quickMix(192, 0, 0, 255), PresetColor.quickMix(96, 0, 0, 255), 1.0, 0.0f));
        reg.setDefaultColor(PresetColor.QUEST_ICON_PENDING.key, new GuiColorPulse(PresetColor.quickMix(0, 255, 255, 255), PresetColor.quickMix(0, 128, 128, 255), 1.0, 0.0f));
        reg.setDefaultColor(PresetColor.QUEST_ICON_COMPLETE.key, new GuiColorStatic(0, 255, 0, 255));
    }

    public static int quickMix(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }
}

