/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.blocks;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.QuestSettings;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSubmitStation
extends TileEntity
implements IFluidHandler,
ISidedInventory {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SIZE_INVENTORY = 2;
    private static final int[] SLOTS_FOR_FACE = new int[]{0, 1};
    private final ItemStack[] itemStack = new ItemStack[2];
    private boolean needsUpdate = false;
    public UUID owner = null;
    public int questID = -1;
    public int taskID = -1;
    private DBEntry<IQuest> qCached;

    public DBEntry<IQuest> getQuest() {
        IQuest tmp;
        if (this.questID < 0) {
            return null;
        }
        if (this.qCached == null && (tmp = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID)) != null) {
            this.qCached = new DBEntry<IQuest>(this.questID, tmp);
        }
        return this.qCached;
    }

    public ITask getRawTask() {
        DBEntry<IQuest> q = this.getQuest();
        if (q == null || this.taskID < 0) {
            return null;
        }
        return (ITask)q.getValue().getTasks().getValue(this.taskID);
    }

    public IItemTask getItemTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IItemTask ? (IItemTask)t : null);
    }

    public IFluidTask getFluidTask() {
        ITask t = this.getRawTask();
        return t == null ? null : (t instanceof IFluidTask ? (IFluidTask)t : null);
    }

    private boolean isValidSlot(int slot) {
        return 0 <= slot && slot < 2;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int idx) {
        if (!this.isValidSlot(idx)) {
            return null;
        }
        return this.itemStack[idx];
    }

    public ItemStack func_70298_a(int idx, int amount) {
        if (!this.isValidSlot(idx) || this.itemStack[idx] == null) {
            return null;
        }
        if (amount >= this.itemStack[idx].field_77994_a) {
            ItemStack itemstack = this.itemStack[idx];
            this.itemStack[idx] = null;
            return itemstack;
        }
        this.itemStack[idx].field_77994_a -= amount;
        ItemStack cpy = this.itemStack[idx].func_77946_l();
        cpy.field_77994_a = amount;
        return cpy;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int idx, ItemStack stack) {
        if (!this.isValidSlot(idx)) {
            return;
        }
        this.itemStack[idx] = stack;
    }

    @Nonnull
    public String func_145825_b() {
        return BetterQuesting.submitStation.func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        if (!this.isSetup()) {
            return 0;
        }
        if (this.getFluidTask() != null) {
            return 1;
        }
        if (this.getItemTask() != null) {
            return 64;
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return (this.owner == null || player.func_110124_au().equals(this.owner)) && player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 256.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int idx, ItemStack stack) {
        if (idx != 0) {
            return false;
        }
        IItemTask t = this.getItemTask();
        return t != null && this.itemStack[idx] == null && !t.isComplete(this.owner) && t.canAcceptItem(this.owner, this.getQuest(), stack);
    }

    public int fill(ForgeDirection from, FluidStack fluid, boolean doFill) {
        IFluidTask t = this.getFluidTask();
        if (!this.isSetup() || t == null) {
            return 0;
        }
        int amount = fluid.amount;
        int consumed = 0;
        if (doFill) {
            FluidStack remainder = t.submitFluid(this.owner, this.getQuest(), fluid);
            int n = consumed = remainder != null ? amount - remainder.amount : amount;
            if (t.isComplete(this.owner)) {
                this.needsUpdate = true;
                this.reset();
                MinecraftServer server = MinecraftServer.func_71276_C();
                if (server != null) {
                    server.func_71203_ab().func_148543_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0, this.field_145850_b.field_73011_w.field_76574_g, this.func_145844_m());
                }
            } else {
                this.needsUpdate = consumed > 0;
            }
        }
        return consumed;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        IFluidTask t = this.getFluidTask();
        return t != null && !t.isComplete(this.owner) && t.canAcceptFluid(this.owner, this.getQuest(), new FluidStack(fluid, 1));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K || !this.isSetup() || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            return;
        }
        long wtt = this.field_145850_b.func_82737_E();
        if (wtt % 10L == 0L && this.owner != null) {
            QuestCache qc;
            if (wtt % 20L == 0L) {
                this.qCached = null;
            }
            DBEntry<IQuest> q = this.getQuest();
            IItemTask t = this.getItemTask();
            MinecraftServer server = MinecraftServer.func_71276_C();
            EntityPlayerMP player = this.getPlayerByUUID(this.owner);
            QuestCache questCache = qc = player == null ? null : (QuestCache)player.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
            if (q != null && t != null && this.itemStack[0] != null && this.itemStack[1] == null) {
                ItemStack inStack = this.itemStack[0].func_77946_l();
                ItemStack beforeStack = this.itemStack[0].func_77946_l();
                if (t.canAcceptItem(this.owner, this.getQuest(), inStack)) {
                    this.itemStack[0] = t.submitItem(this.owner, this.getQuest(), inStack);
                    if (t.isComplete(this.owner)) {
                        this.reset();
                        this.needsUpdate = true;
                        if (server != null) {
                            server.func_71203_ab().func_148543_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0, this.field_145850_b.field_73011_w.field_76574_g, this.func_145844_m());
                        }
                    } else if (this.itemStack[0] == null || !this.itemStack[0].equals(beforeStack)) {
                        this.needsUpdate = true;
                    }
                } else {
                    this.itemStack[1] = inStack;
                    this.itemStack[0] = null;
                }
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                if (q != null && qc != null) {
                    qc.markQuestDirty(this.questID);
                }
            }
            if (t != null && t.isComplete(this.owner)) {
                this.reset();
                MinecraftServer.func_71276_C().func_71203_ab().func_148543_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 128.0, this.field_145850_b.field_73011_w.field_76574_g, this.func_145844_m());
            }
        }
    }

    private EntityPlayerMP getPlayerByUUID(UUID uuid) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
            if (!player.func_146103_bH().getId().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public void setupTask(UUID owner, IQuest quest, ITask task) {
        if (owner == null || quest == null || task == null) {
            this.reset();
            return;
        }
        this.questID = QuestDatabase.INSTANCE.getID(quest);
        this.qCached = new DBEntry<IQuest>(this.questID, quest);
        this.taskID = quest.getTasks().getID(task);
        if (this.questID < 0 || this.taskID < 0) {
            this.reset();
            return;
        }
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean isSetup() {
        return this.owner != null && this.questID >= 0 && this.taskID >= 0;
    }

    public void reset() {
        this.owner = null;
        this.questID = -1;
        this.taskID = -1;
        this.qCached = null;
        this.func_70296_d();
    }

    @Nonnull
    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.itemStack[0] = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("input"));
        this.itemStack[1] = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("output"));
        try {
            this.owner = UUID.fromString(tags.func_74779_i("owner"));
        }
        catch (Exception e) {
            this.reset();
            return;
        }
        this.questID = tags.func_74764_b("questID") ? tags.func_74762_e("questID") : -1;
        int n = this.taskID = tags.func_74764_b("task") ? tags.func_74762_e("task") : -1;
        if (!this.isSetup()) {
            this.reset();
        }
    }

    @Nonnull
    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        tags.func_74778_a("owner", this.owner != null ? this.owner.toString() : "");
        tags.func_74768_a("questID", this.questID);
        tags.func_74768_a("task", this.taskID);
        tags.func_74782_a("input", (NBTBase)(this.itemStack[0] != null ? this.itemStack[0].func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
        tags.func_74782_a("output", (NBTBase)(this.itemStack[1] != null ? this.itemStack[1].func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
    }

    @Nonnull
    public int[] func_94128_d(int side) {
        return SLOTS_FOR_FACE;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }
}

