/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.colors;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import org.lwjgl.opengl.GL11;

public class GuiColorTransition
implements IGuiColor {
    private final IGuiColor cNorm;
    private final IGuiColor cLow;
    private boolean useLerp = true;
    private float threshold = 1.0f;
    private IValueIO<Float> driver = null;

    public GuiColorTransition(IGuiColor cNorm, IGuiColor cLow) {
        this.cNorm = cNorm;
        this.cLow = cLow;
    }

    public GuiColorTransition setupBlending(boolean enable, float threshold) {
        this.useLerp = enable;
        this.threshold = threshold;
        return this;
    }

    public GuiColorTransition setBlendDriver(IValueIO<Float> driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public int getRGB() {
        if (this.driver != null && this.driver.readValue().floatValue() < this.threshold) {
            if (!this.useLerp) {
                return this.cLow.getRGB();
            }
            return RenderUtils.lerpRGB(this.cLow.getRGB(), this.cNorm.getRGB(), this.driver.readValue().floatValue() / this.threshold);
        }
        return this.cNorm.getRGB();
    }

    @Override
    public float getRed() {
        return (float)(this.getRGB() >> 16 & 0xFF) / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)(this.getRGB() >> 8 & 0xFF) / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)(this.getRGB() & 0xFF) / 255.0f;
    }

    @Override
    public float getAlpha() {
        return (float)(this.getRGB() >> 24 & 0xFF) / 255.0f;
    }

    @Override
    public void applyGlColor() {
        int argb = this.getRGB();
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }
}

