/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.ProgressDisplayer;
import alexiil.mods.load.json.Area;
import alexiil.mods.load.json.EPosition;
import alexiil.mods.load.json.EType;
import alexiil.mods.load.json.ImageRender;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class MinecraftDisplayer
implements ProgressDisplayer.IDisplayer {
    private static String sound;
    private static String defaultSound;
    private static String fontTexture;
    private static String defaultFontTexture;
    private final boolean preview;
    private ImageRender[] images;
    private TextureManager textureManager = null;
    private Map<String, FontRenderer> fontRenderers = new HashMap<String, FontRenderer>();
    private FontRenderer fontRenderer = null;
    private ScaledResolution resolution = null;
    private Minecraft mc = null;
    private boolean callAgain = false;
    private IResourcePack myPack;
    private float clearRed = 1.0f;
    private float clearGreen = 1.0f;
    private float clearBlue = 1.0f;
    private boolean hasSaidNice = false;
    public static float lastPercent;
    private List<String> alreadyUsedBGs = new ArrayList<String>();
    private List<String> alreadyUsedTooltips = new ArrayList<String>();
    private String GTprogress = "betterloadingscreen:textures/GTMaterialsprogressBars.png";
    private String progress = "betterloadingscreen:textures/mainProgressBar.png";
    private String GTprogressAnimated = "betterloadingscreen:textures/GTMaterialsprogressBars.png";
    private String progressAnimated = "betterloadingscreen:textures/mainProgressBar.png";
    private String title = "betterloadingscreen:textures/transparent.png";
    private String background = "betterloadingscreen:textures/backgrounds/background1.png";
    private int[] titlePos = new int[]{0, 0, 256, 256, 0, 50, 187, 145};
    private int[] GTprogressPos = new int[]{0, 0, 194, 24, 0, -83, 188, 12};
    private int[] GTprogressPosAnimated = new int[]{0, 24, 194, 24, 0, -83, 188, 12};
    private int[] progressPos = new int[]{0, 0, 194, 24, 0, -50, 194, 16};
    private int[] progressPosAnimated = new int[]{0, 24, 194, 24, 0, -50, 194, 16};
    private int[] progressTextPos = new int[]{0, -30};
    private int[] progressPercentagePos = new int[]{0, -40};
    private int[] GTprogressTextPos = new int[]{0, -65};
    private int[] GTprogressPercentagePos = new int[]{0, -75};
    private int[] tipsTextPos = new int[]{0, 5};
    private String baseTipsTextPos = "BOTTOM_CENTER";
    private boolean tipsEnabled = true;
    private String[] randomTips;
    private String tipsColor = "ffffff";
    private boolean tipsTextShadow = true;
    private int tipsChangeFrequency = 18;
    private String tip = "";
    private static boolean useCustomTips;
    private static String customTipFilename;
    private boolean textShadow = true;
    private String textColor = "ffffff";
    private boolean randomBackgrounds = true;
    public static String[] randomBackgroundArray;
    private boolean blendingEnabled = true;
    private int threadSleepTime = 20;
    private int changeFrequency = 40;
    private float alphaDecreaseStep = 0.01f;
    private boolean shouldGLClear = false;
    private boolean salt = false;
    private String loadingBarsColor = "fdf900";
    private float[] lbRGB = new float[]{1.0f, 1.0f, 0.0f};
    private float loadingBarsAlpha = 0.5f;
    private boolean useImgur = true;
    public static String imgurGalleryLink;
    private boolean saltBGhasBeenRendered = false;
    public static boolean isNice;
    public static boolean isRegisteringGTmaterials;
    public static boolean isReplacingVanillaMaterials;
    public static boolean isRegisteringBartWorks;
    public static boolean blending;
    public static boolean blendingJustSet;
    public static float blendAlpha;
    private static String newBlendImage;
    private static int nonStaticElementsToGo;
    private static Logger log;
    private ScheduledExecutorService backgroundExec = null;
    private boolean scheduledTipExecSet = false;
    private ScheduledExecutorService tipExec = null;
    private boolean scheduledBackgroundExecSet = false;
    CountDownLatch countDownLatch = new CountDownLatch(1);
    private boolean experimental = false;

    public static float getLastPercent() {
        return lastPercent;
    }

    public static void playFinishedSound() {
        ResourceLocation location;
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        SoundEventAccessorComposite snd = soundHandler.func_147680_a(location = new ResourceLocation(sound));
        if (snd == null) {
            log.warn("The sound given (" + sound + ") did not give a valid sound!");
            location = new ResourceLocation(defaultSound);
            snd = soundHandler.func_147680_a(location);
        }
        if (snd == null) {
            log.warn("Default sound did not give a valid sound!");
            return;
        }
        PositionedSoundRecord sound = PositionedSoundRecord.func_147673_a((ResourceLocation)location);
        soundHandler.func_147682_a((ISound)sound);
    }

    public MinecraftDisplayer() {
        this(false);
    }

    public MinecraftDisplayer(boolean preview) {
        this.preview = preview;
    }

    private List<IResourcePack> getOnlyList() {
        Field[] flds;
        for (Field f : flds = this.mc.getClass().getDeclaredFields()) {
            if (!f.getType().equals(List.class) || Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                return (List)f.get(this.mc);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void openPreview(ImageRender[] renders) {
        this.mc = Minecraft.func_71410_x();
        this.images = renders;
    }

    public static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public int[] stringToIntArray(String str) {
        str = str.replaceAll("\\s+", "");
        String intBuffer = "";
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            if (MinecraftDisplayer.isNumeric(String.valueOf(str.charAt(i))) || String.valueOf(str.charAt(i)).equals("-")) {
                intBuffer = intBuffer + String.valueOf(str.charAt(i));
            }
            if (!String.valueOf(str.charAt(i)).equals(",") && !String.valueOf(str.charAt(i)).equals("]")) continue;
            numbers.add(Integer.parseInt(intBuffer));
            intBuffer = "";
        }
        int[] res = new int[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            res[i] = (Integer)numbers.get(i);
        }
        return res;
    }

    public String intArrayToString(int[] array) {
        String res = "[";
        for (int i = 0; i < array.length; ++i) {
            res = res + String.valueOf(array[i]);
            res = i != array.length - 1 ? res + ", " : res + "]";
        }
        return res;
    }

    public String parseBackgroundArraytoCFGList(String[] backgrounds) {
        String res = "{";
        for (int i = 0; i < backgrounds.length; ++i) {
            res = res + "" + backgrounds[i];
            if (i >= backgrounds.length - 1) continue;
            res = res + ", ";
        }
        res = res + "}";
        return res;
    }

    public String[] parseBackgroundCFGListToArray(String backgrounds) {
        String[] res = backgrounds.split(",");
        for (int i = 0; i < res.length; ++i) {
            if (String.valueOf(res[i].charAt(0)).equals(" ") || String.valueOf(res[i].charAt(0)).equals("{")) {
                res[i] = res[i].substring(1);
            }
            if (!String.valueOf(res[i].charAt(res[i].length() - 1)).equals(" ") && !String.valueOf(res[i].charAt(res[i].length() - 1)).equals("}")) continue;
            res[i] = res[i].substring(0, res[i].length() - 1);
        }
        return res;
    }

    public String randomBackground(String currentBG) {
        if (randomBackgroundArray.length == 1) {
            return randomBackgroundArray[0];
        }
        Random rand = new Random();
        String res = randomBackgroundArray[rand.nextInt(randomBackgroundArray.length)];
        if (randomBackgroundArray.length == this.alreadyUsedBGs.size()) {
            this.alreadyUsedBGs.clear();
        }
        while (res.equals(currentBG) || this.alreadyUsedBGs.contains(res)) {
            res = randomBackgroundArray[rand.nextInt(randomBackgroundArray.length)];
        }
        this.alreadyUsedBGs.add(res);
        return res;
    }

    public String randomTooltip(String currentTooltip) {
        if (this.randomTips.length == 1) {
            return this.randomTips[0];
        }
        Random rand = new Random();
        String res = this.randomTips[rand.nextInt(this.randomTips.length)];
        if (this.randomTips.length == this.alreadyUsedTooltips.size()) {
            this.alreadyUsedTooltips.clear();
        }
        while (res.equals(currentTooltip) || this.alreadyUsedTooltips.contains(res)) {
            res = this.randomTips[rand.nextInt(this.randomTips.length)];
        }
        this.alreadyUsedTooltips.add(res);
        return res;
    }

    public static String[] readTipsFile(String file) throws IOException {
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuffer inputBuffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (line.charAt(0) != '#') {
                    lines.add(line);
                }
                inputBuffer.append(line);
                inputBuffer.append('\n');
            }
            if (lines.size() == 0) {
                lines.add("No tips!");
            }
            reader.close();
            FileOutputStream fileOut = new FileOutputStream(file);
            PrintStream stream = new PrintStream((OutputStream)fileOut, true, "UTF-8");
            fileOut.write(inputBuffer.toString().getBytes("UTF-8"));
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            log.warn("Error while opening tips file");
            return new String[]{"Failed to load tips! If you didn't do anything, yell at jackowski626#0522"};
        }
        return lines.toArray(new String[0]);
    }

    public static void placeTipsFile() throws IOException {
        String locale = "en_US";
        if (!useCustomTips) {
            log.info("Not using custom tooltips");
            locale = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            if (locale.length() > 5) {
                locale = locale.substring(0, 5);
            }
        } else {
            locale = customTipFilename;
            log.info("Using custom tooltips, name: " + locale);
        }
        InputStream fileContents = null;
        try {
            fileContents = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("betterloadingscreen:tips/" + locale + ".txt")).func_110527_b();
        }
        catch (Exception e) {
            fileContents = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("betterloadingscreen:tips/en_US.txt")).func_110527_b();
            locale = "en_US";
            log.info("Language not found");
        }
        byte[] buffer = new byte[fileContents.available()];
        fileContents.read(buffer);
        File dir = new File("./config/Betterloadingscreen/tips");
        if (!dir.exists()) {
            log.info("tips dir does not exist");
            dir.mkdirs();
        } else {
            log.info("tips dir exists");
        }
        log.info("Current locale: " + locale);
        File dest = new File("./config/Betterloadingscreen/tips/" + locale + ".txt");
        log.info("dest set");
        FileOutputStream outStream = new FileOutputStream(dest);
        ((OutputStream)outStream).write(buffer);
    }

    public void handleTips() {
        File tipsCheck;
        String locale = "en_US";
        if (!useCustomTips) {
            log.info("Not using custom tooltips");
            locale = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            log.info("Locale is: " + locale);
            if (locale.length() > 5) {
                log.info("locale before trimming: " + locale);
                locale = locale.substring(0, 5);
            }
        } else {
            locale = customTipFilename;
            log.info("Using custom tooltips, name: " + locale);
        }
        if ((tipsCheck = new File("./config/Betterloadingscreen/tips/" + locale + ".txt")).exists()) {
            log.info("Tips file exists");
            try {
                this.randomTips = MinecraftDisplayer.readTipsFile("./config/Betterloadingscreen/tips/" + locale + ".txt");
                Random rand = new Random();
                this.tip = this.randomTips[rand.nextInt(this.randomTips.length)];
                if (!this.scheduledTipExecSet) {
                    this.scheduledTipExecSet = true;
                    this.tipExec = Executors.newSingleThreadScheduledExecutor();
                    this.tipExec.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            MinecraftDisplayer.this.tip = MinecraftDisplayer.this.randomTooltip(MinecraftDisplayer.this.tip);
                        }
                    }, this.tipsChangeFrequency, this.tipsChangeFrequency, TimeUnit.SECONDS);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                tipsCheck = new File("./config/Betterloadingscreen/tips/" + locale + ".txt");
                if (tipsCheck.exists()) {
                    this.randomTips = MinecraftDisplayer.readTipsFile("./config/Betterloadingscreen/" + locale + ".txt");
                } else {
                    tipsCheck = new File("./config/Betterloadingscreen/tips/en_US.txt");
                    if (!tipsCheck.exists()) {
                        MinecraftDisplayer.placeTipsFile();
                    }
                    this.randomTips = MinecraftDisplayer.readTipsFile("./config/Betterloadingscreen/tips/en_US.txt");
                }
                Random rand = new Random();
                this.tip = this.randomTips[rand.nextInt(this.randomTips.length)];
                if (!this.scheduledTipExecSet) {
                    this.scheduledTipExecSet = true;
                    this.tipExec = Executors.newSingleThreadScheduledExecutor();
                    this.tipExec.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            MinecraftDisplayer.this.tip = MinecraftDisplayer.this.randomTooltip(MinecraftDisplayer.this.tip);
                        }
                    }, this.tipsChangeFrequency, this.tipsChangeFrequency, TimeUnit.SECONDS);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void open(Configuration cfg) {
        this.mc = Minecraft.func_71410_x();
        String n = System.lineSeparator();
        String comment4 = "What sound to play when loading is complete. Default is the level up sound (" + defaultSound + ")";
        sound = cfg.getString("sound", "general", defaultSound, comment4);
        comment4 = "What font texture to use? Special Cases:" + n + " - If you use the Russian mod \"Client Fixer\" then change this to \"textures/font/ascii_fat.png\"" + n + "Note: if a resourcepack adds a font, it will be used by CLS.";
        fontTexture = cfg.getString("font", "general", defaultFontTexture, comment4);
        String comment5 = "Path to background resource." + n + "You can use a resourcepack or resource loader for custom resources.";
        this.background = cfg.getString("background", "layout", this.background, comment5);
        String comment6 = "Path to logo/title resource";
        this.title = cfg.getString("title", "layout", this.title, comment6);
        String comment7 = "Logo coordinates in image and position." + n + "the first four values indicate where the logo is located on the image (you could use a spritesheet), the four next ones tell where the image will be located on screen" + n + "like this: [xLocation, yLocation, xWidth, yWidth, xLocation, yLocation, xWidth, yWidth]" + n + "The same is used for other images, except the background, which is fullscreen. Please ALWAYS provide an image, a transparent one if you want even." + n + "CLS provides 'transparent.png'" + n + "If you really insist ping me and I'll look if I can add an image or so. jackowski626#0522";
        this.titlePos = this.stringToIntArray(cfg.getString("titlePos", "layout", this.intArrayToString(this.titlePos), comment7));
        String comment8 = "Path to main loading bar resource";
        this.progress = cfg.getString("mainProgressBar", "layout", this.progress, comment8);
        String comment9 = "Main loading bar position";
        this.progressPos = this.stringToIntArray(cfg.getString("mainProgressBarPos", "layout", this.intArrayToString(this.progressPos), comment9));
        String comment10 = "Path to animated main loading bar resource";
        this.progressAnimated = cfg.getString("mainProgressBarAnimated", "layout", this.progressAnimated, comment10);
        String comment11 = "Main animated loading bar position";
        this.progressPosAnimated = this.stringToIntArray(cfg.getString("mainProgressBarPosAnimated", "layout", this.intArrayToString(this.progressPosAnimated), comment11));
        String comment12 = "Main loading bar text position. The four values are for positon.";
        this.progressTextPos = this.stringToIntArray(cfg.getString("mainProgressBarTextPos", "layout", this.intArrayToString(this.progressTextPos), comment12));
        String comment13 = "Main loading bar percentage position";
        this.progressPercentagePos = this.stringToIntArray(cfg.getString("mainProgressBarPercentagePos", "layout", this.intArrayToString(this.progressPercentagePos), comment13));
        String comment14 = "Path to materials loading bar";
        this.GTprogress = cfg.getString("materialProgressBar", "layout", this.GTprogress, comment14);
        String comment15 = "Material loading bar position";
        this.GTprogressPos = this.stringToIntArray(cfg.getString("GTProgressBarPos", "layout", this.intArrayToString(this.GTprogressPos), comment15));
        String comment16 = "Path to animated materials loading bar";
        this.GTprogressAnimated = cfg.getString("materialProgressBarAnimated", "layout", this.GTprogress, comment16);
        String comment17 = "Material animated loading bar position";
        this.GTprogressPosAnimated = this.stringToIntArray(cfg.getString("GTProgressBarPosAnimated", "layout", this.intArrayToString(this.GTprogressPosAnimated), comment17));
        String comment18 = "Main loading bar text position. The two values are for positon (x and y).";
        this.GTprogressTextPos = this.stringToIntArray(cfg.getString("materialProgressBarTextPos", "layout", this.intArrayToString(this.GTprogressTextPos), comment18));
        String comment19 = "Main loading bar percentage position";
        this.GTprogressPercentagePos = this.stringToIntArray(cfg.getString("materialProgressBarPercentagePos", "layout", this.intArrayToString(this.GTprogressPercentagePos), comment19));
        String comment39 = "color of main and GT material dynamic loading bar (Use ffffff (white)) if you don't want to color it";
        this.loadingBarsColor = cfg.getString("loadingBarsColor", "layout", this.loadingBarsColor, comment39);
        String comment40 = "Transparency of main and GT material dynamic loading bar";
        this.loadingBarsAlpha = cfg.getFloat("loadingBarsAlpha", "layout", this.loadingBarsAlpha, 0.0f, 1.0f, comment40);
        String comment20 = "Whether the text should be rendered with a shadow. Recommended, unless the background is really dark";
        this.textShadow = cfg.getBoolean("textShadow", "layout", this.textShadow, comment20);
        String comment21 = "Color of text in hexadecimal format";
        this.textColor = cfg.getString("textColor", "layout", this.textColor, comment21);
        String comment22 = "Whether display a random background from the random backgrounds list";
        this.randomBackgrounds = cfg.getBoolean("randomBackgrounds", "layout", this.randomBackgrounds, comment22);
        String comment23 = "List of paths to backgrounds that will be used if randomBackgrounds is true." + n + "The paths must be separated by commas." + n;
        randomBackgroundArray = this.parseBackgroundCFGListToArray(cfg.getString("backgroundList", "layout", this.parseBackgroundArraytoCFGList(randomBackgroundArray), comment23));
        String comment24 = "Whether backgrounds should change randomly during loading. They are taken from the random background list";
        this.blendingEnabled = cfg.getBoolean("backgroundChanging", "changing background", this.blendingEnabled, comment24);
        String comment25 = "Time in milliseconds between each image change (smooth blend)." + n + "The animation runs on the main thread (because OpenGL bruh momento), so setting this higher than" + n + "default is not recommended (basically: if image transition running, your mods not loading)";
        this.threadSleepTime = cfg.getInt("threadSleepTime", "changing background", this.threadSleepTime, 0, 9000, comment25);
        String comment26 = "Wach how many seconds the background should change";
        this.changeFrequency = cfg.getInt("changeFrequency", "changing background", this.changeFrequency, 1, 9000, comment26);
        String comment27 = "Float from 0 to 1. The amount of alpha that is removed from the original image and added to the image that comes after." + n + "Also defined smoothnes of animation. Don't set this too low this time or you'll add time to your pack loading. Probably " + String.valueOf(this.alphaDecreaseStep) + " still is too low.";
        this.alphaDecreaseStep = cfg.getFloat("alphaDecreaseStep", "changing background", this.alphaDecreaseStep, 0.0f, 1.0f, comment27);
        String comment28 = "No, don't touch that!";
        this.shouldGLClear = cfg.getBoolean("shouldGLClear", "changing background", this.shouldGLClear, comment28);
        String comment29 = "If you want to save a maximum of time on your loading time but don't want to face a black screen, try this.";
        this.salt = cfg.getBoolean("salt", "skepticism", this.salt, comment29);
        String comment30 = "Set to true if you want to load images from an imgur gallery and use them as backgrounds. WIP, not working yet";
        this.useImgur = cfg.getBoolean("useImgur", "imgur", this.useImgur, comment30);
        String comment31 = "Link to the imgur gallery";
        imgurGalleryLink = cfg.getString("imgurGalleryLink", "imgur", imgurGalleryLink, comment31);
        String comment32 = "Set to true if you want to display random tips. Tips are stored in a separate file";
        this.tipsEnabled = cfg.getBoolean("tipsEnabled", "tips", this.tipsEnabled, comment32);
        String comment34 = "Base text position. Can be TOP_CENTER, TOP_RIGHT, CENTER_LEFT, CENTER, CENTER_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER or BOTTOM_RIGHT." + n + "Note: Other elements use CENTER, if you really need, ask to implement this base poition option for any other element.";
        this.baseTipsTextPos = cfg.getString("baseTipsTextPos", "tips", this.baseTipsTextPos, comment34);
        String comment35 = "Tips text position";
        this.tipsTextPos = this.stringToIntArray(cfg.getString("tipsTextPos", "tips", this.intArrayToString(this.tipsTextPos), comment35));
        String comment36 = "Whether the tips text should be rendered with a shadow.";
        this.tipsTextShadow = cfg.getBoolean("tipsTextShadow", "tips", this.tipsTextShadow, comment36);
        String comment37 = "Color of tips text in hexadecimal format";
        this.tipsColor = cfg.getString("tipsTextColor", "tips", this.tipsColor, comment37);
        String comment38 = "Time in seconds between tip change";
        this.tipsChangeFrequency = cfg.getInt("tipsChangeFrequency", "tips", this.tipsChangeFrequency, 1, 9000, comment38);
        String comment41 = "Set to true if you want a custom tips file/different locale than your Minecraft one.";
        useCustomTips = cfg.getBoolean("useCustomTips", "tips", useCustomTips, comment41);
        String comment42 = "Custom tips file name, place it in config/Betterloadingscreen/tips. " + n + "Don't include the \".txt\". Example: \"myTipFile\"";
        customTipFilename = cfg.getString("customTipFilename", "tips", customTipFilename, comment42);
        try {
            this.lbRGB[0] = (float)(Color.decode("#" + this.loadingBarsColor).getRed() & 0xFF) / 255.0f;
            this.lbRGB[1] = (float)(Color.decode("#" + this.loadingBarsColor).getGreen() & 0xFF) / 255.0f;
            this.lbRGB[2] = (float)(Color.decode("#" + this.loadingBarsColor).getBlue() & 0xFF) / 255.0f;
        }
        catch (Exception e) {
            this.lbRGB[0] = 1.0f;
            this.lbRGB[1] = 0.5176471f;
            this.lbRGB[2] = 0.0f;
            log.warn("Invalid loading bars color");
        }
        if (this.salt) {
            this.blendingEnabled = false;
        }
        if (!this.preview) {
            this.myPack = !ProgressDisplayer.coreModLocation.isDirectory() ? new FMLFileResourcePack(ProgressDisplayer.modContainer) : new FMLFolderResourcePack(ProgressDisplayer.modContainer);
            this.getOnlyList().add(this.myPack);
            this.mc.func_110436_a();
        }
        this.handleTips();
        if (this.randomBackgrounds && !this.salt) {
            Random rand = new Random();
            this.background = randomBackgroundArray[rand.nextInt(randomBackgroundArray.length)];
            if (!this.scheduledBackgroundExecSet) {
                this.scheduledBackgroundExecSet = true;
                this.backgroundExec = Executors.newSingleThreadScheduledExecutor();
                this.backgroundExec.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (!blending) {
                            blending = true;
                            blendingJustSet = true;
                            blendAlpha = 1.0f;
                        }
                    }
                }, this.changeFrequency, this.changeFrequency, TimeUnit.SECONDS);
            }
        }
        File configDir = new File("./config");
    }

    @Override
    public void displayProgress(String text, float percent) {
        if (!this.salt) {
            if (isRegisteringGTmaterials || isReplacingVanillaMaterials || isRegisteringBartWorks) {
                if (!this.tipsEnabled) {
                    this.images = new ImageRender[11];
                    nonStaticElementsToGo = 10;
                } else {
                    this.images = new ImageRender[12];
                    nonStaticElementsToGo = 11;
                }
                this.images[0] = !this.background.equals("") ? new ImageRender(this.background, EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 0, 0)) : new ImageRender("betterloadingscreen:textures/transparent.png", EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 10, 10));
                this.images[1] = !this.title.equals("") ? new ImageRender(this.title, EPosition.CENTER, EType.STATIC, new Area(this.titlePos[0], this.titlePos[1], this.titlePos[2], this.titlePos[3]), new Area(this.titlePos[4], this.titlePos[5], this.titlePos[6], this.titlePos[7])) : new ImageRender("betterloadingscreen:textures/transparent.png", EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 10, 10));
                this.images[2] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_STATUS, null, new Area(this.GTprogressTextPos[0], this.GTprogressTextPos[1], 0, 0), "ffffff", null, "");
                this.images[3] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_PERCENTAGE, null, new Area(this.GTprogressPercentagePos[0], this.GTprogressPercentagePos[1], 0, 0), "ffffff", null, "");
                this.images[4] = new ImageRender(this.progress, EPosition.CENTER, EType.STATIC, new Area(this.progressPos[0], this.progressPos[1], this.progressPos[2], this.progressPos[3]), new Area(this.progressPos[4], this.progressPos[5], this.progressPos[6], this.progressPos[7]));
                this.images[5] = new ImageRender(this.progress, EPosition.CENTER, EType.DYNAMIC_PERCENTAGE, new Area(this.progressPosAnimated[0], this.progressPosAnimated[1], this.progressPosAnimated[2], this.progressPosAnimated[3]), new Area(this.progressPosAnimated[4], this.progressPosAnimated[5], this.progressPosAnimated[6], this.progressPosAnimated[7]));
                this.images[6] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_STATUS, null, new Area(this.progressTextPos[0], this.progressTextPos[1], 0, 0), "ffffff", null, "");
                this.images[7] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_PERCENTAGE, null, new Area(this.progressPercentagePos[0], this.progressPercentagePos[1], 0, 0), "ffffff", null, "");
                this.images[8] = new ImageRender(this.GTprogress, EPosition.CENTER, EType.STATIC, new Area(this.GTprogressPos[0], this.GTprogressPos[1], this.GTprogressPos[2], this.GTprogressPos[3]), new Area(this.GTprogressPos[4], this.GTprogressPos[5], this.GTprogressPos[6], this.GTprogressPos[7]));
                this.images[9] = new ImageRender(this.GTprogress, EPosition.CENTER, EType.DYNAMIC_PERCENTAGE, new Area(this.GTprogressPosAnimated[0], this.GTprogressPosAnimated[1], this.GTprogressPosAnimated[2], this.GTprogressPosAnimated[3]), new Area(this.GTprogressPosAnimated[4], this.GTprogressPosAnimated[5], this.GTprogressPosAnimated[6], this.GTprogressPosAnimated[7]));
                if (!this.tipsEnabled) {
                    this.images[10] = new ImageRender(null, null, EType.CLEAR_COLOUR, null, null, "ffffff", null, "");
                } else {
                    this.images[10] = new ImageRender(fontTexture, EPosition.valueOf(this.baseTipsTextPos), EType.TIPS_TEXT, null, new Area(this.tipsTextPos[0], this.tipsTextPos[1], 0, 0), "000000", this.tip, "");
                    this.images[11] = new ImageRender(null, null, EType.CLEAR_COLOUR, null, null, "ffffff", null, "");
                }
            } else {
                if (!this.tipsEnabled) {
                    this.images = new ImageRender[7];
                    nonStaticElementsToGo = 6;
                } else {
                    this.images = new ImageRender[8];
                    nonStaticElementsToGo = 7;
                }
                this.images[0] = !this.background.equals("") ? new ImageRender(this.background, EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 0, 0)) : new ImageRender("betterloadingscreen:textures/transparent.png", EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 10, 10));
                this.images[1] = !this.title.equals("") ? new ImageRender(this.title, EPosition.CENTER, EType.STATIC, new Area(this.titlePos[0], this.titlePos[1], this.titlePos[2], this.titlePos[3]), new Area(this.titlePos[4], this.titlePos[5], this.titlePos[6], this.titlePos[7])) : new ImageRender("betterloadingscreen:textures/transparent.png", EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 10, 10));
                this.images[2] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_STATUS, null, new Area(this.progressTextPos[0], this.progressTextPos[1], 0, 0), "ffffff", null, "");
                this.images[3] = new ImageRender(fontTexture, EPosition.CENTER, EType.DYNAMIC_TEXT_PERCENTAGE, null, new Area(this.progressPercentagePos[0], this.progressPercentagePos[1], 0, 0), "ffffff", null, "");
                this.images[4] = new ImageRender(this.progress, EPosition.CENTER, EType.STATIC, new Area(this.progressPos[0], this.progressPos[1], this.progressPos[2], this.progressPos[3]), new Area(this.progressPos[4], this.progressPos[5], this.progressPos[6], this.progressPos[7]));
                this.images[5] = new ImageRender(this.progress, EPosition.CENTER, EType.DYNAMIC_PERCENTAGE, new Area(this.progressPosAnimated[0], this.progressPosAnimated[1], this.progressPosAnimated[2], this.progressPosAnimated[3]), new Area(this.progressPosAnimated[4], this.progressPosAnimated[5], this.progressPosAnimated[6], this.progressPosAnimated[7]));
                if (!this.tipsEnabled) {
                    this.images[6] = new ImageRender(null, null, EType.CLEAR_COLOUR, null, null, "ffffff", null, "");
                } else {
                    this.images[6] = new ImageRender(fontTexture, EPosition.valueOf(this.baseTipsTextPos), EType.TIPS_TEXT, null, new Area(this.tipsTextPos[0], this.tipsTextPos[1], 0, 0), this.tipsColor, this.tip, "");
                    this.images[7] = new ImageRender(null, null, EType.CLEAR_COLOUR, null, null, "ffffff", null, "");
                }
            }
        } else {
            this.shouldGLClear = false;
            this.textShadow = false;
            this.textColor = "000000";
            if (!this.saltBGhasBeenRendered) {
                this.images = new ImageRender[2];
                this.images[0] = new ImageRender("betterloadingscreen:textures/salt.png", EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 0, 0));
                this.images[1] = new ImageRender(fontTexture, EPosition.BOTTOM_LEFT, EType.DYNAMIC_TEXT_STATUS, null, new Area(10, 10, 0, 0), "000000", null, "");
            } else {
                this.images = new ImageRender[0];
            }
        }
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.preDisplayScreen();
        int imageCounter = 0;
        if (!(isRegisteringGTmaterials || isReplacingVanillaMaterials || isRegisteringBartWorks)) {
            lastPercent = percent;
        }
        for (ImageRender image : this.images) {
            if (this.salt) {
                this.drawImageRender(image, "Minecraft is loading, please wait...", percent);
            } else if (image != null && (!isRegisteringGTmaterials && !isReplacingVanillaMaterials && !isRegisteringBartWorks || imageCounter <= 4 || !isRegisteringGTmaterials && !isReplacingVanillaMaterials && !isRegisteringBartWorks || imageCounter >= 9)) {
                this.drawImageRender(image, text, percent);
            } else if (image != null && isRegisteringGTmaterials && !isNice) {
                this.drawImageRender(image, " Post Initialization: Registering Gregtech materials", lastPercent);
            } else if (image != null && isRegisteringGTmaterials && isNice) {
                this.drawImageRender(image, " Post Initialization: Registering nice Gregtech materials", lastPercent);
                if (!this.hasSaidNice) {
                    this.hasSaidNice = true;
                    log = LogManager.getLogger((String)"betterloadingscreen");
                    log.info("Yeah, that's nice, funni number");
                }
            } else if (isReplacingVanillaMaterials) {
                this.drawImageRender(image, " Post Initialization: Gregtech replacing Vanilla materials in recipes", lastPercent);
            } else if (isRegisteringBartWorks) {
                this.drawImageRender(image, " Post Initialization: Registering BartWorks materials", lastPercent);
            }
            ++imageCounter;
        }
        this.postDisplayScreen();
        if (this.callAgain) {
            this.callAgain = false;
            this.displayProgress(text, percent);
        }
    }

    private FontRenderer fontRenderer(String fontTexture) {
        if (this.fontRenderers.containsKey(fontTexture)) {
            return this.fontRenderers.get(fontTexture);
        }
        FontRenderer font = new FontRenderer(this.mc.field_71474_y, new ResourceLocation(fontTexture), this.textureManager, false);
        font.func_110549_a(this.mc.func_110442_L());
        if (!this.preview) {
            this.mc.func_110436_a();
            font.func_110549_a(this.mc.func_110442_L());
        }
        this.fontRenderers.put(fontTexture, font);
        return font;
    }

    public void drawImageRender(ImageRender render, String text, double percent) {
        int startX = render.transformX(this.resolution.func_78326_a());
        int startY = render.transformY(this.resolution.func_78328_b());
        int PWidth = 0;
        int PHeight = 0;
        int intColor = Integer.parseInt(this.textColor, 16);
        if (render.position != null) {
            PWidth = render.position.width == 0 ? this.resolution.func_78326_a() : render.position.width;
            PHeight = render.position.height == 0 ? this.resolution.func_78328_b() : render.position.height;
        }
        GL11.glColor4f((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue(), (float)1.0f);
        switch (render.type) {
            case DYNAMIC_PERCENTAGE: {
                ResourceLocation res = new ResourceLocation(render.resourceLocation);
                this.textureManager.func_110577_a(res);
                double visibleWidth = (double)PWidth * percent;
                double textureWidth = (double)render.texture.width * percent;
                GL11.glColor4f((float)this.lbRGB[0], (float)this.lbRGB[1], (float)this.lbRGB[2], (float)this.loadingBarsAlpha);
                this.drawRect(startX, startY, visibleWidth, PHeight, render.texture.x, render.texture.y, textureWidth, render.texture.height);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case DYNAMIC_TEXT_PERCENTAGE: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                String percentage = (int)(percent * 100.0) + "%";
                int width = font.func_78256_a(percentage);
                startX = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                startY = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                if (this.textShadow) {
                    font.func_78261_a(percentage, startX, startY, intColor);
                    break;
                }
                this.drawString(font, percentage, startX, startY, intColor);
                break;
            }
            case DYNAMIC_TEXT_STATUS: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                int width = font.func_78256_a(text);
                startX = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                startY = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                if (this.experimental) {
                    int currentX = startX;
                    for (int i = 0; i < text.length(); ++i) {
                        double scale = 2.0;
                        log.info("currentX before scale: " + currentX);
                        GL11.glScaled((double)scale, (double)scale, (double)scale);
                        log.info("currentX after scale: " + currentX);
                        this.drawString(font, String.valueOf(text.charAt(i)), (int)((double)currentX / scale), (int)((double)startY / scale), 0);
                        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                        currentX += font.func_78263_a(text.charAt(i));
                    }
                    break;
                }
                if (this.textShadow) {
                    font.func_78261_a(text, startX, startY, intColor);
                    break;
                }
                this.drawString(font, text, startX, startY, intColor);
                break;
            }
            case STATIC_TEXT: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                int width = font.func_78256_a(render.text);
                int startX1 = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                int startY1 = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                if (this.textShadow) {
                    font.func_78261_a(render.text, startX1, startY1, intColor);
                    break;
                }
                this.drawString(font, render.text, startX1, startY1, intColor);
                break;
            }
            case TIPS_TEXT: {
                FontRenderer font = this.fontRenderer(render.resourceLocation);
                int width = font.func_78256_a(render.text);
                int startX1 = render.positionType.transformX(render.position.x, this.resolution.func_78326_a() - width);
                int startY1 = render.positionType.transformY(render.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                if (this.tipsTextShadow) {
                    font.func_78261_a(render.text, startX1, startY1, Integer.parseInt(this.tipsColor, 16));
                    break;
                }
                this.drawString(font, render.text, startX1, startY1, Integer.parseInt(this.tipsColor, 16));
                break;
            }
            case STATIC: {
                if (blending) {
                    double textureWidth;
                    double visibleWidth;
                    this.preDisplayScreen();
                    GL11.glClearColor((float)this.clearRed, (float)this.clearGreen, (float)this.clearBlue, (float)1.0f);
                    if (blendingJustSet) {
                        blendingJustSet = false;
                        Random rand = new Random();
                        newBlendImage = this.randomBackground(render.resourceLocation);
                    }
                    GL11.glColor4f((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue(), (float)blendAlpha);
                    blendAlpha -= this.alphaDecreaseStep;
                    if (blendAlpha <= 0.0f) {
                        blending = false;
                        this.background = newBlendImage;
                    }
                    try {
                        Thread.sleep(this.threadSleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ResourceLocation res = new ResourceLocation(render.resourceLocation);
                    this.textureManager.func_110577_a(res);
                    this.drawRect(startX, startY, PWidth, PHeight, render.texture.x, render.texture.y, render.texture.width, render.texture.height);
                    ImageRender render2 = new ImageRender(newBlendImage, EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 256, 256));
                    GL11.glColor4f((float)render2.getRed(), (float)render2.getGreen(), (float)render2.getBlue(), (float)(1.0f - blendAlpha - 0.05f));
                    ResourceLocation res2 = new ResourceLocation(render2.resourceLocation);
                    this.textureManager.func_110577_a(res2);
                    this.drawRect(startX, startY, PWidth, PHeight, render2.texture.x, render2.texture.y, render2.texture.width, render2.texture.height);
                    GL11.glColor4f((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue(), (float)1.0f);
                    ImageRender render3 = new ImageRender(this.images[4].resourceLocation, this.images[4].positionType, this.images[4].type, this.images[4].texture, this.images[4].position);
                    startX = this.progressPos[0];
                    startY = this.progressPos[1];
                    ResourceLocation res3 = new ResourceLocation(this.images[4].resourceLocation);
                    this.textureManager.func_110577_a(res3);
                    startX = render3.transformX(this.resolution.func_78326_a());
                    startY = render3.transformY(this.resolution.func_78328_b());
                    PWidth = 0;
                    PHeight = 0;
                    if (render3.position != null) {
                        PWidth = render3.position.width == 0 ? this.resolution.func_78326_a() : render3.position.width;
                        PHeight = render3.position.height == 0 ? this.resolution.func_78328_b() : render3.position.height;
                    }
                    this.drawRect(startX, startY, PWidth, PHeight, render3.texture.x, render3.texture.y, render3.texture.width, render3.texture.height);
                    ImageRender render4 = new ImageRender(this.images[5].resourceLocation, this.images[5].positionType, this.images[5].type, this.images[5].texture, this.images[5].position);
                    ResourceLocation res4 = new ResourceLocation(this.images[5].resourceLocation);
                    this.textureManager.func_110577_a(res4);
                    startX = render4.transformX(this.resolution.func_78326_a());
                    startY = render4.transformY(this.resolution.func_78328_b());
                    PWidth = 0;
                    PHeight = 0;
                    if (render4.position != null) {
                        PWidth = render4.position.width == 0 ? this.resolution.func_78326_a() : render4.position.width;
                        int n = PHeight = render4.position.height == 0 ? this.resolution.func_78328_b() : render4.position.height;
                    }
                    if (isRegisteringGTmaterials || isReplacingVanillaMaterials || isRegisteringBartWorks) {
                        visibleWidth = (float)PWidth * lastPercent;
                        textureWidth = (float)render4.texture.width * lastPercent;
                    } else {
                        visibleWidth = (double)PWidth * percent;
                        textureWidth = (double)render4.texture.width * percent;
                    }
                    GL11.glColor4f((float)this.lbRGB[0], (float)this.lbRGB[1], (float)this.lbRGB[2], (float)this.loadingBarsAlpha);
                    this.drawRect(startX, startY, visibleWidth, PHeight, render4.texture.x, render4.texture.y, textureWidth, render4.texture.height);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ImageRender render5 = new ImageRender(this.images[2].resourceLocation, this.images[2].positionType, this.images[2].type, this.images[2].texture, this.images[2].position);
                    FontRenderer font = this.fontRenderer(render5.resourceLocation);
                    int width = font.func_78256_a(text);
                    startX = render5.positionType.transformX(render5.position.x, this.resolution.func_78326_a() - width);
                    startY = render5.positionType.transformY(render5.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                    if (this.textShadow) {
                        font.func_78261_a(text, startX, startY, intColor);
                    } else {
                        this.drawString(font, text, startX, startY, intColor);
                    }
                    ImageRender render6 = new ImageRender(this.images[3].resourceLocation, this.images[3].positionType, this.images[3].type, this.images[3].texture, this.images[3].position);
                    String percentage = (int)(percent * 100.0) + "%";
                    width = font.func_78256_a(percentage);
                    startX = render6.positionType.transformX(render6.position.x, this.resolution.func_78326_a() - width);
                    startY = render6.positionType.transformY(render6.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                    if (this.textShadow) {
                        font.func_78261_a(percentage, startX, startY, intColor);
                    } else {
                        this.drawString(font, percentage, startX, startY, intColor);
                    }
                    if (isRegisteringGTmaterials || isReplacingVanillaMaterials || isRegisteringBartWorks) {
                        GL11.glColor4f((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue(), (float)1.0f);
                        ImageRender render7 = new ImageRender(this.images[8].resourceLocation, this.images[8].positionType, this.images[8].type, this.images[8].texture, this.images[8].position);
                        startX = this.progressPos[0];
                        startY = this.progressPos[1];
                        ResourceLocation res7 = new ResourceLocation(this.images[8].resourceLocation);
                        this.textureManager.func_110577_a(res3);
                        startX = render7.transformX(this.resolution.func_78326_a());
                        startY = render7.transformY(this.resolution.func_78328_b());
                        PWidth = 0;
                        PHeight = 0;
                        if (render7.position != null) {
                            PWidth = render7.position.width == 0 ? this.resolution.func_78326_a() : render7.position.width;
                            PHeight = render7.position.height == 0 ? this.resolution.func_78328_b() : render7.position.height;
                        }
                        this.drawRect(startX, startY, PWidth, PHeight, render7.texture.x, render7.texture.y, render7.texture.width, render7.texture.height);
                        ImageRender render8 = new ImageRender(this.images[9].resourceLocation, this.images[9].positionType, this.images[9].type, this.images[9].texture, this.images[9].position);
                        ResourceLocation res8 = new ResourceLocation(this.images[9].resourceLocation);
                        this.textureManager.func_110577_a(res8);
                        startX = render8.transformX(this.resolution.func_78326_a());
                        startY = render8.transformY(this.resolution.func_78328_b());
                        PWidth = 0;
                        PHeight = 0;
                        if (render4.position != null) {
                            PWidth = render8.position.width == 0 ? this.resolution.func_78326_a() : render8.position.width;
                            PHeight = render8.position.height == 0 ? this.resolution.func_78328_b() : render8.position.height;
                        }
                        visibleWidth = (double)PWidth * percent;
                        textureWidth = (double)render8.texture.width * percent;
                        GL11.glColor4f((float)this.lbRGB[0], (float)this.lbRGB[1], (float)this.lbRGB[2], (float)this.loadingBarsAlpha);
                        this.drawRect(startX, startY, visibleWidth, PHeight, render8.texture.x, render8.texture.y, textureWidth, render8.texture.height);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ImageRender render9 = new ImageRender(this.images[6].resourceLocation, this.images[6].positionType, this.images[6].type, this.images[6].texture, this.images[6].position);
                        font = this.fontRenderer(render9.resourceLocation);
                        width = font.func_78256_a(" Post Initialization: Registering Gregtech materials");
                        startX = render9.positionType.transformX(render9.position.x, this.resolution.func_78326_a() - width);
                        startY = render9.positionType.transformY(render9.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                        if (this.textShadow) {
                            font.func_78261_a(" Post Initialization: Registering Gregtech materials", startX, startY, intColor);
                        } else {
                            this.drawString(font, " Post Initialization: Registering Gregtech materials", startX, startY, intColor);
                        }
                        ImageRender render10 = new ImageRender(this.images[7].resourceLocation, this.images[7].positionType, this.images[7].type, this.images[7].texture, this.images[7].position);
                        percentage = (int)(percent * 100.0) + "%";
                        width = font.func_78256_a(String.valueOf((int)lastPercent * 100) + "%");
                        startX = render10.positionType.transformX(render10.position.x, this.resolution.func_78326_a() - width);
                        startY = render10.positionType.transformY(render10.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                        if (this.textShadow) {
                            font.func_78261_a(String.valueOf((int)(lastPercent * 100.0f)) + "%", startX, startY, intColor);
                        } else {
                            this.drawString(font, String.valueOf((int)(lastPercent * 100.0f)) + "%", startX, startY, intColor);
                        }
                    }
                    if (this.tipsEnabled) {
                        ImageRender render11 = null;
                        render11 = new ImageRender(fontTexture, EPosition.BOTTOM_CENTER, EType.TIPS_TEXT, null, new Area(this.tipsTextPos[0], this.tipsTextPos[1], 0, 0), this.tipsColor, this.tip, "");
                        font = this.fontRenderer(render11.resourceLocation);
                        width = font.func_78256_a(render11.text);
                        int startX1 = render11.positionType.transformX(render11.position.x, this.resolution.func_78326_a() - width);
                        int startY1 = render11.positionType.transformY(render11.position.y, this.resolution.func_78328_b() - font.field_78288_b);
                        if (this.tipsTextShadow) {
                            font.func_78261_a(render11.text, startX1, startY1, Integer.parseInt(this.tipsColor, 16));
                        } else {
                            this.drawString(font, render11.text, startX1, startY1, Integer.parseInt(this.tipsColor, 16));
                        }
                    }
                    this.postDisplayScreen();
                    this.drawImageRender(render, text, percent);
                    break;
                }
                if (!newBlendImage.contentEquals("none")) {
                    render = new ImageRender(newBlendImage, EPosition.TOP_LEFT, EType.STATIC, new Area(0, 0, 256, 256), new Area(0, 0, 256, 256));
                    newBlendImage = "none";
                }
                GL11.glColor4f((float)render.getRed(), (float)render.getGreen(), (float)render.getBlue(), (float)1.0f);
                ResourceLocation res = new ResourceLocation(render.resourceLocation);
                this.textureManager.func_110577_a(res);
                this.drawRect(startX, startY, PWidth, PHeight, render.texture.x, render.texture.y, render.texture.width, render.texture.height);
                break;
            }
        }
    }

    public void drawString(FontRenderer font, String text, int x, int y, int colour) {
        font.func_78276_b(text, x, y, colour);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawRect(double x, double y, double drawnWidth, double drawnHeight, double u, double v, double uWidth, double vHeight) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + drawnHeight, 0.0, u * (double)f, (v + vHeight) * (double)f);
        tessellator.func_78374_a(x + drawnWidth, y + drawnHeight, 0.0, (u + uWidth) * (double)f, (v + vHeight) * (double)f);
        tessellator.func_78374_a(x + drawnWidth, y, 0.0, (u + uWidth) * (double)f, v * (double)f);
        tessellator.func_78374_a(x, y, 0.0, u * (double)f, v * (double)f);
        tessellator.func_78381_a();
    }

    private void preDisplayScreen() {
        if (this.textureManager == null) {
            if (this.preview) {
                this.textureManager = this.mc.field_71446_o;
            } else {
                this.textureManager = this.mc.field_71446_o = new TextureManager(this.mc.func_110442_L());
                this.mc.func_110436_a();
                this.textureManager.func_110549_a(this.mc.func_110442_L());
                this.mc.field_71466_p = new FontRenderer(this.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.textureManager, false);
                if (this.mc.field_71474_y.field_74363_ab != null) {
                    this.mc.field_71466_p.func_78264_a(this.mc.func_152349_b());
                    LanguageManager lm = this.mc.func_135016_M();
                    this.mc.field_71466_p.func_78275_b(lm.func_135044_b());
                }
                this.mc.field_71466_p.func_110549_a(this.mc.func_110442_L());
                this.callAgain = true;
            }
        }
        if (this.fontRenderer != this.mc.field_71466_p) {
            this.fontRenderer = this.mc.field_71466_p;
        }
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int i = this.resolution.func_78325_e();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.func_78326_a(), (double)this.resolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glClearColor((float)this.clearRed, (float)this.clearGreen, (float)this.clearBlue, (float)1.0f);
        if (this.shouldGLClear) {
            GL11.glClear((int)16640);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ImageRender[] getImageData() {
        return this.images;
    }

    private void postDisplayScreen() {
        this.mc.func_147120_f();
    }

    @Override
    public void close() {
        if (this.tipExec != null) {
            this.tipExec.shutdown();
        }
        if (this.backgroundExec != null) {
            this.backgroundExec.shutdown();
        }
        this.getOnlyList().remove(this.myPack);
    }

    static {
        defaultSound = "betterloadingscreen:rhapsodia_orb";
        defaultFontTexture = "textures/font/ascii.png";
        lastPercent = 0.0f;
        useCustomTips = false;
        customTipFilename = "en_US";
        randomBackgroundArray = new String[]{"betterloadingscreen:textures/backgrounds/background1.png", "betterloadingscreen:textures/backgrounds/background2.png"};
        imgurGalleryLink = "https://imgur.com/gallery/Ks0TrYE";
        isNice = false;
        isRegisteringGTmaterials = false;
        isReplacingVanillaMaterials = false;
        isRegisteringBartWorks = false;
        blending = false;
        blendingJustSet = false;
        blendAlpha = 1.0f;
        newBlendImage = "none";
        log = LogManager.getLogger((String)"betterloadingscreen");
    }
}

