/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.crafting.CompressOreRecipe;
import fox.spiteful.avaritia.crafting.CompressorManager;
import fox.spiteful.avaritia.crafting.CompressorRecipe;
import fox.spiteful.avaritia.gui.GUICompressor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class CompressionHandler
extends TemplateRecipeHandler {
    @SideOnly(value=Side.CLIENT)
    private FontRenderer fontRender;

    @SideOnly(value=Side.CLIENT)
    public CompressionHandler() {
        this.fontRender = Minecraft.func_71410_x().field_71466_p;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "extreme_compression", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUICompressor.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"crafting.extreme_compression");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("extreme_compression") && ((Object)((Object)this)).getClass() == CompressionHandler.class) {
            for (CompressorRecipe recipe : CompressorManager.getRecipes()) {
                if (!this.safeOre(recipe)) continue;
                CachedCompression r = new CachedCompression(recipe);
                r.computeVisuals();
                this.arecipes.add(r);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CompressorRecipe recipe : CompressorManager.getRecipes()) {
            if (!this.safeOre(recipe) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            CachedCompression r = new CachedCompression(recipe);
            r.computeVisuals();
            this.arecipes.add(r);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("extreme_compression") && ((Object)((Object)this)).getClass() == CompressionHandler.class) {
            this.loadCraftingRecipes("extreme_compression", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (CompressorRecipe recipe : CompressorManager.getRecipes()) {
            if (!this.safeOre(recipe) || !recipe.validInput(ingredient)) continue;
            CachedCompression r = new CachedCompression(recipe.getOutput(), recipe.getCost(), ingredient);
            r.computeVisuals();
            this.arecipes.add(r);
        }
    }

    private boolean safeOre(CompressorRecipe recipe) {
        if (!(recipe instanceof CompressOreRecipe)) {
            return true;
        }
        return !((ArrayList)recipe.getIngredient()).isEmpty();
    }

    public String getGuiTexture() {
        return "avaritia:textures/gui/compressor.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(74, 15, 176, 14, 24, 16, 48, 0);
    }

    public String getOverlayIdentifier() {
        return "extreme_compression";
    }

    public class CachedCompression
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack ingred;
        private PositionedStack result;
        private int cost;

        public CachedCompression(CompressorRecipe recipe) {
            this(recipe.getOutput(), recipe.getCost(), recipe.getIngredient());
        }

        public CachedCompression(ItemStack output, int price, Object ingredient) {
            super((TemplateRecipeHandler)CompressionHandler.this);
            this.ingred = new PositionedStack(ingredient, 51, 16);
            this.result = new PositionedStack((Object)output, 111, 16);
            this.cost = price;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CompressionHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (ItemStack item : this.ingred.items) {
                item.field_77994_a = this.cost;
            }
            this.ingred.item.field_77994_a = this.cost;
            this.ingred.generatePermutations();
        }

        public int getCost() {
            return this.cost;
        }
    }
}

