/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.network.MessageHourglassFlipped;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityHourglass
extends ModTileEntity {
    public final float SECONDS_COOLDOWN_BETWEEN_FLIPS = 0.25f;
    public final int REDSTONE_PULSE_LENGTH = 5;
    protected int ticksTarget;
    protected int ticksCounted = this.ticksTarget = 100;
    protected int ticksSendingPulse = 0;
    public boolean receivingSignal = false;
    public long timeDidFlip = 0L;
    public boolean flipped = false;
    public boolean modeRepeat = false;
    protected int comparatorSignalStrength = 0;

    public int getRedstoneSignalStrength() {
        return this.ticksSendingPulse > 0 ? 15 : 0;
    }

    public int getComparatorSignalStrength() {
        return this.comparatorSignalStrength;
    }

    public int getTargetTimeSeconds() {
        return this.ticksTarget / 20;
    }

    public void setTargetTimeSeconds(int target) {
        if (target < 1) {
            target = 1;
        } else if (target > Short.MAX_VALUE) {
            target = Short.MAX_VALUE;
        }
        if ((target *= 20) != this.ticksTarget) {
            if (this.ticksCounted >= this.ticksTarget) {
                this.ticksCounted = target;
            } else if (this.ticksCounted >= target) {
                this.ticksCounted = target - 1;
            }
            this.ticksTarget = target;
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            }
        }
    }

    public int getRemainingSeconds() {
        return MathHelper.func_76123_f((float)((float)(this.ticksTarget - this.ticksCounted) / 20.0f));
    }

    public float percentageComplete() {
        return (float)this.ticksCounted / (float)this.ticksTarget * 100.0f;
    }

    public void updateRedstoneInput(boolean newSignal) {
        if (this.receivingSignal) {
            if (!newSignal) {
                this.receivingSignal = false;
                this.markDirty(false);
            }
        } else if (newSignal) {
            this.receivingSignal = true;
            this.markDirty(false);
            this.startFlipOnServer(false);
        }
    }

    public boolean startFlipOnServer(boolean timeCheck) {
        float secondsCooldown = timeCheck ? 0.25f : 0.125f;
        long time = System.nanoTime();
        if ((float)(time - this.timeDidFlip) > secondsCooldown * 1.0E9f) {
            this.flipped = !this.flipped;
            this.timeDidFlip = time;
            this.ticksCounted = this.onFlipTickCount();
            if (this.ticksCounted > this.ticksTarget) {
                this.ticksCounted = this.ticksTarget;
                this.notifyNeighbors();
            }
            MessageHourglassFlipped.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.flipped);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void receiveFlipFromServer(boolean flipState) {
        this.flipped = flipState;
        this.timeDidFlip = System.nanoTime();
        this.ticksCounted = this.onFlipTickCount();
        if (this.ticksCounted > this.ticksTarget) {
            this.ticksCounted = this.ticksTarget;
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        boolean neighborsNeedNotification = false;
        if (this.ticksSendingPulse > 0) {
            --this.ticksSendingPulse;
            if (this.ticksSendingPulse == 0) {
                neighborsNeedNotification = true;
            }
        }
        if (this.ticksCounted < this.ticksTarget) {
            ++this.ticksCounted;
            if (!this.field_145850_b.field_72995_K && this.ticksCounted == this.ticksTarget) {
                this.ticksSendingPulse = 5;
                this.comparatorSignalStrength = 0;
                neighborsNeedNotification = true;
                this.func_70296_d();
                if (this.modeRepeat) {
                    this.startFlipOnServer(false);
                }
            } else {
                int css = RedstoneCalc.getRedstoneSignalStrengthFromValues(this.ticksCounted, this.ticksTarget);
                if (this.comparatorSignalStrength != css) {
                    this.comparatorSignalStrength = css;
                    neighborsNeedNotification = true;
                }
            }
        }
        if (neighborsNeedNotification) {
            this.notifyNeighbors();
        }
    }

    protected int onFlipTickCount() {
        return this.ticksTarget - this.ticksCounted;
    }

    protected void notifyNeighbors() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("ticksTarget", this.ticksTarget);
        nbttagcompound.func_74768_a("ticksCounted", this.ticksCounted);
        nbttagcompound.func_74777_a("ticksSendingSignal", (short)this.ticksSendingPulse);
        nbttagcompound.func_74757_a("receivingSignal", this.receivingSignal);
        nbttagcompound.func_74777_a("comparatorSignalStrength", (short)this.comparatorSignalStrength);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.ticksTarget = nbttagcompound.func_74762_e("ticksTarget");
        this.ticksCounted = nbttagcompound.func_74762_e("ticksCounted");
        this.ticksSendingPulse = nbttagcompound.func_74765_d("ticksSendingSignal");
        this.receivingSignal = nbttagcompound.func_74767_n("receivingSignal");
        this.comparatorSignalStrength = nbttagcompound.func_74765_d("comparatorSignalStrength");
    }
}

