/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.chat;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import pl.asie.lib.api.chat.INicknameHandler;
import pl.asie.lib.api.chat.INicknameRepository;
import pl.asie.lib.util.ChatUtils;
import pl.asie.lib.util.PlayerUtils;

public class NicknameRepository
implements INicknameRepository {
    protected BiMap<String, String> nicknames;
    private File nicknameFile;
    private Gson gson;
    private Type gsonType;
    private HashSet<INicknameHandler> handlers = new HashSet();

    public NicknameRepository() {
        this.gson = new Gson();
        this.gsonType = new TypeToken<HashBiMap<String, String>>(){}.getType();
        this.nicknames = HashBiMap.create();
    }

    @Override
    public void setNickname(String username, String nickname) {
        if (nickname.equals("-") && this.nicknames.containsKey((Object)username)) {
            this.nicknames.remove((Object)username);
        } else {
            this.nicknames.put((Object)username, (Object)nickname);
        }
        this.updateNickname(username);
        this.saveNicknames();
    }

    public void updateNickname(String username) {
        EntityPlayer player = PlayerUtils.find(username);
        if (player != null) {
            player.refreshDisplayName();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        String nickname = this.getNickname(username);
        for (INicknameHandler handler : this.handlers) {
            handler.onNicknameUpdate(username, nickname);
        }
    }

    @Override
    public String getUsername(String nickname) {
        for (String username : this.nicknames.keySet()) {
            String nick = (String)this.nicknames.get((Object)username);
            if (nick == null || !ChatUtils.stripColors(nick).equals(nickname)) continue;
            return username;
        }
        return null;
    }

    @Override
    public String getNickname(String username) {
        return this.nicknames.containsKey((Object)username) ? (String)this.nicknames.get((Object)username) : username;
    }

    public String getRawNickname(String username) {
        String nn = this.getNickname(username);
        return ChatUtils.stripColors(nn);
    }

    public boolean hasNickname(String username) {
        return this.nicknames.containsKey((Object)username) && !((String)this.nicknames.get((Object)username)).equals(username);
    }

    public void loadNicknames(String data) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        try {
            this.nicknames = (BiMap)this.gson.fromJson(data, this.gsonType);
            for (String username : this.nicknames.keySet()) {
                this.updateNickname(username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nicknames = HashBiMap.create();
        }
    }

    public void loadNicknames() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        this.nicknameFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "nicknames.json");
        this.nicknames = HashBiMap.create();
        if (!this.nicknameFile.exists()) {
            return;
        }
        try {
            LinkedTreeMap hm = (LinkedTreeMap)this.gson.fromJson((Reader)new FileReader(this.nicknameFile), this.gsonType);
            for (String a : hm.keySet()) {
                this.nicknames.put((Object)a, hm.get((Object)a));
            }
            for (String username : this.nicknames.keySet()) {
                this.updateNickname(username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveNicknames() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(this.nicknameFile);
            fw.write(this.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.gson.toJson(this.nicknames, this.gsonType);
    }

    @SubscribeEvent
    public void nameFormat(PlayerEvent.NameFormat event) {
        event.displayname = this.getRawNickname(event.username);
    }

    public void addHandler(INicknameHandler handler) {
        this.handlers.add(handler);
    }
}

