/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.AromaBackup;
import aroma1997.core.config.Conf;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class Config {
    public static final Config instance = new Config();
    private static final String CATEGORY_BACKUP = "BACKUP";
    private final Configuration config = Conf.getConfig((String)"AromaBackup");
    public boolean allPlayers;
    public String location;
    public long delay;
    public int compressionRate;
    public int toKeep;
    public boolean onStartup;
    public boolean skipBackup;
    public boolean useWhitelist;
    private int[] whitelist;
    private int[] blacklist;

    public void reload() {
        this.config.load();
        this.allPlayers = this.config.get("general", "allPlayers", true, "If all players or only admins can use the /backup command.").getBoolean(true);
        this.location = this.config.get("general", "location", "./backups", "Where to store the Backups. Either an absolute path or relative to the minecraft folder.").getString();
        this.delay = this.config.get("general", "delay", 30, "How frequently a automatic backup is done in minutes. 0 means Auto-Backup disabled.").getInt();
        this.toKeep = this.config.get("general", "keep", 20, "How many backups are kept. 0 means infinite").getInt();
        this.onStartup = this.config.get("general", "onStartup", true, "If a backup should be done when the world gets loaded.").getBoolean(true);
        this.skipBackup = this.config.get("general", "skipbackup", true, "If the scheduled backup should be skipped if no players were on the server since the last one.").getBoolean(true);
        if (this.toKeep <= 0) {
            this.toKeep = 0;
        }
        if (this.delay <= 0L) {
            this.delay = 0L;
            AromaBackup.instance.logger.log(Level.WARN, "Automatic backups disabled. This is not recommended.");
        } else {
            this.delay *= 60000L;
        }
        Property compression = this.config.get("general", "compressionRate", 5, "Compression rate. Has to be between 9 (high compression) and 1 (low compression).");
        this.compressionRate = compression.getInt();
        if (this.compressionRate > 9 || this.compressionRate < 1) {
            compression.set(5);
            this.compressionRate = 5;
        }
        this.useWhitelist = this.config.get("general", "useWhitelist", false, "If this is set to true, it will use the Dimension Whitelist, if it is false, it will use the Dimension Blacklist").getBoolean();
        this.whitelist = this.config.get("general", "whitelist", new int[]{0, 1, -1}, "If the whitelist is enabled, only the dimensions (ids) specified here will be backed up.").getIntList();
        this.blacklist = this.config.get("general", "blacklist", new int[0], "If the blacklist is enabled, the dimensions (ids) specified here will not be backed up.").getIntList();
        AromaBackup.instance.logger.log(Level.INFO, (this.useWhitelist ? "Using Dimension Whitelist " : "Using Dimension Blacklist ") + "with  " + (this.useWhitelist ? this.whitelist.length : this.blacklist.length) + " entries.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean shouldSaveDimension(int dim) {
        if (this.useWhitelist) {
            for (int i = 0; i < this.whitelist.length; ++i) {
                if (this.whitelist[i] != dim) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.blacklist.length; ++i) {
            if (this.blacklist[i] != dim) continue;
            return false;
        }
        return true;
    }
}

