/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.tile;

import gcewing.architecture.common.block.IBlockArchitecture;
import gcewing.architecture.common.tile.ITickable;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class TileArchitecture
extends TileEntity {
    public byte side;
    public byte turn;
    public ForgeChunkManager.Ticket chunkTicket;

    public BlockPos getPos() {
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    public void setSide(int side) {
        this.side = (byte)side;
    }

    public void setTurn(int turn) {
        this.turn = (byte)turn;
    }

    public Trans3 localToGlobalRotation() {
        return this.localToGlobalTransformation(Vector3.zero);
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(Vector3.blockCenter(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public Trans3 localToGlobalTransformation(Vector3 origin, IBlockState state) {
        BlockPos pos = this.getPos();
        Block block = state.getBlock();
        return ((IBlockArchitecture)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, pos, state, this, origin);
    }

    public Trans3 localToGlobalTransformation(Vector3 origin) {
        BlockPos pos = this.getPos();
        IBlockState state = BlockCompatUtils.getWorldBlockState((IBlockAccess)this.field_145850_b, pos);
        Block block = state.getBlock();
        if (block instanceof IBlockArchitecture) {
            return ((IBlockArchitecture)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, pos, state, this, origin);
        }
        return new Trans3(origin);
    }

    public Packet func_145844_m() {
        if (this.syncWithClient()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void markForClientUpdate() {
        PlayerManager pm = ((WorldServer)this.field_145850_b).func_73040_p();
        PlayerManager.PlayerInstance watcher = pm.func_72690_a(this.field_145851_c >> 4, this.field_145849_e >> 4, false);
        if (watcher != null) {
            int oldFlags = watcher.field_73260_f;
            this.markBlockForUpdate();
            watcher.field_73260_f = oldFlags;
        } else {
            this.markBlockForUpdate();
        }
    }

    public void markForUpdate() {
        this.func_70296_d();
        this.markForClientUpdate();
    }

    public void onAddedToWorld() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.side = nbt.func_74771_c("side");
        this.turn = nbt.func_74771_c("turn");
        this.readContentsFromNBT(nbt);
    }

    public void readFromItemStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            this.readFromItemStackNBT(nbt);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        this.readContentsFromNBT(nbt);
    }

    public void readContentsFromNBT(NBTTagCompound nbt) {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.side != 0) {
            nbt.func_74774_a("side", this.side);
        }
        if (this.turn != 0) {
            nbt.func_74774_a("turn", this.turn);
        }
        this.writeContentsToNBT(nbt);
    }

    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeContentsToNBT(nbt);
    }

    public void writeContentsToNBT(NBTTagCompound nbt) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, TileArchitecture te) {
        return TileArchitecture.blockStackWithTileEntity(block, size, 0, te);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, int meta, TileArchitecture te) {
        ItemStack stack = new ItemStack(block, size, meta);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.writeToItemStackNBT(tag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public ItemStack newItemStack(int size) {
        return TileArchitecture.blockStackWithTileEntity(this.func_145838_q(), size, this);
    }

    public boolean canUpdate() {
        return this instanceof ITickable;
    }

    public void func_145845_h() {
        ((ITickable)((Object)this)).update();
    }
}

