/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.RenderShape;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.client.render.model.WindowModel;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.shape.Window;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.Trans3;
import java.util.Arrays;
import net.minecraft.util.EnumFacing;

public class RenderWindow
extends RenderShape {
    protected static ArchitectureCraftClient client;
    protected static WindowModel frameModels;
    protected static WindowModel cornerModels;
    protected static WindowModel mullionModels;
    protected boolean renderBase;
    protected boolean renderSecondary;
    protected Window kind;

    public RenderWindow() {
    }

    protected static IArchitectureModel model(String name) {
        if (name != null) {
            return client.getModel("shape/window_" + name + ".objson");
        }
        return null;
    }

    protected static IArchitectureModel[] models(String ... names) {
        IArchitectureModel[] result = new IArchitectureModel[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = RenderWindow.model(names[i]);
        }
        return result;
    }

    protected static IArchitectureModel[] models(int n, String name) {
        Object[] result = new IArchitectureModel[n];
        IArchitectureModel m = RenderWindow.model(name);
        Arrays.fill(result, m);
        return result;
    }

    public static void init(ArchitectureCraftClient client) {
        RenderWindow.client = client;
        frameModels = new WindowModel(null, null, RenderWindow.models(4, "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models(4, "glass_edge"));
        cornerModels = new WindowModel(RenderWindow.model("corner_centre"), RenderWindow.models("corner_centre_end0", null, "corner_centre_end2", null), RenderWindow.models("corner_topbot", "frame_side", "corner_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models("corner_topbot_end1", "frame_end1", "corner_topbot_end1", "frame_end1"), RenderWindow.model("corner_glass"), RenderWindow.models("corner_glass_edge", "glass_edge", "corner_glass_edge", "glass_edge"));
        mullionModels = new WindowModel(RenderWindow.model("mullion_centre"), RenderWindow.models("mullion_centre_end0", null, "mullion_centre_end2", null), RenderWindow.models("mullion_topbot", "frame_side", "mullion_topbot", "frame_side"), RenderWindow.models(4, "frame_end0"), RenderWindow.models(4, "frame_end1"), RenderWindow.model("glass"), RenderWindow.models("mullion_glass_edge", "glass_edge", "mullion_glass_edge", "glass_edge"));
    }

    public RenderWindow(TileShape te, ITexture[] textures, Trans3 t, IRenderTarget target, boolean renderBase, boolean renderSecondary) {
        super(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
        this.kind = (Window)te.shape.kind;
    }

    @Override
    public void render() {
        switch (this.te.shape) {
            case WindowFrame: {
                this.renderWindow(frameModels);
                break;
            }
            case WindowCorner: {
                this.renderWindow(cornerModels);
                break;
            }
            case WindowMullion: {
                this.renderWindow(mullionModels);
            }
        }
    }

    protected void renderWindow(WindowModel models) {
        boolean[][] frame = this.getFrameFlags();
        if (this.renderBase) {
            this.renderModel(this.t, models.centre);
        }
        for (int i = 0; i <= 3; ++i) {
            int j = i - 1 & 3;
            int k = i + 1 & 3;
            Trans3 ts = this.t.t(this.kind.frameTrans[i]);
            if (this.renderBase) {
                if (frame[i][1]) {
                    this.renderModel(ts, models.side[i]);
                } else if (models.centreEnd != null) {
                    this.renderModel(this.t, models.centreEnd[i]);
                }
                if (frame[i][1] && !frame[j][1] || frame[i][0] && frame[j][2]) {
                    this.renderModel(ts, models.end0[i]);
                }
                if (frame[i][1] && !frame[k][1] || frame[i][2] && frame[k][0]) {
                    this.renderModel(ts, models.end1[i]);
                }
            }
            if (!this.renderSecondary || frame[i][1] || frame[i][3]) continue;
            this.renderModel(ts, models.glassEdge[i]);
        }
        if (this.renderSecondary) {
            this.renderModel(this.t, models.glass);
        }
    }

    protected void renderModel(Trans3 t, IArchitectureModel model) {
        if (model != null) {
            model.render(t, this.target, this.textures);
        }
    }

    protected boolean[][] getFrameFlags() {
        boolean[][] frame = new boolean[4][4];
        if (this.blockWorld == null) {
            for (int i = 0; i <= 3; ++i) {
                frame[i][1] = true;
            }
        } else {
            int i;
            EnumFacing[] gdir = new EnumFacing[4];
            for (i = 0; i <= 3; ++i) {
                gdir[i] = this.t.t(this.kind.frameSides[i]);
            }
            for (i = 0; i <= 3; ++i) {
                if (this.kind.frameAlways[i]) {
                    frame[i][1] = true;
                    continue;
                }
                TileShape nte = this.getConnectedNeighbourGlobal(this.te, gdir[i]);
                if (nte == null) {
                    frame[i][1] = true;
                    continue;
                }
                int j = i - 1 & 3;
                int k = i + 1 & 3;
                if (this.getConnectedNeighbourGlobal(nte, gdir[j]) == null) {
                    frame[j][2] = true;
                }
                if (this.getConnectedNeighbourGlobal(nte, gdir[k]) == null) {
                    frame[k][0] = true;
                }
                if (nte.secondaryBlockState == null) continue;
                frame[i][3] = true;
            }
        }
        return frame;
    }

    protected TileShape getConnectedNeighbourGlobal(TileShape te, EnumFacing globalDir) {
        return this.kind.getConnectedWindowGlobal(te, globalDir);
    }

    public void prepare(TileShape te, ITexture[] textures, Trans3 t, IRenderTarget target, boolean renderBase, boolean renderSecondary, Window kind) {
        this.te = te;
        this.textures = textures;
        this.t = t;
        this.target = target;
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
        this.kind = kind;
    }
}

