/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.common.block.BlockSawbench;
import gcewing.architecture.common.block.BlockShape;
import gcewing.architecture.common.item.ArchitectureItemBlock;
import gcewing.architecture.common.item.ItemArchitecture;
import gcewing.architecture.common.item.ItemChisel;
import gcewing.architecture.common.item.ItemCladding;
import gcewing.architecture.common.item.ItemHammer;
import gcewing.architecture.common.shape.ShapeItem;
import gcewing.architecture.common.tile.TileSawbench;
import gcewing.architecture.common.tile.TileShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ArchitectureContent {
    public final List<Block> registeredBlocks = new ArrayList<Block>();
    public final List<Item> registeredItems = new ArrayList<Item>();
    protected final Map<ResourceLocation, IArchitectureModel> modelCache = new ConcurrentHashMap<ResourceLocation, IArchitectureModel>();
    public BlockSawbench blockSawbench;
    public BlockShape blockShape;
    public BlockShape blockShapeSE;
    public Item itemSawblade;
    public Item itemLargePulley;
    public Item itemChisel;
    public Item itemHammer;
    public ItemCladding itemCladding;

    public void preInit(FMLPreInitializationEvent e) {
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerRecipes();
    }

    protected void registerBlocks() {
        this.blockSawbench = this.registerBlock(new BlockSawbench(), "sawbench", ArchitectureItemBlock.class);
        this.blockSawbench.func_149711_c(2.0f);
        this.blockShape = this.registerBlock(new BlockShape(), "shape", ShapeItem.class);
        this.blockShapeSE = this.registerBlock(new BlockShape(), "shapeSE", ShapeItem.class);
    }

    protected void registerTileEntities() {
        GameRegistry.registerTileEntity(TileSawbench.class, (String)"gcewing.sawbench");
        GameRegistry.registerTileEntity(TileShape.class, (String)"gcewing.shape");
    }

    protected void registerItems() {
        this.itemSawblade = this.registerItem(new ItemArchitecture(), "sawblade");
        this.itemLargePulley = this.registerItem(new ItemArchitecture(), "largePulley");
        this.itemChisel = this.registerItem(new ItemChisel(), "chisel");
        this.itemHammer = this.registerItem(new ItemHammer(), "hammer");
        this.itemCladding = this.registerItem(new ItemCladding(), "cladding");
    }

    protected void registerRecipes() {
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            ItemStack orangeDye = new ItemStack(Items.field_151100_aR, 1, 14);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockSawbench, 1), (Object[])new Object[]{"I*I", "/0/", "/_/", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('*'), this.itemSawblade, Character.valueOf('/'), Items.field_151055_y, Character.valueOf('_'), Blocks.field_150452_aw, Character.valueOf('0'), this.itemLargePulley});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.itemSawblade, 1), (Object[])new Object[]{" I ", "I/I", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('/'), Items.field_151055_y});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.itemLargePulley, 1), (Object[])new Object[]{" W ", "W/W", " W ", Character.valueOf('W'), Blocks.field_150344_f, Character.valueOf('/'), Items.field_151055_y});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.itemChisel, 1), (Object[])new Object[]{"I ", "ds", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('d'), orangeDye});
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.itemHammer, 1), (Object[])new Object[]{"II ", "dsI", "ds ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('d'), orangeDye});
        }
    }

    public <T extends Block> T registerBlock(T block, String name, Class<? extends ItemBlock> itemClass) {
        String qualName = ArchitectureCraft.ASSET_KEY + ":" + name;
        block.func_149663_c(qualName);
        block.func_149658_d(ArchitectureCraft.REGISTRY_PREFIX + ":" + name);
        GameRegistry.registerBlock(block, itemClass, (String)name);
        block.func_149647_a(CreativeTabs.field_78026_f);
        this.registeredBlocks.add(block);
        return block;
    }

    public <T extends Item> T registerItem(T item, String name) {
        String qualName = ArchitectureCraft.ASSET_KEY + ":" + name;
        item.func_77655_b(qualName);
        item.func_111206_d(ArchitectureCraft.REGISTRY_PREFIX + ":" + name);
        GameRegistry.registerItem(item, (String)name);
        item.func_77637_a(CreativeTabs.field_78026_f);
        this.registeredItems.add(item);
        return item;
    }
}

