/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseItemBlock;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.BlockState;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.IProperty;
import gcewing.architecture.InventoryHelper;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    public static boolean debugState = false;
    protected static Random RANDOM = new Random();
    public static IOrientationHandler orient1Way = new Orient1Way();
    protected MapColor mapColor;
    protected final BlockState blockState;
    protected IBlockState defaultBlockState;
    protected IProperty[] properties;
    protected Object[][] propertyValues;
    protected int numProperties;
    protected int renderID;
    protected Class<? extends TileEntity> tileEntityClass = null;
    protected IOrientationHandler orientationHandler = orient1Way;
    protected String[] textureNames;
    protected BaseMod.ModelSpec modelSpec;
    protected BaseMod mod;
    protected AxisAlignedBB boxHit;
    protected ThreadLocal<TileEntity> harvestingTileEntity = new ThreadLocal();

    @Override
    public Class getDefaultItemClass() {
        return BaseItemBlock.class;
    }

    public BaseBlock(Material material) {
        this(material, null, null, null);
    }

    public BaseBlock(Material material, IOrientationHandler orient) {
        this(material, orient, null, null);
    }

    public BaseBlock(Material material, Class<TE> teClass) {
        this(material, null, teClass, null);
    }

    public BaseBlock(Material material, IOrientationHandler orient, Class<TE> teClass) {
        this(material, orient, teClass, null);
    }

    public BaseBlock(Material material, Class<TE> teClass, String teID) {
        this(material, null, teClass, teID);
    }

    public BaseBlock(Material material, IOrientationHandler orient, Class<TE> teClass, String teID) {
        super(material);
        if (orient == null) {
            orient = orient1Way;
        }
        this.orientationHandler = orient;
        this.tileEntityClass = teClass;
        if (teClass != null) {
            if (teID == null) {
                teID = teClass.getName();
            }
            try {
                GameRegistry.registerTileEntity(teClass, (String)teID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.blockState = this.createBlockState();
        this.defaultBlockState = this.blockState.getBaseState();
        this.field_149787_q = true;
    }

    public BaseBlock setOpaque(boolean state) {
        this.field_149787_q = state;
        return this;
    }

    public boolean func_149662_c() {
        return this.field_149787_q;
    }

    public IOrientationHandler getOrientationHandler() {
        return this.orientationHandler;
    }

    protected void defineProperties() {
        this.properties = new IProperty[4];
        this.propertyValues = new Object[4][];
        this.getOrientationHandler().defineProperties(this);
    }

    protected void addProperty(IProperty property) {
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s to %s\n", property, this.getClass().getName());
        }
        if (this.numProperties >= 4) {
            throw new IllegalStateException("Block " + this.getClass().getName() + " has too many properties");
        }
        int i = this.numProperties++;
        this.properties[i] = property;
        Object[] values = BaseUtils.arrayOf(property.getAllowedValues());
        this.propertyValues[i] = values;
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s now has %s properties\n", this.getClass().getName(), this.numProperties);
        }
    }

    protected BlockState createBlockState() {
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Defining properties\n", new Object[0]);
        }
        this.defineProperties();
        if (debugState) {
            this.dumpProperties();
        }
        this.checkProperties();
        IProperty[] props = Arrays.copyOf(this.properties, this.numProperties);
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Creating BlockState with %s properties\n", props.length);
        }
        return new BlockState((Block)this, props);
    }

    private void dumpProperties() {
        System.out.printf("BaseBlock: Properties of %s:\n", this.getClass().getName());
        for (int i = 0; i < this.numProperties; ++i) {
            System.out.printf("%s: %s\n", i, this.properties[i]);
            Object[] values = this.propertyValues[i];
            for (int j = 0; j < values.length; ++j) {
                System.out.printf("   %s: %s\n", j, values[j]);
            }
        }
    }

    protected void checkProperties() {
        int n = 1;
        for (int i = 0; i < this.numProperties; ++i) {
            n *= this.propertyValues[i].length;
        }
        if (n > 16) {
            throw new IllegalStateException(String.format("Block %s has %s combinations of property values (16 allowed)", this.getClass().getName(), n));
        }
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public final IBlockState getDefaultState() {
        return this.defaultBlockState;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public int getMetaFromState(IBlockState state) {
        int meta = 0;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            int k;
            Object value = state.getValue(this.properties[i]);
            Object[] values = this.propertyValues[i];
            for (k = values.length - 1; k > 0 && !values[k].equals(value); --k) {
            }
            if (debugState) {
                System.out.printf("BaseBlock.getMetaFromState: property %s value %s --> %s of %s\n", i, value, k, values.length);
            }
            meta = meta * values.length + k;
        }
        if (debugState) {
            System.out.printf("BaseBlock.getMetaFromState: %s --> %s\n", state, meta);
        }
        return meta & 0xF;
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState();
        int m = meta;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Object[] values = this.propertyValues[i];
            int n = values.length;
            int k = m % n;
            m /= n;
            state = state.withProperty(this.properties[i], (Comparable)values[k]);
        }
        if (debugState) {
            System.out.printf("BaseBlock.getStateFromMeta: %s --> %s\n", meta, state);
        }
        return state;
    }

    @Override
    public int getNumSubtypes() {
        return 1;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        this.harvestingTileEntity.set(te);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        TileEntity te = this.harvestingTileEntity.get();
        this.harvestBlock(world, player, new BlockPos(x, y, z), this.getStateFromMeta(meta), te);
    }

    public void harvestBlock(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        super.func_149636_a(world, player, pos.x, pos.y, pos.z, this.getMetaFromState(state));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        IBlockState state = this.getStateFromMeta(meta);
        ArrayList<ItemStack> result = this.getDrops((IBlockAccess)world, new BlockPos(x, y, z), state, fortune);
        this.harvestingTileEntity.set(null);
        return result;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = BaseBlockUtils.getWorldTileEntity(world, pos);
        if (te == null) {
            te = this.harvestingTileEntity.get();
        }
        return this.getDropsFromTileEntity(world, pos, state, te, fortune);
    }

    protected ArrayList<ItemStack> getDropsFromTileEntity(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te, int fortune) {
        int meta = this.getMetaFromState(state);
        return super.getDrops((World)world, pos.x, pos.y, pos.z, meta, fortune);
    }

    public void setModelAndTextures(String modelName, String ... textureNames) {
        this.textureNames = textureNames;
        this.modelSpec = new BaseMod.ModelSpec(modelName, textureNames);
    }

    public void setModelAndTextures(String modelName, Vector3 origin, String ... textureNames) {
        this.textureNames = textureNames;
        this.modelSpec = new BaseMod.ModelSpec(modelName, origin, textureNames);
    }

    @Override
    public String[] getTextureNames() {
        return this.textureNames;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return this.modelSpec;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return this.getBlockLayer() == layer;
    }

    public EnumWorldBlockLayer getBlockLayer() {
        return EnumWorldBlockLayer.SOLID;
    }

    public int func_149645_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int id) {
        this.renderID = id;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String name = this.getRendererClassName();
        if (name != null) {
            name = this.getClass().getPackage().getName() + "." + name;
        }
        return name;
    }

    protected String getRendererClassName() {
        return null;
    }

    public Trans3 localToGlobalRotation(IBlockAccess world, BlockPos pos) {
        return this.localToGlobalRotation(world, pos, BaseBlockUtils.getWorldBlockState(world, pos));
    }

    public Trans3 localToGlobalRotation(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.localToGlobalTransformation(world, pos, state, Vector3.zero);
    }

    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos) {
        return this.localToGlobalTransformation(world, pos, BaseBlockUtils.getWorldBlockState(world, pos));
    }

    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.localToGlobalTransformation(world, pos, state, Vector3.blockCenter(pos));
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
        IOrientationHandler oh = this.getOrientationHandler();
        return oh.localToGlobalTransformation(world, pos, state, origin);
    }

    public boolean hasTileEntity(int meta) {
        return this.hasTileEntity(this.getStateFromMeta(meta));
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        if (this.func_149716_u()) {
            return (TE)world.func_147438_o(pos.x, pos.y, pos.z);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getOrientationHandler().onBlockPlaced((Block)this, world, pos, side, hitX, hitY, hitZ, this.getStateFromMeta(meta), placer);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TE te;
        super.func_149726_b(world, x, y, z);
        BlockPos pos = new BlockPos(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (this.hasTileEntity(meta) && (te = this.getTileEntity((IBlockAccess)world, pos)) instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)te).onAddedToWorld();
        }
        this.onBlockAdded(world, pos, this.getStateFromMeta(meta));
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
        this.onBlockPlacedBy(world, pos, state, entity, stack);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        BlockPos pos = new BlockPos(x, y, z);
        this.breakBlock(world, pos, this.getStateFromMeta(meta));
        if (this.hasTileEntity(meta) && (te = world.func_147438_o(x, y, z)) instanceof IInventory) {
            InventoryHelper.dropInventoryItems(world, pos, (IInventory)te);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return this.canHarvestBlock(this.getStateFromMeta(meta), player);
    }

    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return super.canHarvestBlock(player, this.getMetaFromState(state));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        IBlockState state = this.getStateFromMeta(meta);
        return this.onBlockActivated(world, new BlockPos(x, y, z), state, player, BaseUtils.facings[side], hitX, hitY, hitZ);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            return this.isSideSolid(world, new BlockPos(x, y, z), BaseUtils.facings[side.ordinal()]);
        }
        return super.isSideSolid(world, x, y, z, side);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.isSideSolid(world, pos.x, pos.y, pos.z, ForgeDirection.VALID_DIRECTIONS[side.ordinal()]);
    }

    public boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        return this.getWeakChanges(world, new BlockPos(x, y, z));
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return super.getWeakChanges(world, pos.x, pos.y, pos.z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta = world.func_72805_g(x, y, z);
        IBlockState state = this.getStateFromMeta(meta);
        this.onNeighborBlockChange(world, new BlockPos(x, y, z), state, block);
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block block) {
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        IBlockState state = this.getStateFromMeta(meta);
        return this.getStrongPower(world, new BlockPos(x, y, z), state, BaseUtils.facings[side]);
    }

    public int getStrongPower(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        IBlockState state = this.getStateFromMeta(meta);
        return this.getWeakPower(world, new BlockPos(x, y, z), state, BaseUtils.facings[side]);
    }

    public int getWeakPower(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return 0;
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return this.shouldCheckWeakPower(world, new BlockPos(x, y, z), BaseUtils.facings[side]);
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.shouldCheckWeakPower(world, pos.x, pos.y, pos.z, side.ordinal());
    }

    public void spawnAsEntity(World world, BlockPos pos, ItemStack stack) {
        this.func_149642_a(world, pos.x, pos.y, pos.z, stack);
    }

    public int func_149692_a(int meta) {
        return this.damageDropped(this.getStateFromMeta(meta));
    }

    public int damageDropped(IBlockState state) {
        return 0;
    }

    public MapColor func_149728_f(int meta) {
        if (this.mapColor != null) {
            return this.mapColor;
        }
        return super.func_149728_f(meta);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return this.getItemDropped(this.getStateFromMeta(meta), random, fortune);
    }

    public Item getItemDropped(IBlockState state, Random random, int fortune) {
        return super.func_149650_a(this.getMetaFromState(state), random, fortune);
    }

    public boolean func_149686_d() {
        return this.isFullCube();
    }

    public boolean isFullCube() {
        return super.func_149686_d();
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.collisionRayTrace(world, new BlockPos(x, y, z), start, end);
    }

    public MovingObjectPosition collisionRayTrace(World world, BlockPos pos, Vec3 start, Vec3 end) {
        this.boxHit = null;
        MovingObjectPosition result = null;
        double nearestDistance = 0.0;
        IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, null);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB box = list.get(i);
                MovingObjectPosition mp = box.func_72327_a(start, end);
                if (mp == null) continue;
                mp.subHit = i;
                double d = start.func_72436_e(mp.field_72307_f);
                if (result != null && !(d < nearestDistance)) continue;
                result = mp;
                nearestDistance = d;
            }
        }
        if (result != null) {
            int i = result.subHit;
            this.boxHit = list.get(i).func_72317_d((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
            result = BaseUtils.newMovingObjectPosition(result.field_72307_f, result.field_72310_e, pos);
            result.subHit = i;
        }
        return result;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, new BlockPos(x, y, z));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, BlockPos pos) {
        AxisAlignedBB box = this.boxHit;
        if (box == null) {
            IBlockState state = BaseBlockUtils.getWorldBlockState(world, pos);
            box = this.getLocalBounds(world, pos, state, null);
        }
        if (box != null) {
            this.setBlockBounds(box);
        } else {
            super.func_149719_a(world, pos.x, pos.y, pos.z);
        }
    }

    protected AxisAlignedBB getLocalBounds(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        BaseModClient.IModel model = this.getModel(state);
        if (model != null) {
            Trans3 t = this.localToGlobalTransformation(world, pos, state, Vector3.blockCenter);
            return t.t(model.getBounds());
        }
        return null;
    }

    public BaseModClient.IModel getModel(IBlockState state) {
        BaseMod.ModelSpec spec = this.getModelSpec(state);
        if (spec != null) {
            return this.mod.getModel(spec.modelName);
        }
        return null;
    }

    public void setBlockBounds(AxisAlignedBB box) {
        this.func_149676_a((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB clip, List result, Entity entity) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
        this.addCollisionBoxesToList(world, pos, state, clip, result, entity);
    }

    public void addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB clip, List result, Entity entity) {
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, entity);
        if (list != null) {
            for (AxisAlignedBB box : list) {
                if (clip.func_72326_a(box)) {
                    result.add(box);
                    continue;
                }
                super.func_149743_a(world, pos.x, pos.y, pos.z, clip, result, entity);
            }
        }
    }

    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        Trans3 t = this.localToGlobalTransformation(world, pos, state);
        return this.getCollisionBoxes(world, pos, state, t, entity);
    }

    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        Trans3 t = this.localToGlobalTransformation(world, pos, state, Vector3.zero);
        return this.getCollisionBoxes(world, pos, state, t, entity);
    }

    protected List<AxisAlignedBB> getCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Trans3 t, Entity entity) {
        BaseModClient.IModel model = this.getModel(state);
        if (model != null) {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            model.addBoxesToList(t, list);
            return list;
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, new BlockPos(x, y, z));
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return super.getPickBlock(target, world, pos.x, pos.y, pos.z);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        return this.getPlayerRelativeBlockHardness(player, world, new BlockPos(x, y, z));
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, World world, BlockPos pos) {
        return super.func_149737_a(player, world, pos.x, pos.y, pos.z);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.getBlockHardness(world, new BlockPos(x, y, z));
    }

    public float getBlockHardness(World world, BlockPos pos) {
        return super.func_149712_f(world, pos.x, pos.y, pos.z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer er) {
        BlockPos pos = new BlockPos(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        IBlockState state = this.getParticleState((IBlockAccess)world, pos);
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        float f = 0.1f;
        double d0 = (double)i + RANDOM.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)j + RANDOM.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)k + RANDOM.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        switch (target.field_72310_e) {
            case 0: {
                d1 = (double)j + this.func_149665_z() - (double)f;
                break;
            }
            case 1: {
                d1 = (double)j + this.func_149669_A() + (double)f;
                break;
            }
            case 2: {
                d2 = (double)k + this.func_149706_B() - (double)f;
                break;
            }
            case 3: {
                d2 = (double)k + this.func_149693_C() + (double)f;
                break;
            }
            case 4: {
                d0 = (double)i + this.func_149704_x() - (double)f;
                break;
            }
            case 5: {
                d0 = (double)i + this.func_149753_y() + (double)f;
            }
        }
        EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, block, meta);
        er.func_78873_a(fx.func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer er) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.getParticleState((IBlockAccess)world, pos);
        Block block = state.getBlock();
        meta = BaseBlockUtils.getMetaFromBlockState(state);
        int b0 = 4;
        for (int i = 0; i < b0; ++i) {
            for (int j = 0; j < b0; ++j) {
                for (int k = 0; k < b0; ++k) {
                    double d0 = (double)pos.getX() + ((double)i + 0.5) / (double)b0;
                    double d1 = (double)pos.getY() + ((double)j + 0.5) / (double)b0;
                    double d2 = (double)pos.getZ() + ((double)k + 0.5) / (double)b0;
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)pos.getX() - 0.5, d1 - (double)pos.getY() - 0.5, d2 - (double)pos.getZ() - 0.5, block, meta);
                    er.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    public IBlockState getParticleState(IBlockAccess world, BlockPos pos) {
        return BaseBlockUtils.getWorldBlockState(world, pos);
    }

    public int func_149701_w() {
        if (this.canRenderInLayer(EnumWorldBlockLayer.TRANSLUCENT)) {
            return 1;
        }
        return 0;
    }

    public boolean canRenderInPass(int pass) {
        for (EnumWorldBlockLayer layer : BaseModClient.passLayers[pass + 1]) {
            if (!this.canRenderInLayer(layer)) continue;
            return true;
        }
        return false;
    }

    public static class Orient1Way
    implements IOrientationHandler {
        @Override
        public void defineProperties(BaseBlock block) {
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState baseState, EntityLivingBase placer) {
            return baseState;
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
            return new Trans3(origin);
        }
    }

    public static interface IOrientationHandler {
        public void defineProperties(BaseBlock var1);

        public IBlockState onBlockPlaced(Block var1, World var2, BlockPos var3, EnumFacing var4, float var5, float var6, float var7, IBlockState var8, EntityLivingBase var9);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3, Vector3 var4);
    }
}

