/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.ShapeRenderDispatch;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.client.texture.ArchitectureTexture;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RendererCladding
implements ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
    }

    @Override
    public void renderItemStack(ItemStack stack, IRenderTarget target, Trans3 t) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            IIcon sprite;
            IBlockState state;
            String blockName = nbt.func_74779_i("block");
            int meta = stack.func_77960_j();
            Block block = Block.func_149684_b((String)blockName);
            if (block != null && (state = BlockCompatUtils.getBlockStateFromMeta(block, meta)) != null && (sprite = BlockCompatUtils.getSpriteForBlockState(state)) != null) {
                ITexture texture = ArchitectureTexture.fromSprite(sprite);
                texture = ShapeRenderDispatch.checkBlendAndEmissive(state, texture);
                IArchitectureModel model = ArchitectureCraft.mod.getModel("shape/cladding.objson");
                model.render(t, target, texture);
            }
        }
    }
}

