/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.gui.widget;

import gcewing.architecture.client.gui.ArchitectureGui;
import gcewing.architecture.client.gui.widget.IWidget;
import gcewing.architecture.client.gui.widget.IWidgetContainer;
import gcewing.architecture.client.gui.widget.Screen;
import gcewing.architecture.client.gui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class Group
extends Widget
implements IWidgetContainer {
    protected final List<IWidget> widgets = new ArrayList<IWidget>();
    protected IWidget focus;

    @Override
    public IWidget getFocus() {
        return this.focus;
    }

    @Override
    public void setFocus(IWidget widget) {
        this.focus = widget;
    }

    public void add(int left, int top, IWidget widget) {
        widget.setLeft(left);
        widget.setTop(top);
        widget.setParent(this);
        this.widgets.add(widget);
    }

    public void remove(IWidget widget) {
        this.widgets.remove(widget);
        if (this.getFocus() == widget) {
            if (ArchitectureGui.isFocused(this)) {
                ArchitectureGui.tellFocusChanged(widget, false);
            }
            this.setFocus(null);
        }
    }

    @Override
    public void draw(Screen scr, int mouseX, int mouseY) {
        super.draw(scr, mouseX, mouseY);
        for (IWidget w : this.widgets) {
            int dx = w.left();
            int dy = w.top();
            GL11.glPushMatrix();
            GL11.glTranslated((double)dx, (double)dy, (double)0.0);
            w.draw(scr, mouseX - dx, mouseY - dy);
            GL11.glPopMatrix();
        }
    }

    @Override
    public IWidget dispatchMousePress(int x, int y, int button) {
        IWidget target = this.findWidget(x, y);
        if (target != null) {
            return target.dispatchMousePress(x - target.left(), y - target.top(), button);
        }
        return this;
    }

    @Override
    public boolean dispatchKeyPress(char c, int key) {
        IWidget focus = this.getFocus();
        if (focus != null && focus.dispatchKeyPress(c, key)) {
            return true;
        }
        return super.dispatchKeyPress(c, key);
    }

    public IWidget findWidget(int x, int y) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            IWidget w = this.widgets.get(i);
            int l = w.left();
            int t = w.top();
            if (x < l || y < t || x >= l + w.width() || y >= t + w.height()) continue;
            return w;
        }
        return null;
    }

    @Override
    public void layout() {
        for (IWidget w : this.widgets) {
            w.layout();
        }
    }
}

