/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.compat;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.EnumFacing;

public enum Plane implements Predicate<EnumFacing>,
Iterable<EnumFacing>
{
    HORIZONTAL,
    VERTICAL;

    private final int[] axes = new int[]{1, 1, 0, 0, 0, 0};

    public EnumFacing[] facings() {
        EnumFacing[] enumFacingArray;
        switch (this) {
            case HORIZONTAL: {
                EnumFacing[] enumFacingArray2 = new EnumFacing[4];
                enumFacingArray2[0] = EnumFacing.NORTH;
                enumFacingArray2[1] = EnumFacing.EAST;
                enumFacingArray2[2] = EnumFacing.SOUTH;
                enumFacingArray = enumFacingArray2;
                enumFacingArray2[3] = EnumFacing.WEST;
                break;
            }
            case VERTICAL: {
                EnumFacing[] enumFacingArray3 = new EnumFacing[2];
                enumFacingArray3[0] = EnumFacing.UP;
                enumFacingArray = enumFacingArray3;
                enumFacingArray3[1] = EnumFacing.DOWN;
                break;
            }
            default: {
                throw new Error("Someone's been tampering with the universe!");
            }
        }
        return enumFacingArray;
    }

    public EnumFacing random(Random rand) {
        EnumFacing[] aenumfacing = this.facings();
        return aenumfacing[rand.nextInt(aenumfacing.length)];
    }

    public boolean apply(EnumFacing dir) {
        return dir != null && this.axes[dir.ordinal()] == this.ordinal();
    }

    @Override
    public Iterator<EnumFacing> iterator() {
        return Iterators.forArray((Object[])this.facings());
    }
}

