/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import squeek.applecore.ModConfig;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.network.MessageDifficultySync;
import squeek.applecore.network.MessageExhaustionSync;
import squeek.applecore.network.MessageSaturationSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel("AppleCore");
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();
    private EnumDifficulty lastDifficultySetting = null;

    public static void init() {
        channel.registerMessage(MessageDifficultySync.class, MessageDifficultySync.class, 0, Side.CLIENT);
        channel.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        channel.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        SyncHandler syncHandler = new SyncHandler();
        FMLCommonHandler.instance().bus().register((Object)syncHandler);
        MinecraftForge.EVENT_BUS.register((Object)syncHandler);
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        Float lastSaturationLevel = lastSaturationLevels.get(player.func_110124_au());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.func_110124_au());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.func_71024_bL().func_75115_e()) {
            channel.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            lastSaturationLevels.put(player.func_110124_au(), Float.valueOf(player.func_71024_bL().func_75115_e()));
        }
        float exhaustionLevel = AppleCoreAPI.accessor.getExhaustion((EntityPlayer)player);
        if (lastExhaustionLevel == null || (double)Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= ModConfig.EXHAUSTION_SYNC_THRESHOLD) {
            channel.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            lastExhaustionLevels.put(player.func_110124_au(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        lastSaturationLevels.remove(event.player.func_110124_au());
        lastExhaustionLevels.remove(event.player.func_110124_au());
        channel.sendTo((IMessage)new MessageDifficultySync(event.player.field_70170_p.field_73013_u), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.world instanceof WorldServer && this.lastDifficultySetting != event.world.field_73013_u) {
            channel.sendToAll((IMessage)new MessageDifficultySync(event.world.field_73013_u));
            this.lastDifficultySetting = event.world.field_73013_u;
        }
    }
}

