/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixins.minecraft;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.MinecraftForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.mixinplugin.IAppleCorePlayerStats;

@Mixin(value={FoodStats.class})
public abstract class FoodStatsMixin
implements IAppleCorePlayerStats {
    @Unique
    private EntityPlayer entityPlayer;
    @Unique
    private int starveTimer;
    @Shadow
    private int field_75127_a;
    @Shadow
    private int field_75123_d;
    @Shadow
    private float field_75126_c;
    @Shadow
    private int field_75124_e;
    @Shadow
    private float field_75125_b;

    @Override
    public void setPlayer(EntityPlayer entityPlayer) {
        this.entityPlayer = entityPlayer;
    }

    @Shadow
    public abstract void func_75122_a(int var1, float var2);

    @Shadow
    public abstract void func_75113_a(float var1);

    @Inject(method={"addStats"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddStats(int hunger, float saturationModifier, CallbackInfo callbackInfo) {
        FoodEvent.FoodStatsAddition event = new FoodEvent.FoodStatsAddition(this.entityPlayer, new FoodValues(hunger, saturationModifier));
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCancelable() && event.isCanceled()) {
            callbackInfo.cancel();
        }
    }

    public void func_151686_a(ItemFood itemFood, ItemStack itemStack) {
        FoodValues modifiedFoodValues = AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, this.entityPlayer);
        int prevFoodLevel = this.field_75127_a;
        float prevSaturationLevel = this.field_75125_b;
        this.func_75122_a(modifiedFoodValues.hunger, modifiedFoodValues.saturationModifier);
        MinecraftForge.EVENT_BUS.post((Event)new FoodEvent.FoodEaten(this.entityPlayer, itemStack, modifiedFoodValues, this.field_75127_a - prevFoodLevel, this.field_75125_b - prevSaturationLevel));
    }

    public void onUpdate(EntityPlayer player) {
        this.field_75124_e = this.field_75127_a;
        ExhaustionEvent.AllowExhaustion allowExhaustionEvent = new ExhaustionEvent.AllowExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)new ExhaustionEvent.AllowExhaustion(player));
        Event.Result allowExhaustionResult = allowExhaustionEvent.getResult();
        float maxExhaustion = AppleCoreAPI.accessor.getMaxExhaustion(player);
        if (allowExhaustionResult == Event.Result.ALLOW || allowExhaustionResult == Event.Result.DEFAULT && this.field_75126_c >= maxExhaustion) {
            ExhaustionEvent.Exhausted exhaustedEvent = new ExhaustionEvent.Exhausted(player, maxExhaustion, this.field_75126_c);
            MinecraftForge.EVENT_BUS.post((Event)exhaustedEvent);
            this.field_75126_c += exhaustedEvent.deltaExhaustion;
            if (!exhaustedEvent.isCanceled()) {
                this.field_75125_b = Math.max(this.field_75125_b + exhaustedEvent.deltaSaturation, 0.0f);
                this.field_75127_a = Math.max(this.field_75127_a + exhaustedEvent.deltaHunger, 0);
            }
        }
        HealthRegenEvent.AllowRegen allowRegenEvent = new HealthRegenEvent.AllowRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)allowRegenEvent);
        if (allowRegenEvent.getResult() == Event.Result.ALLOW || allowRegenEvent.getResult() == Event.Result.DEFAULT && player.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration") && this.field_75127_a >= 18 && player.func_70996_bM()) {
            ++this.field_75123_d;
            if (this.field_75123_d >= AppleCoreAPI.accessor.getHealthRegenTickPeriod(player)) {
                HealthRegenEvent.Regen regenEvent = new HealthRegenEvent.Regen(player);
                MinecraftForge.EVENT_BUS.post((Event)regenEvent);
                if (!regenEvent.isCanceled()) {
                    player.func_70691_i(regenEvent.deltaHealth);
                    this.func_75113_a(regenEvent.deltaExhaustion);
                }
                this.field_75123_d = 0;
            }
        } else {
            this.field_75123_d = 0;
        }
        StarvationEvent.AllowStarvation allowStarvationEvent = new StarvationEvent.AllowStarvation(player);
        MinecraftForge.EVENT_BUS.post((Event)allowStarvationEvent);
        if (allowStarvationEvent.getResult() == Event.Result.ALLOW || allowStarvationEvent.getResult() == Event.Result.DEFAULT && this.field_75127_a <= 0) {
            ++this.starveTimer;
            if (this.starveTimer >= AppleCoreAPI.accessor.getStarveDamageTickPeriod(player)) {
                StarvationEvent.Starve starveEvent = new StarvationEvent.Starve(player);
                MinecraftForge.EVENT_BUS.post((Event)starveEvent);
                if (!starveEvent.isCanceled()) {
                    player.func_70097_a(DamageSource.field_76366_f, starveEvent.starveDamage);
                }
                this.starveTimer = 0;
            }
        } else {
            this.starveTimer = 0;
        }
    }
}

