/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixinplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import ru.timeconqueror.spongemixins.MinecraftURLClassPath;
import squeek.applecore.mixinplugin.Mixin;
import squeek.applecore.mixinplugin.TargetedMod;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOG = LogManager.getLogger((String)"AppleCore mixins");
    private static final Path MODS_DIRECTORY_PATH = new File(Launch.minecraftHome, "mods/").toPath();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        boolean isDevelopmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        List<TargetedMod> loadedMods = Arrays.stream(TargetedMod.values()).filter(mod -> mod == TargetedMod.VANILLA || mod.loadInDevelopment && isDevelopmentEnvironment || this.loadJarOf((TargetedMod)((Object)mod))).collect(Collectors.toList());
        for (TargetedMod mod2 : TargetedMod.values()) {
            if (loadedMods.contains((Object)mod2)) {
                LOG.info("Found " + mod2.modName + "! Integrating now...");
                continue;
            }
            LOG.info("Could not find " + mod2.modName + "! Skipping integration....");
        }
        ArrayList<String> mixins = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (!mixin.shouldLoad(loadedMods)) continue;
            mixins.add(mixin.mixinClass);
            LOG.debug("Loading mixin: " + mixin.mixinClass);
        }
        return mixins;
    }

    private boolean loadJarOf(TargetedMod mod) {
        try {
            File jar = MixinPlugin.findJarOf(mod);
            if (jar == null) {
                LOG.info("Jar not found for " + (Object)((Object)mod));
                return false;
            }
            LOG.info("Attempting to add " + jar + " to the URL Class Path");
            if (!jar.exists()) {
                throw new FileNotFoundException(jar.toString());
            }
            MinecraftURLClassPath.addJar((File)jar);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File findJarOf(TargetedMod mod) {
        try {
            return Files.walk(MODS_DIRECTORY_PATH, new FileVisitOption[0]).filter(mod::isMatchingJar).map(Path::toFile).findFirst().orElse(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

