/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.helper.NbtHelper;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGravitation
extends TileBaseElectricBlock
implements IInventory,
IEnergyHandlerGC {
    protected double gravity = -0.05;
    private ItemStack[] containingItems = new ItemStack[1];
    protected AxisAlignedBB gravityBox = AxisAlignedBB.func_72330_a((double)-5.0, (double)0.0, (double)-5.0, (double)5.0, (double)5.0, (double)5.0);
    public boolean isBoxShown = false;

    public TileEntityGravitation() {
        this.updateEnergyConsumption();
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_145841_b(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isBoxShown) {
            return this.getActualGravityBox();
        }
        return super.getRenderBoundingBox();
    }

    protected AxisAlignedBB getActualGravityBox() {
        AxisAlignedBB box = this.getRotatedAABB();
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + box.field_72340_a), (double)((double)this.field_145848_d + box.field_72338_b), (double)((double)this.field_145849_e + box.field_72339_c), (double)((double)this.field_145851_c + box.field_72336_d + 1.0), (double)((double)this.field_145848_d + box.field_72337_e + 1.0), (double)((double)this.field_145849_e + box.field_72334_f + 1.0));
    }

    public AxisAlignedBB getRotatedAABB() {
        int rotationMeta = this.getRotationMeta();
        AxisAlignedBB in = this.getGravityBox();
        switch (rotationMeta) {
            case 0: {
                return CoordHelper.cloneAABB(in);
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)(in.field_72336_d * -1.0), (double)in.field_72338_b, (double)(in.field_72334_f * -1.0), (double)(in.field_72340_a * -1.0), (double)in.field_72337_e, (double)(in.field_72339_c * -1.0));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)in.field_72339_c, (double)in.field_72338_b, (double)(in.field_72336_d * -1.0), (double)in.field_72334_f, (double)in.field_72337_e, (double)(in.field_72340_a * -1.0));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)(in.field_72334_f * -1.0), (double)in.field_72338_b, (double)in.field_72340_a, (double)(in.field_72339_c * -1.0), (double)in.field_72337_e, (double)in.field_72336_d);
            }
        }
        return in;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRunning()) {
            this.doGravity();
        }
    }

    public boolean isRunning() {
        return !this.getDisabled(0) && this.hasEnoughEnergyToRun;
    }

    public void setGravityForce(double value) {
        this.gravity = value;
    }

    public double getGravityForce() {
        return this.gravity;
    }

    public AxisAlignedBB getGravityBox() {
        return this.gravityBox;
    }

    public void setGravityBox(AxisAlignedBB box) {
        this.gravityBox = box;
    }

    protected void doGravity() {
        AxisAlignedBB box = this.getActualGravityBox();
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_72872_a(Entity.class, box);
            for (Object e : list) {
                if (e instanceof IAntiGrav) continue;
                Entity ent = (Entity)e;
                if (!(ent instanceof EntityPlayer)) {
                    ent.func_70024_g(0.0, this.gravity, 0.0);
                }
                ent.field_70143_R = (float)((double)ent.field_70143_R - this.gravity * 10.0);
                if (!(ent.field_70143_R < 0.0f)) continue;
                ent.field_70143_R = 0.0f;
            }
        } else {
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, box);
            for (Object e : list) {
                EntityPlayer p = (EntityPlayer)e;
                AmunRa.proxy.handlePlayerArtificalGravity(p, this.gravity);
            }
        }
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack newStack;
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            newStack = this.containingItems[index];
            this.containingItems[index] = null;
        } else {
            newStack = this.containingItems[index].func_77979_a(count);
            if (this.containingItems[index].field_77994_a == 0) {
                this.containingItems[index] = null;
            }
        }
        return newStack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack var2 = this.containingItems[index];
            this.containingItems[index] = null;
            return var2;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containingItems = NbtHelper.readInventory(nbt, this.containingItems.length);
        if (nbt.func_74764_b("gravforce")) {
            double grav = nbt.func_74769_h("gravforce");
            if (grav == 0.0) {
                grav = -0.05;
            }
            this.setGravityForce(grav);
        } else if (nbt.func_74764_b("gravity")) {
            Vector3 grav = new Vector3(nbt.func_74775_l("gravity"));
            this.setGravityForce(grav.y);
        }
        if (nbt.func_74764_b("aabb")) {
            AxisAlignedBB box = NbtHelper.readAABB(nbt.func_74775_l("aabb"));
            this.setGravityBox(box);
        }
        this.updateEnergyConsumption();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NbtHelper.writeInventory(nbt, this.containingItems);
        NBTTagCompound aabbNBT = NbtHelper.getAsNBT(this.gravityBox);
        nbt.func_74780_a("gravforce", this.gravity);
        nbt.func_74782_a("aabb", (NBTBase)aabbNBT);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.gravity.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotNr, ItemStack stack) {
        boolean bl;
        switch (slotNr) {
            case 0: {
                bl = ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public int getRotationMeta(int meta) {
        return (meta & 0xC) >> 2;
    }

    public int getRotationMeta() {
        return (this.func_145832_p() & 0xC) >> 2;
    }

    public ForgeDirection getElectricInputDirection() {
        int metadata = this.getRotationMeta();
        return CoordHelper.rotateForgeDirection(ForgeDirection.NORTH, metadata);
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void updateEnergyConsumption() {
        double strength = Math.abs(this.gravity);
        AxisAlignedBB box = this.getGravityBox();
        Vector3 size = new Vector3(box.field_72336_d - box.field_72340_a + 1.0, box.field_72337_e - box.field_72338_b + 1.0, box.field_72334_f - box.field_72339_c + 1.0);
        double numBlocks = size.x * size.y * size.z;
        float maxExtract = (float)(numBlocks * strength);
        this.storage.setMaxExtract(maxExtract);
    }
}

