/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplay;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelDisplayFluid;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelRequirements;
import de.katzenpapst.amunra.proxy.ARSidedProxy;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineAbstract;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityMothershipEngineJet
extends TileEntityMothershipEngineAbstract {
    protected MothershipFuelDisplay fuelType = null;
    public static Fluid jetFuel;

    public TileEntityMothershipEngineJet() {
        this.boosterBlock = ARBlocks.blockMsEngineRocketBooster;
        this.containingItems = new ItemStack[1];
        this.fuel = jetFuel;
        this.fuelType = new MothershipFuelDisplayFluid(this.fuel);
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public void beginTransit(long duration) {
        MothershipFuelRequirements reqs = this.getFuelRequirements(duration);
        int fuelReq = reqs.get(this.fuelType);
        this.fuelTank.drain(fuelReq, true);
        super.beginTransit(duration);
    }

    @Override
    protected boolean isItemFuel(ItemStack itemstack) {
        FluidStack containedFluid = null;
        Item item = itemstack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem itemContainer = (IFluidContainerItem)item;
            containedFluid = itemContainer.getFluid(itemstack);
        }
        if (containedFluid == null) {
            containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
        }
        if (containedFluid != null) {
            return this.fuel == containedFluid.getFluid();
        }
        return false;
    }

    @Override
    protected int getTankCapacity() {
        return 10000 * this.numBoosters;
    }

    @Override
    protected void startSound() {
        super.startSound();
        AmunRa.proxy.playTileEntitySound((TileEntity)this, new ResourceLocation("amunra:mothership.engine.rocket"));
    }

    @Override
    protected void spawnParticles() {
        Vector3 particleStart = this.getExhaustPosition(1.0);
        Vector3 particleDirection = this.getExhaustDirection().scale(5.0);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_JET_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_JET_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_JET_FLAME, this.field_145850_b, particleStart, particleDirection);
        AmunRa.proxy.spawnParticles(ARSidedProxy.ParticleType.PT_MOTHERSHIP_JET_FLAME, this.field_145850_b, particleStart, particleDirection);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.fuel == fluid) {
            return super.canFill(from, fluid);
        }
        return false;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.mothershipEngineRocket.name");
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0 && stack != null) {
            return this.isItemFuel(stack);
        }
        return false;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0};
    }

    @Override
    public double getThrust() {
        return (double)this.getNumBoosters() * 2000000.0;
    }

    public float getFuelUsagePerTick() {
        return 2.0f;
    }

    @Override
    public MothershipFuelRequirements getFuelRequirements(long duration) {
        int totalFuelNeed = (int)Math.ceil(this.getFuelUsagePerTick() * (float)duration * AmunRa.config.mothershipFuelFactor);
        MothershipFuelRequirements result = new MothershipFuelRequirements();
        result.add(this.fuelType, totalFuelNeed);
        return result;
    }

    @Override
    public boolean canRunForDuration(long duration) {
        MothershipFuelRequirements reqs = this.getFuelRequirements(duration);
        return reqs.get(this.fuelType) <= this.fuelTank.getFluidAmount();
    }
}

