/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.bush;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.block.bush.AbstractSapling;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ARTreeSapling
extends AbstractSapling {
    protected int canopyWidth = 7;
    protected int canopyHeight = 9;
    protected int canopyCenter = 5;
    protected int minStemHeight = 2;

    public ARTreeSapling(String name, String texture) {
        super(name, texture);
    }

    @Override
    public boolean canPlaceOn(BlockMetaPair blockToCheck, int meta) {
        return this.canPlaceOn(blockToCheck.getBlock(), blockToCheck.getMetadata(), meta);
    }

    @Override
    public boolean canPlaceOn(Block blockToCheck, int metaToCheck, int meta) {
        return blockToCheck == ARBlocks.blockMethaneDirt.getBlock() && metaToCheck == ARBlocks.blockMethaneDirt.getMetadata() || blockToCheck == ARBlocks.blockMethaneGrass.getBlock() && metaToCheck == ARBlocks.blockMethaneGrass.getMetadata() || blockToCheck == ARBlocks.blockVacuumGrass.getBlock() && metaToCheck == ARBlocks.blockVacuumGrass.getMetadata();
    }

    protected boolean canGenerateHere(World world, Random rand, int x, int y, int z, int stemHeight, int halfCanopyWidth, int canopyHeight) {
        int curY;
        for (curY = y; curY <= y + stemHeight; ++curY) {
            if (this.canReplaceBlock(world, x, curY, z)) continue;
            return false;
        }
        for (curY = y + stemHeight + 1; curY <= y + 1 + stemHeight + canopyHeight; ++curY) {
            for (int curX = x - halfCanopyWidth; curX <= x + halfCanopyWidth; ++curX) {
                for (int curZ = z - halfCanopyWidth; curZ <= z + halfCanopyWidth; ++curZ) {
                    if (curY >= 0 && curY < 256 && this.canReplaceBlock(world, curX, curY, curZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int y, int z, boolean notify) {
        int curTreeHeight = rand.nextInt(3) + this.minStemHeight + this.canopyHeight;
        int halfWidth = (int)Math.ceil((this.canopyWidth - 1) / 2);
        int halfHeight = (int)Math.ceil((this.canopyHeight - 1) / 2);
        int stemHeight = curTreeHeight - this.canopyHeight;
        int highestYLeaf = 0;
        if (y >= 1 && y + curTreeHeight + 1 <= 256) {
            int meta2;
            if (!this.canGenerateHere(world, rand, x, y, z, stemHeight, halfWidth, this.canopyHeight)) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = this.canPlaceOn(new BlockMetaPair(block2, (byte)(meta2 = world.func_72805_g(x, y - 1, z))), 0);
            if (isSoil && y < 256 - curTreeHeight - 1) {
                int curY;
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                for (curY = y + stemHeight; curY <= y + stemHeight + this.canopyHeight; ++curY) {
                    for (int curX = x - halfWidth; curX <= x + halfWidth; ++curX) {
                        for (int curZ = z - halfWidth; curZ <= z + halfWidth; ++curZ) {
                            double eFactor = this.getEllipsoidFactor(curX - x, curY - y - this.canopyCenter, curZ - z, halfWidth, halfHeight);
                            if (!(eFactor <= 1.0) || eFactor > 0.9 && rand.nextDouble() < 0.5) continue;
                            Block block1 = world.func_147439_a(curX, curY, curZ);
                            if (block1.isAir((IBlockAccess)world, curX, curY, curZ) || block1.isLeaves((IBlockAccess)world, curX, curY, curZ) || this.isBlockReplaceable(block1)) {
                                this.setBlockAndNotifyAdequately(world, curX, curY, curZ, this.leaves.getBlock(), this.leaves.getMetadata(), notify);
                            }
                            if (highestYLeaf >= curY) continue;
                            highestYLeaf = curY;
                        }
                    }
                }
                for (curY = 0; curY < highestYLeaf - y; ++curY) {
                    Block block = world.func_147439_a(x, y + curY, z);
                    if (!block.isAir((IBlockAccess)world, x, y + curY, z) && !block.isLeaves((IBlockAccess)world, x, y + curY, z) && !this.isBlockReplaceable(block)) continue;
                    this.setBlockAndNotifyAdequately(world, x, y + curY, z, this.wood.getBlock(), this.wood.getMetadata(), notify);
                }
                return true;
            }
        }
        return false;
    }

    protected double getEllipsoidFactor(float x, float y, float z, float widthZX, float height) {
        return Math.pow(x, 2.0) / (double)(widthZX * widthZX) + Math.pow(y, 2.0) / (double)(height * height) + Math.pow(z, 2.0) / (double)(widthZX * widthZX);
    }
}

