/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.asteroidWorld;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.astronomy.AngleDistance;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class AmunRaAsteroidWorldProvider
extends WorldProviderAsteroids {
    protected final Set<AsteroidData> asteroids = new HashSet<AsteroidData>();
    protected boolean dataNotLoaded = true;
    protected AsteroidSaveData datafile;
    protected double solarMultiplier = -1.0;

    public abstract CelestialBody getCelestialBody();

    public abstract Class<? extends IChunkProvider> getChunkProviderClass();

    public abstract Class<? extends WorldChunkManager> getWorldChunkManagerClass();

    protected float getRelativeGravity() {
        return 0.1f;
    }

    public float getGravity() {
        return 0.072f;
    }

    public float getFallDamageModifier() {
        return this.getRelativeGravity();
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return this.getRelativeGravity();
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        return 0.0f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= AmunRa.config.planetDefaultTier;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float factor = this.field_76579_a.getSunBrightnessBody(partialTicks) + this.getAmunBrightnessFactor(partialTicks);
        return factor > 1.0f ? 1.0f : factor;
    }

    protected float getAmunBrightnessFactor(float partialTicks) {
        CelestialBody curBody = this.getCelestialBody();
        if (curBody instanceof Moon) {
            curBody = ((Moon)curBody).getParentPlanet();
        }
        AngleDistance ad = AstronomyHelper.projectBodyToSky(curBody, (CelestialBody)AmunRa.instance.starAmun, partialTicks, this.field_76579_a.func_72820_D());
        float brightnessFactor = 1.0f - (MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * (float)Math.PI * 2.0f + ad.angle)) * 2.0f + 0.5f);
        if (brightnessFactor < 0.0f) {
            brightnessFactor = 0.0f;
        }
        if (brightnessFactor > 1.0f) {
            brightnessFactor = 1.0f;
        }
        brightnessFactor = 1.0f - brightnessFactor;
        return (float)((double)brightnessFactor * 0.8 / (double)ad.distance);
    }

    public float getSolarSize() {
        CelestialBody body = this.getCelestialBody();
        if (body instanceof Moon) {
            return 1.0f / ((Moon)body).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
        }
        return 1.0f / body.getRelativeDistanceFromCenter().unScaledDistance;
    }

    public float getThermalLevelModifier() {
        return -0.5f;
    }

    public void addAsteroid(int x, int y, int z, int size, int core) {
        AsteroidData coords = new AsteroidData(x, y, z, size, core);
        if (!this.asteroids.contains(coords)) {
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            if (!this.asteroids.contains(coords)) {
                this.addToNBT(this.datafile.datacompound, coords);
                this.asteroids.add(coords);
            }
        }
    }

    public void removeAsteroid(int x, int y, int z) {
        AsteroidData coords = new AsteroidData(x, y, z);
        if (this.asteroids.contains(coords)) {
            this.asteroids.remove(coords);
            if (this.dataNotLoaded) {
                this.loadAsteroidSavedData();
            }
            this.writeToNBT(this.datafile.datacompound);
        }
    }

    public abstract String getSaveDataID();

    protected void loadAsteroidSavedData() {
        this.datafile = (AsteroidSaveData)this.field_76579_a.func_72943_a(AsteroidSaveData.class, this.getSaveDataID());
        if (this.datafile == null) {
            this.datafile = new AsteroidSaveData(this.getSaveDataID());
            this.field_76579_a.func_72823_a(this.getSaveDataID(), (WorldSavedData)this.datafile);
            this.writeToNBT(this.datafile.datacompound);
        } else {
            this.readFromNBT(this.datafile.datacompound);
        }
        this.dataNotLoaded = false;
    }

    protected void ensureDataLoaded() {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        if (coordList.func_74745_c() > 0) {
            for (int j = 0; j < coordList.func_74745_c(); ++j) {
                NBTTagCompound tag1 = coordList.func_150305_b(j);
                if (tag1 == null) continue;
                this.asteroids.add(AsteroidData.readFromNBT(tag1));
            }
        }
    }

    protected void writeToNBT(NBTTagCompound nbt) {
        NBTTagList coordList = new NBTTagList();
        for (AsteroidData coords : this.asteroids) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            coordList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    protected void addToNBT(NBTTagCompound nbt, AsteroidData coords) {
        NBTTagList coordList = nbt.func_150295_c("coords", 10);
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        coordList.func_74742_a((NBTBase)tag);
        nbt.func_74782_a("coords", (NBTBase)coordList);
        this.datafile.func_76185_a();
    }

    public BlockVec3 getClosestAsteroidXZ(int x, int y, int z) {
        this.ensureDataLoaded();
        if (this.asteroids.size() == 0) {
            return null;
        }
        BlockVec3 result = null;
        AsteroidData resultRoid = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (AsteroidData test : this.asteroids) {
            int dz;
            int dx;
            int a;
            if ((test.sizeAndLandedFlag & 0x80) != 0 || (a = (dx = x - test.centre.x) * dx + (dz = z - test.centre.z) * dz) >= lowestDistance) continue;
            lowestDistance = a;
            result = test.centre;
            resultRoid = test;
        }
        if (result == null) {
            return null;
        }
        resultRoid.sizeAndLandedFlag |= 0x80;
        this.writeToNBT(this.datafile.datacompound);
        return result.clone();
    }

    public ArrayList<BlockVec3> getClosestAsteroidsXZ(int x, int y, int z, int facing, int count) {
        if (this.dataNotLoaded) {
            this.loadAsteroidSavedData();
        }
        if (this.asteroids.size() == 0) {
            return null;
        }
        TreeMap<Integer, BlockVec3> targets = new TreeMap<Integer, BlockVec3>();
        block12: for (AsteroidData roid : this.asteroids) {
            int dz;
            int dx;
            int a;
            BlockVec3 test = roid.centre;
            switch (facing) {
                case 2: {
                    if (z - 16 >= test.z) break;
                    continue block12;
                }
                case 3: {
                    if (z + 16 <= test.z) break;
                    continue block12;
                }
                case 4: {
                    if (x - 16 >= test.x) break;
                    continue block12;
                }
                case 5: {
                    if (x + 16 <= test.x) break;
                    continue block12;
                }
            }
            if ((a = (dx = x - test.x) * dx + (dz = z - test.z) * dz) >= 262144) continue;
            targets.put(a, test);
        }
        int max = Math.max(count, targets.size());
        if (max <= 0) {
            return null;
        }
        ArrayList<BlockVec3> returnValues = new ArrayList<BlockVec3>();
        int i = 0;
        int offset = 6;
        for (BlockVec3 target : targets.values()) {
            BlockVec3 coords = target.clone();
            AmunRa.LOGGER.debug("Found nearby asteroid at {}", new Object[]{target});
            switch (facing) {
                case 2: {
                    coords.z += 6;
                    break;
                }
                case 3: {
                    coords.z -= 6;
                    break;
                }
                case 4: {
                    coords.x += 6;
                    break;
                }
                case 5: {
                    coords.x -= 6;
                }
            }
            returnValues.add(coords);
            if (++i < count) continue;
            break;
        }
        return returnValues;
    }

    public void func_76572_b() {
        super.func_76572_b();
        this.field_76576_e = true;
    }

    public double getSolarEnergyMultiplier() {
        if (this.solarMultiplier < 0.0) {
            this.solarMultiplier = AstronomyHelper.getSolarEnergyMultiplier(this.getCelestialBody(), !this.getCelestialBody().atmosphere.isEmpty());
        }
        return this.solarMultiplier;
    }

    protected static class AsteroidData {
        protected BlockVec3 centre;
        protected int sizeAndLandedFlag = 15;
        protected int coreAndSpawnedFlag = -2;

        public AsteroidData(int x, int y, int z) {
            this.centre = new BlockVec3(x, y, z);
        }

        public AsteroidData(int x, int y, int z, int size, int core) {
            this.centre = new BlockVec3(x, y, z);
            this.sizeAndLandedFlag = size;
            this.coreAndSpawnedFlag = core;
        }

        public AsteroidData(BlockVec3 bv) {
            this.centre = bv;
        }

        public int hashCode() {
            if (this.centre != null) {
                return this.centre.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof AsteroidData) {
                AsteroidData data = (AsteroidData)o;
                BlockVec3 vector = data.centre;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            if (o instanceof BlockVec3) {
                BlockVec3 vector = (BlockVec3)o;
                return this.centre.x == vector.x && this.centre.y == vector.y && this.centre.z == vector.z;
            }
            return false;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("x", this.centre.x);
            tag.func_74768_a("y", this.centre.y);
            tag.func_74768_a("z", this.centre.z);
            tag.func_74768_a("coreAndFlag", this.coreAndSpawnedFlag);
            tag.func_74768_a("sizeAndFlag", this.sizeAndLandedFlag);
            return tag;
        }

        public static AsteroidData readFromNBT(NBTTagCompound tag) {
            BlockVec3 tempVector = new BlockVec3();
            tempVector.x = tag.func_74762_e("x");
            tempVector.y = tag.func_74762_e("y");
            tempVector.z = tag.func_74762_e("z");
            AsteroidData roid = new AsteroidData(tempVector);
            if (tag.func_74764_b("coreAndFlag")) {
                roid.coreAndSpawnedFlag = tag.func_74762_e("coreAndFlag");
            }
            if (tag.func_74764_b("sizeAndFlag")) {
                roid.sizeAndLandedFlag = tag.func_74762_e("sizeAndFlag");
            }
            return roid;
        }
    }

    public class AsteroidSaveData
    extends WorldSavedData {
        public NBTTagCompound datacompound;

        public AsteroidSaveData(String s) {
            super(s);
            this.datacompound = new NBTTagCompound();
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.datacompound = nbt.func_74775_l("asteroids");
        }

        public void func_76187_b(NBTTagCompound nbt) {
            nbt.func_74782_a("asteroids", (NBTBase)this.datacompound);
        }
    }
}

