/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.network.packet;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.mothership.MothershipWorldData;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;

public class ConnectionPacketAR {
    public static final String CHANNEL = "amunra$connection";
    public static FMLEventChannel bus;
    public static final byte ID_MOTHERSHIP_LIST = -106;
    public static final byte ID_CONFIG_OVERRIDE = -105;

    public void handle(ByteBuf payload, EntityPlayer player) {
        NBTTagCompound nbt;
        byte packetId = payload.readByte();
        try {
            nbt = NetworkUtil.readNBTTagCompound((ByteBuf)payload);
        }
        catch (IOException e) {
            AmunRa.LOGGER.error("Could not read NBT data from payload", (Throwable)e);
            return;
        }
        switch (packetId) {
            case -106: {
                if (TickHandlerServer.mothershipData == null) {
                    TickHandlerServer.mothershipData = new MothershipWorldData("ARMothershipData");
                }
                TickHandlerServer.mothershipData.func_76184_a(nbt);
                break;
            }
            case -105: {
                AmunRa.config.setServerOverrideData(nbt);
                break;
            }
        }
    }

    public static FMLProxyPacket createConfigPacket() {
        ByteBuf payload = Unpooled.buffer();
        payload.writeByte(-105);
        NBTTagCompound nbt = AmunRa.config.getServerOverrideData();
        try {
            NetworkUtil.writeNBTTagCompound((NBTTagCompound)nbt, (ByteBuf)payload);
        }
        catch (IOException e) {
            AmunRa.LOGGER.error("Could not write NBT data to payload", (Throwable)e);
        }
        return new FMLProxyPacket(payload, CHANNEL);
    }

    public static FMLProxyPacket createMothershipPacket() {
        ByteBuf payload = Unpooled.buffer();
        payload.writeByte(-106);
        NBTTagCompound nbt = new NBTTagCompound();
        TickHandlerServer.mothershipData.func_76187_b(nbt);
        try {
            NetworkUtil.writeNBTTagCompound((NBTTagCompound)nbt, (ByteBuf)payload);
        }
        catch (IOException e) {
            AmunRa.LOGGER.error("Could not write NBT data to payload", (Throwable)e);
        }
        return new FMLProxyPacket(payload, CHANNEL);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket pkt = event.packet;
        this.onFMLProxyPacketData(event.manager, pkt, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket pkt = event.packet;
        this.onFMLProxyPacketData(event.manager, pkt, (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    public void onFMLProxyPacketData(NetworkManager manager, FMLProxyPacket packet, EntityPlayer player) {
        try {
            if (packet == null || packet.payload() == null) {
                throw new RuntimeException("Empty packet sent to Amunra channel");
            }
            ByteBuf data = packet.payload();
            this.handle(data, player);
        }
        catch (Exception e) {
            AmunRa.LOGGER.error("Amunra login packet handler: Failed to read packet", (Throwable)e);
        }
    }
}

