/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import zeldaswordskills.ref.Config;
import zeldaswordskills.world.gen.feature.WorldGenBombFlowers;
import zeldaswordskills.world.gen.feature.WorldGenJars;
import zeldaswordskills.world.gen.structure.MapGenSecretRoom;
import zeldaswordskills.world.gen.structure.MapGenSecretRoomNether;
import zeldaswordskills.world.gen.structure.MapGenSongPillar;

public class ZSSWorldGenEvent {
    private MapGenSecretRoom secretRoomGen = new MapGenSecretRoom();
    private MapGenSecretRoomNether netherRoomGen = new MapGenSecretRoomNether();
    private MapGenSongPillar pillarGen = new MapGenSongPillar();
    private WorldGenJars jarGen = new WorldGenJars();
    private WorldGenBombFlowers bombGen = new WorldGenBombFlowers();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postPopulate(PopulateChunkEvent.Post event) {
        if (!Config.isGenEnabledAt(event.chunkX, event.chunkZ)) {
            return;
        }
        switch (event.world.field_73011_w.field_76574_g) {
            case -1: {
                if (Config.getNetherAttemptsPerChunk() <= 0) break;
                this.netherRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
            case 0: {
                if (Config.getAttemptsPerChunk() > 0) {
                    this.secretRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                }
                if (Config.doPillarGen()) {
                    this.pillarGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                }
                if (!Config.doBombFlowerGen()) break;
                this.bombGen.generate(event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        block7: {
            if (!Config.isGenEnabledAt(event.chunkX >> 4, event.chunkZ >> 4)) {
                return;
            }
            try {
                if (event.world.field_73011_w.field_76575_d) {
                    for (int n = 0; n < Config.getJarClustersPerChunkNether(); ++n) {
                        if (!(event.rand.nextFloat() < Config.getJarGenChanceNether())) continue;
                        this.jarGen.doJarGen(event.world, event.rand, event.chunkX, event.chunkZ, Config.getJarsPerClusterNether(), true);
                    }
                } else if (event.rand.nextFloat() < Config.getJarGenChance() && event.rand.nextInt(4) == 0) {
                    this.jarGen.doJarGen(event.world, event.rand, event.chunkX, event.chunkZ, Config.getJarsPerCluster(), false);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (e.getMessage() != null && e.getMessage().equals("Already decorating!!") || cause != null && cause.getMessage() != null && cause.getMessage().equals("Already decorating!!")) break block7;
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Post event) {
        block5: {
            if (!Config.isGenEnabledAt(event.chunkX >> 4, event.chunkZ >> 4)) {
                return;
            }
            try {
                if (event.world.field_73011_w.func_76569_d()) {
                    for (int n = 0; n < Config.getJarClustersPerChunkSub(); ++n) {
                        if (!(event.rand.nextFloat() < Config.getJarGenChanceSub())) continue;
                        int i = event.chunkX + event.rand.nextInt(16) + 8;
                        int j = event.rand.nextInt(48) + event.rand.nextInt(48);
                        int k = event.chunkZ + event.rand.nextInt(16) + 8;
                        if (j >= 60) continue;
                        this.jarGen.generate2(event.world, event.rand, i, j, k, Config.getJarsPerClusterSub(), true);
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (e.getMessage() != null && e.getMessage().equals("Already decorating!!") || cause != null && cause.getMessage() != null && cause.getMessage().equals("Already decorating!!")) break block5;
                e.printStackTrace();
            }
        }
    }
}

