/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class MerchantRecipeHelper {
    public static boolean doesListContain(MerchantRecipeList trades, MerchantRecipe recipe) {
        if (recipe == null) {
            return true;
        }
        for (int i = 0; i < trades.size(); ++i) {
            if (!MerchantRecipeHelper.areTradesIdentical(recipe, (MerchantRecipe)trades.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSimilarTrade(MerchantRecipeList trades, MerchantRecipe trade) {
        if (trade == null || trades == null) {
            return false;
        }
        for (int i = 0; i < trades.size(); ++i) {
            MerchantRecipe trade1 = (MerchantRecipe)trades.get(i);
            if (!MerchantRecipeHelper.haveSameTradeItems(trade, trade1)) continue;
            return true;
        }
        return false;
    }

    public static boolean addUniqueTrade(MerchantRecipeList trades, MerchantRecipe trade) {
        if (!MerchantRecipeHelper.doesListContain(trades, trade)) {
            trades.add((Object)trade);
            return true;
        }
        return false;
    }

    public static boolean addToListWithCheck(MerchantRecipeList trades, MerchantRecipe trade) {
        return MerchantRecipeHelper.addToListWithCheck(trades, trade, false);
    }

    public static boolean addToListWithCheck(MerchantRecipeList trades, MerchantRecipe trade, boolean replaceExistingTrade) {
        for (int i = 0; i < trades.size(); ++i) {
            MerchantRecipe merchantrecipe1 = (MerchantRecipe)trades.get(i);
            if (!MerchantRecipeHelper.haveSameTradeItems(trade, merchantrecipe1)) continue;
            if (replaceExistingTrade) {
                trades.set(i, (Object)trade);
                return true;
            }
            return false;
        }
        trades.add((Object)trade);
        return true;
    }

    public static boolean removeTrade(MerchantRecipeList trades, MerchantRecipe trade, boolean exactMatch, boolean removeAll) {
        boolean found = false;
        Iterator iterator = trades.iterator();
        while (iterator.hasNext()) {
            MerchantRecipe recipe = (MerchantRecipe)iterator.next();
            if (!(exactMatch ? MerchantRecipeHelper.areTradesIdentical(trade, recipe) : MerchantRecipeHelper.haveSameTradeItems(trade, recipe))) continue;
            iterator.remove();
            if (!removeAll) {
                return true;
            }
            found = true;
        }
        return found;
    }

    public static boolean haveSameTradeItems(MerchantRecipe a, MerchantRecipe b) {
        ItemStack item1a = a.func_77394_a();
        ItemStack item1b = b.func_77394_a();
        ItemStack item2a = a.func_77397_d();
        ItemStack item2b = b.func_77397_d();
        ItemStack item3a = a.func_77396_b();
        ItemStack item3b = b.func_77396_b();
        if (item1a != null && item1b != null && item1a.func_77973_b() == item1b.func_77973_b() && item1a.func_77960_j() == item1b.func_77960_j() && item2a != null && item2b != null && item2a.func_77973_b() == item2b.func_77973_b() && item2a.func_77960_j() == item2b.func_77960_j()) {
            return item3a == null && item3b == null || item3a != null && item3b != null && item3a.func_77973_b() == item3b.func_77973_b() && item3a.func_77960_j() == item3b.func_77960_j();
        }
        return false;
    }

    public static boolean areTradesIdentical(MerchantRecipe a, MerchantRecipe b) {
        return ItemStack.func_77989_b((ItemStack)a.func_77394_a(), (ItemStack)b.func_77394_a()) && ItemStack.func_77989_b((ItemStack)a.func_77396_b(), (ItemStack)b.func_77396_b()) && ItemStack.func_77989_b((ItemStack)a.func_77397_d(), (ItemStack)b.func_77397_d());
    }
}

