/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.songs;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.entity.ai.EntityAITeleport;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;
import zeldaswordskills.util.WarpPoint;
import zeldaswordskills.world.TeleporterNoPortal;

public class ZeldaSongWarp
extends AbstractZeldaSong {
    public ZeldaSongWarp(String unlocalizedName, int minDuration, SongNote ... notes) {
        super(unlocalizedName, minDuration, notes);
    }

    protected WarpPoint getWarpPoint(EntityPlayer player) {
        WarpPoint warp = ZSSPlayerSongs.get(player).getWarpPoint(this);
        return warp == null ? Config.getDefaultWarpPoint(this) : warp;
    }

    protected boolean canCrossDimensions() {
        return true;
    }

    protected boolean isBlockValid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return block instanceof BlockWarpStone && BlockWarpStone.warpBlockSongs.get(meta) == this;
    }

    @Override
    protected boolean hasEffect(EntityPlayer player, ItemStack instrument, int power) {
        return power > 4;
    }

    @Override
    protected void performEffect(EntityPlayer player, ItemStack instrument, int power) {
        WarpPoint warp = this.getWarpPoint(player);
        int dimension = player.field_70170_p.field_73011_w.field_76574_g;
        if (warp == null) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.null", new Object[0]);
        } else if (!this.canCrossDimensions() && dimension != warp.dimensionId) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.dimension", new Object[0]);
        } else if (dimension == 1 && warp.dimensionId != 1) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.warp.end", new Object[0]);
        } else {
            if (player.field_70154_o != null) {
                player.func_70078_a(null);
            }
            double dx = player.field_70165_t;
            double dy = player.field_70163_u;
            double dz = player.field_70161_v;
            if (dimension != warp.dimensionId) {
                ((EntityPlayerMP)player).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, warp.dimensionId, (Teleporter)new TeleporterNoPortal((WorldServer)player.field_70170_p));
            }
            boolean noBlock = true;
            boolean noAir = false;
            if (this.isBlockValid(player.field_70170_p, warp.x, warp.y, warp.z)) {
                noBlock = false;
                if (!EntityAITeleport.teleportTo(player.field_70170_p, (EntityLivingBase)player, (double)warp.x + 0.5, warp.y + 1, (double)warp.z + 0.5, null, true, false)) {
                    noAir = true;
                }
            }
            if (noBlock || noAir) {
                if (dimension != warp.dimensionId) {
                    ((EntityPlayerMP)player).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, dimension, (Teleporter)new TeleporterNoPortal((WorldServer)player.field_70170_p));
                }
                player.func_70634_a(dx, dy, dz);
                PlayerUtils.sendTranslatedChat(player, noAir ? "chat.zss.song.warp.blocked" : "chat.zss.song.warp.missing", new Object[0]);
            } else {
                PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)player);
            }
        }
    }
}

