/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockAncientTablet;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityBombosFireball;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.server.RefreshSpinPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SpinAttack
extends SkillActive {
    private int charge;
    private float currentSpin;
    private float arc;
    private int refreshed;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private boolean wasKeyPressed;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private boolean isFlaming;
    private boolean isBombos;
    private int superLevel;

    public SpinAttack(String name) {
        super(name);
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        byte temp = this.level;
        if (!this.isActive()) {
            this.superLevel = this.checkHealth(player) ? (int)ZSSPlayerSkills.get(player).getSkillLevel(superSpinAttack) : 0;
            this.level = ZSSPlayerSkills.get(player).getSkillLevel(spinAttack);
        }
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1).replace("super", ""), (Object[])new Object[]{this.superLevel + 1}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
        if (this.getId() == superSpinAttack.getId()) {
            desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getMagicCost()))}));
        }
        this.level = temp;
    }

    @Override
    public boolean canDrop() {
        return this == spinAttack;
    }

    @Override
    public boolean isLoot() {
        return this == spinAttack;
    }

    @Override
    public boolean isActive() {
        return this.arc > 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive() && !this.isCharging();
    }

    @Override
    protected float getExhaustion() {
        return this.refreshed > 0 ? 0.0f : 3.0f - 0.2f * (float)this.level;
    }

    private float getMagicCost() {
        return 5.75f - 0.75f * (float)this.superLevel;
    }

    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    private boolean isCharging() {
        return this.charge > 0;
    }

    private boolean canRefresh(EntityPlayer player) {
        float cost = this.getMagicCost();
        if (this.isBombos && ZSSPlayerInfo.get(player).getCurrentMagic() < 10.0f + cost) {
            this.isBombos = false;
        }
        if (ZSSPlayerInfo.get(player).getCurrentMagic() < cost) {
            return false;
        }
        return this.refreshed < this.superLevel + 1 && this.arc == 360.0f * (float)this.refreshed;
    }

    private float getRange() {
        return 3.0f + (float)(this.superLevel + this.level) * 0.5f;
    }

    private float getSpinSpeed() {
        return 70 + 3 * (this.superLevel + this.level);
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return super.canUse(player) && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return ZSSKeyHandler.keys[3].func_151470_d() || ZSSKeyHandler.keys[4].func_151470_d() || Config.allowVanillaControls && Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return Config.allowVanillaControls && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z) || key == ZSSKeyHandler.keys[3] || key == ZSSKeyHandler.keys[4];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74312_F || key == ZSSKeyHandler.keys[2]) {
            if (this.isActive() && this.canRefresh(player) && this.canExecute(player)) {
                PacketDispatcher.sendToServer(new RefreshSpinPacket());
                this.refreshSpin(player);
                return true;
            }
        } else if (!this.isCharging()) {
            if (this.wasKeyPressed) {
                this.wasKeyPressed = false;
            } else {
                this.clockwise = key == ZSSKeyHandler.keys[4] || key == mc.field_71474_y.field_74366_z;
                this.wasKeyPressed = true;
            }
            if (this.isKeyPressed()) {
                this.wasKeyPressed = false;
                this.charge = this.getChargeTime();
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.currentSpin = 0.0f;
        this.arc = 360.0f;
        this.refreshed = 0;
        int n = this.superLevel = this.checkHealth(player) ? (int)ZSSPlayerSkills.get(player).getSkillLevel(superSpinAttack) : 0;
        if (PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) && PlayerUtils.hasItem(player, ZSSItems.medallion, BlockAncientTablet.EnumType.BOMBOS.ordinal())) {
            this.isBombos = ZSSPlayerInfo.get(player).useMagic(10.0f);
        }
        this.isFlaming = this.isBombos || EnchantmentHelper.func_90036_a((EntityLivingBase)player) > 0;
        this.startSpin(world, player);
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.charge = 0;
        this.currentSpin = 0.0f;
        this.arc = 0.0f;
        this.isBombos = false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (PlayerUtils.isWeapon(player.func_70694_bm()) && player.field_70170_p.field_72995_K && this.isKeyPressed()) {
                if (this.charge < this.getChargeTime() - 1) {
                    Minecraft.func_71410_x().field_71442_b.func_78769_a(player, player.field_70170_p, player.func_70694_bm());
                }
                --this.charge;
                if (this.charge == 0 && this.canExecute(player)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                }
            } else {
                this.charge = 0;
            }
        } else if (this.isActive()) {
            this.incrementSpin(player);
            if (this.isBombos && !player.field_70170_p.field_72995_K) {
                this.spawnFireballs(player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (PlayerUtils.isWeapon(player.func_70694_bm())) {
            List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0);
            for (EntityLivingBase target : list) {
                if (this.targets == null || !this.targets.contains(target)) continue;
                Minecraft.func_71410_x().field_71442_b.func_78764_a(player, (Entity)target);
                this.targets.remove(target);
            }
            this.spawnParticles(player);
            player.field_70733_aJ = 0.5f;
            player.func_70082_c(this.clockwise ? this.getSpinSpeed() : -this.getSpinSpeed(), 0.0f);
        }
        return true;
    }

    private void startSpin(World world, EntityPlayer player) {
        ++this.refreshed;
        if (world.field_72995_K) {
            this.targets = world.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b((double)this.getRange(), 0.0, (double)this.getRange()));
            if (this.targets.contains(player)) {
                this.targets.remove(player);
            }
        } else {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:spinattack", 0.4f, 0.5f);
        }
    }

    private void incrementSpin(EntityPlayer player) {
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.24);
        if (this.currentSpin >= this.arc) {
            this.deactivate(player);
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player.field_70170_p, player);
        }
    }

    private void spawnFireballs(EntityPlayer player) {
        player.field_70170_p.func_72838_d((Entity)new EntityBombosFireball(player.field_70170_p, (EntityLivingBase)player).setDamage(10.0f));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        String particle = this.isFlaming ? "flame" : (this.superLevel > 0 ? "magicCrit" : "crit");
        Vec3 vec3 = player.func_70040_Z();
        double posX = player.field_70165_t + vec3.field_72450_a * (double)this.getRange();
        double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
        double posZ = player.field_70161_v + vec3.field_72449_c * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.field_70170_p.func_72869_a(particle, posX, posY, posZ, vec3.field_72450_a * 0.15, 0.01, vec3.field_72449_c * 0.15);
        }
    }

    public void refreshServerSpin(EntityPlayer player) {
        if (this.canRefresh(player) && super.canUse(player) && PlayerUtils.isWeapon(player.func_70694_bm())) {
            this.refreshSpin(player);
        }
    }

    private void refreshSpin(EntityPlayer player) {
        if (ZSSPlayerInfo.get(player).useMagic(this.getMagicCost())) {
            this.arc += 360.0f;
        }
        if (this.isBombos && !ZSSPlayerInfo.get(player).useMagic(10.0f)) {
            this.isBombos = false;
        }
    }
}

