/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.client.MortalDrawPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class MortalDraw
extends SkillActive {
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;
    private Entity target;

    public MortalDraw(String name) {
        super(name);
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamageMultiplier(), true) + "%");
        desc.add(this.getTimeLimitDisplay(this.getAttackTime() - 30));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 28;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.attackTimer > 25;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private int getDamageMultiplier() {
        return 100 + 10 * this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        this.swordSlot = -1;
        if (super.canUse(player) && player.func_70694_bm() == null && this.attackTimer == 0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !PlayerUtils.isSword(stack)) continue;
                this.swordSlot = i;
                break;
            }
        }
        return this.swordSlot > -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.func_70694_bm() == null && (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() || ZSSKeyHandler.keys[6].func_151470_d());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.attackTimer = this.getAttackTime();
        this.target = null;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.attackTimer = 0;
        this.swordSlot = -1;
        this.target = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.field_70170_p.field_72995_K) {
                this.drawSword(player, null);
                if (player.func_70694_bm() != null) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (!player.field_70170_p.field_72995_K && source.func_76346_g() != null) {
            if (this.target == source.func_76346_g()) {
                return true;
            }
            if (this.attackTimer > 30) {
                if (this.drawSword(player, source.func_76346_g())) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                    this.target = source.func_76346_g();
                    return true;
                }
                this.attackTimer = 30;
                this.target = null;
            }
        }
        return false;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        if (this.attackTimer > 30) {
            this.attackTimer = 30;
            event.ammount *= 1.0f + (float)this.getDamageMultiplier() / 100.0f;
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
        } else {
            this.target = null;
        }
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        boolean flag = false;
        if (this.swordSlot > -1 && this.swordSlot != player.field_71071_by.field_70461_c && player.func_70694_bm() == null) {
            ItemStack sword = player.field_71071_by.func_70301_a(this.swordSlot);
            if (!player.field_70170_p.field_72995_K) {
                player.field_71071_by.func_70299_a(this.swordSlot, null);
            }
            player.func_70062_b(0, sword);
            player.func_110140_aT().func_111147_b(sword.func_111283_C());
            ILockOnTarget skill = ZSSPlayerSkills.get(player).getTargetingSkill();
            flag = skill != null && skill.getCurrentTarget() == attacker;
        }
        this.swordSlot = -1;
        return flag;
    }
}

