/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ArmorBreak
extends SkillActive {
    private int activeTimer = 0;
    private int charge = 0;
    private boolean requiresReset;

    public ArmorBreak(String name) {
        super(name);
    }

    private ArmorBreak(ArmorBreak skill) {
        super(skill);
    }

    @Override
    public ArmorBreak newInstance() {
        return new ArmorBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getChargeDisplay(this.getChargeTime(player)));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    protected boolean allowUserActivation() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getChargeTime(EntityPlayer player) {
        return (PlayerUtils.isHoldingMasterSword((EntityLivingBase)player) ? 15 : 20) - this.level;
    }

    public boolean isCharging(EntityPlayer player) {
        ILockOnTarget target = ZSSPlayerSkills.get(player).getTargetingSkill();
        return this.charge > 0 && target != null && target.isLockedOn();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        boolean bl = this.requiresReset = key == mc.field_71474_y.field_74312_F;
        if (this.requiresReset || key == ZSSKeyHandler.keys[2]) {
            this.charge = this.getChargeTime(player);
            if (this.requiresReset) {
                KeyBinding.func_74510_a((int)mc.field_71474_y.field_74312_F.func_151463_i(), (boolean)true);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyPressed() {
        return ZSSKeyHandler.keys[2].func_151470_d() || Config.allowVanillaControls && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
    }

    @Override
    protected boolean sendClientUpdate() {
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 1;
        ILockOnTarget skill = ZSSPlayerSkills.get(player).getTargetingSkill();
        if (skill != null && skill.isLockedOn()) {
            player.func_71059_n(skill.getCurrentTarget());
        }
        return false;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.charge = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging(player)) {
            if (this.isKeyPressed() && PlayerUtils.isWeapon(player.func_70694_bm())) {
                if (!player.field_82175_bq) {
                    if (this.charge < this.getChargeTime(player) - 1) {
                        Minecraft.func_71410_x().field_71442_b.func_78769_a(player, player.field_70170_p, player.func_70694_bm());
                    }
                    --this.charge;
                }
                if (this.charge == 0) {
                    SwordBasic skill;
                    player.field_70724_aR = 4;
                    player.func_71038_i();
                    if (this.requiresReset) {
                        KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i(), (boolean)false);
                    }
                    if ((skill = (SwordBasic)ZSSPlayerSkills.get(player).getPlayerSkill(swordBasic)) != null && skill.onAttack(player)) {
                        PacketDispatcher.sendToServer(new ActivateSkillPacket(this, true));
                    }
                }
            } else {
                this.charge = 0;
            }
        }
        if (this.isActive()) {
            this.activeTimer = 0;
        }
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.activeTimer = 0;
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
        DirtyEntityAccessor.damageEntity(event.entityLiving, DamageUtils.causeArmorBreakDamage((Entity)player), event.ammount);
        event.ammount = 0.0f;
    }
}

