/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.bidirectional.DeactivateSkillPacket;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public abstract class SkillActive
extends SkillBase {
    protected SkillActive(String name) {
        super(name, true);
    }

    protected SkillActive(SkillActive skill) {
        super(skill);
    }

    protected boolean allowUserActivation() {
        return true;
    }

    public abstract boolean isActive();

    protected abstract float getExhaustion();

    protected boolean autoAddExhaustion() {
        return true;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
    }

    public boolean canUse(EntityPlayer player) {
        return this.level > 0 && (player.field_71075_bZ.field_75098_d || player.func_71024_bL().func_75116_a() > 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        return false;
    }

    protected boolean sendClientUpdate() {
        return true;
    }

    protected abstract boolean onActivated(World var1, EntityPlayer var2);

    protected abstract void onDeactivated(World var1, EntityPlayer var2);

    public final boolean activate(World world, EntityPlayer player) {
        return this.allowUserActivation() ? this.trigger(world, player, false) : false;
    }

    public final void deactivate(EntityPlayer player) throws IllegalStateException {
        if (this.isActive()) {
            this.onDeactivated(player.field_70170_p, player);
            if (this.isActive()) {
                ZSSMain.logger.error(this.getDisplayName() + " is still active after onDeactivated called - this may result in SEVERE errors or even crashes!!!");
            } else if (player.field_70170_p.field_72995_K) {
                PacketDispatcher.sendToServer(new DeactivateSkillPacket(this));
            } else {
                PacketDispatcher.sendTo(new DeactivateSkillPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public final boolean trigger(World world, EntityPlayer player, boolean wasTriggered) {
        if (this.canUse(player)) {
            if (this.autoAddExhaustion() && !player.field_71075_bZ.field_75098_d) {
                player.func_71020_j(this.getExhaustion());
            }
            if (!world.field_72995_K && this.sendClientUpdate()) {
                PacketDispatcher.sendTo(new ActivateSkillPacket(this, wasTriggered), (EntityPlayerMP)player);
            }
            return this.onActivated(world, player);
        }
        if (this.level > 0) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.skill.use.fail", new ChatComponentTranslation(this.getTranslationString(), new Object[0]));
        }
        return false;
    }

    public boolean hasAnimation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        return false;
    }

    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        return false;
    }

    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        return amount;
    }

    @Override
    public final void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("id", this.getId());
        compound.func_74774_a("level", this.level);
    }

    @Override
    public final void readFromNBT(NBTTagCompound compound) {
        this.level = compound.func_74771_c("level");
    }

    @Override
    public final SkillActive loadFromNBT(NBTTagCompound compound) {
        SkillActive skill = (SkillActive)SkillActive.getNewSkillInstance(compound.func_74771_c("id"));
        skill.readFromNBT(compound);
        return skill;
    }
}

