/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UpdateComboPacket;
import zeldaswordskills.skills.SkillBase;

public class Combo {
    private final byte skillId;
    private final int maxComboSize;
    private final int timeLimit;
    private int comboTimer = 0;
    private boolean isFinished = false;
    private final List<Float> damageList = new ArrayList<Float>();
    private float comboDamage = 0.0f;
    private boolean addToLast = false;
    private float lastDamage = 0.0f;
    private Entity lastEntityHit = null;
    private int entityId;
    private int consecutiveHits = 0;

    public Combo(EntityPlayer player, SkillBase skill, int maxComboSize, int timeLimit) {
        this.skillId = skill.getId();
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
        }
    }

    private Combo(byte skillId, int maxComboSize, int timeLimit) {
        this.skillId = skillId;
        this.maxComboSize = maxComboSize;
        this.timeLimit = timeLimit;
    }

    public byte getSkill() {
        return this.skillId;
    }

    public int getNumHits() {
        return this.damageList.size();
    }

    public int getMaxNumHits() {
        return this.maxComboSize;
    }

    public float getDamage() {
        return this.comboDamage;
    }

    public List<Float> getDamageList() {
        return Collections.unmodifiableList(this.damageList);
    }

    public Entity getLastEntityHit() {
        return this.lastEntityHit;
    }

    public int getConsecutiveHits() {
        return this.consecutiveHits;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getLabel() {
        return StatCollector.func_74838_a((String)("combo.label." + this.getNumHits()));
    }

    public void onUpdate(EntityPlayer player) {
        if (this.comboTimer > 0) {
            --this.comboTimer;
            if (this.comboTimer == 0) {
                this.endCombo(player);
            }
        }
    }

    public void add(EntityPlayer player, Entity target, float damage) {
        if (this.getNumHits() < this.maxComboSize && (this.comboTimer > 0 || this.getNumHits() == 0)) {
            if (target != null && target == this.lastEntityHit) {
                ++this.consecutiveHits;
            } else {
                this.lastEntityHit = target;
                int n = this.consecutiveHits = target != null ? 1 : 0;
            }
            if (this.addToLast) {
                this.damageList.add(Float.valueOf(damage + this.lastDamage));
                this.addToLast = false;
                this.lastDamage = 0.0f;
            } else {
                this.damageList.add(Float.valueOf(damage));
            }
            switch (this.damageList.size()) {
                case 3: {
                    player.func_71029_a((StatBase)ZSSAchievements.comboBasic);
                    break;
                }
                case 8: {
                    player.func_71029_a((StatBase)ZSSAchievements.comboPerfect);
                    break;
                }
                case 12: {
                    player.func_71029_a((StatBase)ZSSAchievements.comboLegend);
                }
            }
            this.comboDamage += damage;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
            if (this.getNumHits() == this.maxComboSize) {
                this.endCombo(player);
            } else {
                this.comboTimer = this.timeLimit;
            }
        } else {
            this.endCombo(player);
        }
    }

    public void addDamageOnly(EntityPlayer player, float damage, boolean flag) {
        if (!this.isFinished()) {
            this.comboDamage += damage;
            this.addToLast = flag;
            if (this.addToLast) {
                this.lastDamage = damage;
            }
            if (this.getNumHits() == 0) {
                this.comboTimer = this.timeLimit;
            }
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    public void endCombo(EntityPlayer player) {
        if (!this.isFinished) {
            this.isFinished = true;
            this.lastEntityHit = null;
            this.consecutiveHits = 0;
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new UpdateComboPacket(this), (EntityPlayerMP)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getEntityFromWorld(World world) {
        this.lastEntityHit = world.func_73045_a(this.entityId);
    }

    public final NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("SkillID", this.skillId);
        compound.func_74768_a("MaxSize", this.maxComboSize);
        compound.func_74768_a("TimeLimit", this.timeLimit);
        compound.func_74768_a("CurrentSize", this.getNumHits());
        for (int i = 0; i < this.getNumHits(); ++i) {
            compound.func_74776_a("Dmg" + i, this.damageList.get(i).floatValue());
        }
        compound.func_74776_a("TotalDamage", this.comboDamage);
        compound.func_74768_a("EntityId", this.lastEntityHit != null ? this.lastEntityHit.func_145782_y() : 0);
        compound.func_74768_a("ConsecutiveHits", this.consecutiveHits);
        compound.func_74757_a("Finished", this.isFinished);
        return compound;
    }

    public static final Combo readFromNBT(NBTTagCompound compound) {
        Combo combo = new Combo(compound.func_74771_c("SkillID"), compound.func_74762_e("MaxSize"), compound.func_74762_e("TimeLimit"));
        int size = compound.func_74762_e("CurrentSize");
        for (int i = 0; i < size; ++i) {
            combo.damageList.add(Float.valueOf(compound.func_74760_g("Dmg" + i)));
        }
        combo.comboDamage = compound.func_74760_g("TotalDamage");
        combo.entityId = compound.func_74762_e("EntityId");
        combo.consecutiveHits = compound.func_74762_e("ConsecutiveHits");
        combo.isFinished = compound.func_74767_n("Finished");
        return combo;
    }
}

